% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_learner.R
\name{mltrain}
\alias{mltrain}
\alias{mltrain.baseC5.0}
\alias{mltrain.baseCART}
\alias{mltrain.baseJ48}
\alias{mltrain.baseKNN}
\alias{mltrain.baseMAJORITY}
\alias{mltrain.baseNB}
\alias{mltrain.baseRANDOM}
\alias{mltrain.baseRF}
\alias{mltrain.baseSVM}
\alias{mltrain.default}
\title{Build transformation models}
\usage{
mltrain(object, ...)

\method{mltrain}{default}(object, ...)

\method{mltrain}{baseSVM}(object, ...)

\method{mltrain}{baseJ48}(object, ...)

\method{mltrain}{baseC5.0}(object, ...)

\method{mltrain}{baseCART}(object, ...)

\method{mltrain}{baseRF}(object, ...)

\method{mltrain}{baseNB}(object, ...)

\method{mltrain}{baseKNN}(object, ...)

\method{mltrain}{baseMAJORITY}(object, ...)

\method{mltrain}{baseRANDOM}(object, ...)
}
\arguments{
\item{object}{A \code{mltransformation} object. This is used as a list and
contains at least five values:
 \describe{
   \item{object$data}{A data.frame with the train data, where the columns are
   the attributes and the rows are the examples.}
   \item{object$labelname}{The name of the class column.}
   \item{object$labelindex}{The column index of the class.}
   \item{object$mldataset}{The name of multi-label dataset.}
   \item{object$mlmethod}{The name of the multi-label method.}
 }
 Others values may be specified by the multi-label method.}

\item{...}{Others arguments passed to the base method.}
}
\value{
A model object. The class of this model can be of any type, however,
 this object will be passed to the respective mlpredict method.
}
\description{
Base classifiers are used to build models to solve the the transformation
problems. To create a new base classifier, two steps are necessary:
\enumerate{
  \item Create a train method
  \item Create a prediction method
}
This section is about how to create the first step: a train method.
To create a new predict model see \code{\link{mlpredict}} documentation.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default S3 method

\item \code{baseSVM}: SVM implementation (require \pkg{e1071} package to use)

\item \code{baseJ48}: J48 implementation (require \pkg{RWeka} package to use)

\item \code{baseC5.0}: C5.0 implementation (require \pkg{C50} package to use)

\item \code{baseCART}: CART implementation (require \pkg{rpart} package to use)

\item \code{baseRF}: Random Forest (RF) implementation (require
\pkg{randomForest} package to use)

\item \code{baseNB}: Naive Bayes (NB) implementation (require
\pkg{e1071} package to use)

\item \code{baseKNN}: kNN implementation (require \pkg{kknn} package to use)

\item \code{baseMAJORITY}: Majority model

\item \code{baseRANDOM}: Random model
}}
\section{How to create a new train base method}{

First, is necessary to define a name of your classifier, because this name
determines the method name. The base method name must start with
\code{mltrain.base} followed by the designed name, e.g. a \code{'FOO'}
classify must be defined as \code{mltrain.baseFOO} (we suggest always use
upper case names).

Next, your method must receive at least two parameters (\code{object, ...}).
Use \code{object$data[, object$labelindex]} or
\code{object$data[, object$labelname]} to access the labels values and use
\code{object$data[, -object$labelindex]} to access the predictive attributes.
If you need to know which are the multi-label dataset and method, use
\code{object$mldataset} and \code{object$mlmethod}, respectively.

Finally, your method should return a model that will be used by the mlpredict
method. Remember, that your method may be used to buid binary and multi-class
models.
}
\examples{
# Create a empty model of type FOO
mltrain.baseFOO <- function (object, ...) {
   mymodel <- list(
     classes = as.character(unique(object$data[, object$labelindex]))
   )
   class(mymodel) <- 'fooModel'
   mymodel
}

# Using this base method with Binary Relevance
brmodel <- br(toyml, 'FOO')

\dontrun{

# Create a SVM method using the e1071 package
library(e1071)
mltrain.baseSVM <- function (object, ...) {
   traindata <- object$data[, -object$labelindex]
   labeldata <- object$data[, object$labelindex]
   model <- svm(traindata, labeldata, probability = TRUE, ...)
   model
}
}
}

