% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.data.frame.R
\name{.print.data.frame}
\alias{.print.data.frame}
\title{Print a Data-Frame (allowing column/row separators)}
\usage{
.print.data.frame(
  x,
  ...,
  row.separator = NULL,
  col.separator = NULL,
  sep.extend = FALSE,
  print.gap = 1,
  digits = NULL,
  quote = FALSE,
  right = TRUE,
  row.names = TRUE,
  max = NULL
)
}
\arguments{
\item{x}{A data-frame (object of class \code{data.frame})}

\item{...}{optional arguments to \code{print} or \code{plot} methods}

\item{row.separator}{A vector of values of rows (adds separators after those rows)}

\item{col.separator}{A vector of values of columns (adds separators after those columns)}

\item{sep.extend}{Logical value; if \code{TRUE} the separators are extended into the row/column-names}

\item{print.gap}{A non-negative integer specifyig the number of spaces between columns}

\item{digits}{the minimum number of significant digits to be used: see \code{print.default}}

\item{quote}{Logical value; if \code{TRUE} entries are printed with surrounding quotes}

\item{right}{Logical value; if \code{TRUE} strings are right-aligned}

\item{row.names}{Logical value or character vector; indicating whether (or what) row names are printed}

\item{max}{numeric or \code{NULL}, specifying the maximal number of entries to be printed. By default, when \code{NULL}, \code{getOption("max.print")} used}
}
\value{
Prints the data frame with the specified column/row separators
}
\description{
Custom print method for objects of type \code{data.frame}.  This function prints the data-frame in the same way
as the default \link[base]{print.data.frame} in the base package, except that it allows the user to add textual column/row separators in the
print output in specified positions.  To do this the user adds row/column values for the inputs \code{row.separator}
and \code{col.separator} indicating that separators should be added after those rows/columns.  The user can also
set \code{sep.extend} to \code{TRUE} to extend the separators into the row/column-names.
}
