% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_table.R
\name{build_table.data.frame}
\alias{build_table.data.frame}
\title{Build summary tables from data.frame objects}
\usage{
\method{build_table}{data.frame}(
  .object,
  ...,
  .by,
  .inverse = FALSE,
  .append.stat = TRUE,
  .parametric = FALSE,
  .show.missing = FALSE,
  .show.test = FALSE,
  .na.rm = TRUE,
  .percent.sign = TRUE,
  .digits = 1,
  .p.digits = 4
)
}
\arguments{
\item{.object}{A data.frame.}

\item{...}{One or more unquoted expressions separated by commas representing
columns in the data.frame. May be specified using
\code{\link[tidyselect:select_helpers]{tidyselect helpers}}. If left empty,
all columns are summarized.}

\item{.by}{An unquoted expression. Optional. The data column to stratify the
summary by.}

\item{.inverse}{A logical. Optional. For logical data, report the frequency
of FALSE values instead of the TRUE.}

\item{.append.stat}{A logical. Optionla. Append the type of summary statistic
to the column label.}

\item{.parametric}{A logical. Optional. Use parametric testing.}

\item{.show.missing}{A logical. Optional. Append a column listing the
frequencies of missing data for each row.}

\item{.show.test}{A logical. Optional. Append a column containing the test
each p-value was derived from.}

\item{.na.rm}{A logical. Optional. Ignore NA values when calculating
frequencies for logical and factor data types.}

\item{.percent.sign}{A logical. Optional. Paste a percent symbol after all
reported frequencies.}

\item{.digits}{An integer. Optional. The number of digits to round numbers to.}

\item{.p.digits}{An integer. Optional. The number of p-value digits to report.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} summarizing the
provided object.
}
\description{
Takes a data.frame object and summarizes the columns into a
ready to export, human-readable summary table. Capable of stratifying data
and performing appropriate hypothesis testing.
}
\examples{
library(dplyr)

data_mtcars <- datasets::mtcars \%>\%
  mutate_at(vars('vs', 'am'), as.logical) \%>\%
  mutate_at(vars('gear', 'carb', 'cyl'), as.factor)

# Summarize all columns by cylindars variable
data_mtcars \%>\% build_table(.by = cyl, .show.test = TRUE)

# Summarize specific columns of data
data_mtcars \%>\% build_table(mpg, vs, carb)
}
\seealso{
\code{\link{build_table}}
}
