% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paged_request.R
\name{ustfd_all_pages}
\alias{ustfd_all_pages}
\title{Retrieve multiple pages of Fiscal Data API in a single call}
\usage{
ustfd_all_pages(
  endpoint,
  filter = NULL,
  fields = NULL,
  sort = NULL,
  page_size = 10000,
  slowly = FALSE,
  pause = 0.25,
  quiet = TRUE,
  user_agent = "http://github.com/groditi/ustfd"
)
}
\arguments{
\item{endpoint}{required string representing an API endpoint}

\item{filter}{optional list used to subset the data. known filter operators
are '>', '>=', '<', '<=', '=', and 'in'}

\item{fields}{optional string vector of the fields to be retrieved}

\item{sort}{optional string or string vector. Ordering defaults to ascending,
to specify descending order precede the field name with '-'}

\item{page_size}{optional integer for pagination}

\item{slowly}{pause between http requests when set to \code{TRUE}}

\item{pause}{length, in seconds, to pause}

\item{quiet}{when set to \code{FALSE} updates will be output via a message}

\item{user_agent}{optional string}
}
\value{
a list containing the following items
\itemize{
\item \code{meta} - the metadata returned by the API
\item \code{data} - the payload returned by the API in table form.
See \code{\link[=ustfd_response_payload]{ustfd_response_payload()}}
}
}
\description{
\code{ustfd_all_pages()} is similar to \code{ustfd_simple()} with the difference that,
for requests that generate multiple pages of results, it will request all
pages and merge them into a single result.
}
\examples{
\dontrun{
library(ustfd)

exchange_rates <- ustfd_all_pages(
  'v1/accounting/od/rates_of_exchange',
   fields = c(
    'country_currency_desc', 'exchange_rate','record_date','effective_date'
   ),
   filter = list(
     record_date = c('>=' = '2020-01-01'),
     country_currency_desc = list('in' = c('Canada-Dollar','Mexico-Peso'))
   )
)
}
}
\seealso{
Other ustfd_user: 
\code{\link{endpoint_exists}()},
\code{\link{ustfd_datasets}()},
\code{\link{ustfd_query}()},
\code{\link{ustfd_simple}()},
\code{\link{ustfd_table_columns}()},
\code{\link{ustfd_tables}()}
}
\concept{ustfd_user}
