% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git-default-branch.R
\name{git-default-branch}
\alias{git-default-branch}
\alias{git_default_branch}
\alias{git_default_branch_configure}
\alias{git_default_branch_rediscover}
\alias{git_default_branch_rename}
\title{Get or set the default Git branch}
\usage{
git_default_branch()

git_default_branch_configure(name = "main")

git_default_branch_rediscover(current_local_default = NULL)

git_default_branch_rename(from = NULL, to = "main")
}
\arguments{
\item{name}{Default name for the initial branch in new Git repositories.}

\item{current_local_default}{Name of the local branch that is currently
functioning as the default branch. If unspecified, this can often be
inferred.}

\item{from}{Name of the branch that is currently functioning as the default
branch.}

\item{to}{New name for the default branch.}
}
\value{
Name of the default branch.
}
\description{
The \verb{git_default_branch*()} functions put some structure around the somewhat
fuzzy (but definitely real) concept of the default branch. In particular,
they support new conventions around the Git default branch name, globally or
in a specific project / Git repository.
}
\section{Background on the default branch}{


Technically, Git has no official concept of the default branch. But in
reality, almost all Git repos have an \emph{effective default branch}. If there's
only one branch, this is it! It is the branch that most bug fixes and
features get merged in to. It is the branch you see when you first visit a
repo on a site such as GitHub. On a Git remote, it is the branch that \code{HEAD}
points to.

Historically, \code{master} has been the most common name for the default branch,
but \code{main} is an increasingly popular choice.
}

\section{\code{git_default_branch_configure()}}{

This configures \code{init.defaultBranch} at the global (a.k.a user) level. This
setting determines the name of the branch that gets created when you make the
first commit in a new Git repo. \code{init.defaultBranch} only affects the local
Git repos you create in the future.
}

\section{\code{git_default_branch}}{

This figures out the default branch of the current Git repo, integrating
information from the local repo and, if applicable, the \code{upstream} or
\code{origin} remote. If there is a local vs. remote mismatch,
\code{git_default_branch()} throws an error with advice to call
\code{git_default_branch_rediscover()} to repair the situation.

For a remote repo, the default branch is the branch that \code{HEAD} points to.

For the local repo, if there is only one branch, that must be the default!
Otherwise we try to identify the relevant local branch by looking for
specific branch names, in this order:
\itemize{
\item whatever the default branch of \code{upstream} or \code{origin} is, if applicable
\item \code{main}
\item \code{master}
\item the value of the Git option \code{init.defaultBranch}, with the usual deal where
a local value, if present, takes precedence over a global (a.k.a.
user-level) value
}
}

\section{\code{git_default_branch_rediscover()}}{

This consults an external authority -- specifically, the remote \strong{source
repo} on GitHub -- to learn the default branch of the current project /
repo. If that doesn't match the apparent local default branch (for example,
the project switched from \code{master} to \code{main}), we do the corresponding branch
renaming in your local repo and, if relevant, in your fork.

See \url{https://happygitwithr.com/common-remote-setups.html} for more about
GitHub remote configurations and, e.g., what we mean by the source repo. This
function works for the configurations \code{"ours"}, \code{"fork"}, and \code{"theirs"}.
}

\section{\code{git_default_branch_rename()}}{

Note: this only works for a repo that you effectively own. In terms of
GitHub, you must own the \strong{source repo} personally or, if
organization-owned, you must have \code{admin} permission on the \strong{source repo}.

This renames the default branch in the \strong{source repo} on GitHub and then
calls \code{git_default_branch_rediscover()}, to make any necessary changes in the
local repo and, if relevant, in your personal fork.

See \url{https://happygitwithr.com/common-remote-setups.html} for more about
GitHub remote configurations and, e.g., what we mean by the source repo. This
function works for the configurations \code{"ours"}, \code{"fork"}, and \code{"no_github"}.

Regarding \code{"no_github"}: Of course, this function does what you expect for a
local repo with no GitHub remotes, but that is not the primary use case.
}

\examples{
\dontrun{
git_default_branch()
}
\dontrun{
git_default_branch_configure()
}
\dontrun{
git_default_branch_rediscover()

# you can always explicitly specify the local branch that's been playing the
# role of the default
git_default_branch_rediscover("unconventional_default_branch_name")
}
\dontrun{
git_default_branch_rename()

# you can always explicitly specify one or both branch names
git_default_branch_rename(from = "this", to = "that")
}
}
