% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse.R
\name{browse-this}
\alias{browse-this}
\alias{browse_github}
\alias{browse_github_issues}
\alias{browse_github_pulls}
\alias{browse_travis}
\alias{browse_cran}
\title{Quickly browse to important package webpages}
\usage{
browse_github(package = NULL)

browse_github_issues(package = NULL, number = NULL)

browse_github_pulls(package = NULL, number = NULL)

browse_travis(package = NULL)

browse_cran(package = NULL)
}
\arguments{
\item{package}{Name of package; leave as \code{NULL} to use current package}

\item{number}{For GitHub issues and pull requests. Can be a number or
\code{"new"}.}
}
\description{
These functions take you to various webpages associated with a package and
return the target URL invisibly. Some URLs are formed from first principles
and there is no guarantee there will be content at the destination.
}
\details{
\itemize{
\item \code{browse_github()}: Looks for a GitHub URL in the URL field of
\code{DESCRIPTION}.
\item \code{browse_github_issues()}: Visits the GitHub Issues index or one specific
issue.
\item \code{browse_github_pulls()}: Visits the GitHub Pull Request index or one
specific pull request.
\item \code{browse_travis()}: Visits the package's page on \href{https://travis-ci.org}{Travis CI}.
\item \code{browse_cran()}: Visits the package on CRAN, via the canonical URL.
}
}
\examples{
browse_github("gh")
browse_github_issues("backports")
browse_github_issues("backports", 1)
browse_github_pulls("rprojroot")
browse_github_pulls("rprojroot", 3)
browse_travis("usethis")
browse_cran("MASS")
}
