% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upwaver.R
\name{list_cards}
\alias{list_cards}
\title{Information about the cards on a board}
\usage{
list_cards(organisation, board_id, token)
}
\arguments{
\item{organisation}{A character. The name of the organisation as specified in the URL:
https://<organisation>.upwave.io}

\item{board_id}{An integer. The number of the board you want to inspect as specified in
the URL: https://<organisation>.upwave.io/board/<board_id>/view/}

\item{token}{A character. The API token to access boards on upwave.io. The token can be
obtained by visiting your account settings. Click your profile image, select "Settings"
and find your API-Key in the "Account" tab.}
}
\value{
A list
}
\description{
list_cards() is wrapper around "List Cards" as specified in the 'Upwave' API
https://www.upwave.io/api/. It returns detailed Information about each card of a specific
board as card id, title, board id, description, due_dt, state, color, assigned, ...
}
\examples{
list_cards("ims-fhs", 14351, "a44fa67c5df2acc9836058ffca870d7b78b017cb")
}
