% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mupdog.R
\name{plot_geno}
\alias{plot_geno}
\title{Make a genotype plot.}
\usage{
plot_geno(
  refvec,
  sizevec,
  ploidy,
  p1ref = NULL,
  p1size = NULL,
  p2ref = NULL,
  p2size = NULL,
  geno = NULL,
  seq = 0,
  bias = 1,
  maxpostprob = NULL,
  p1geno = NULL,
  p2geno = NULL,
  use_colorblind = TRUE
)
}
\arguments{
\item{refvec}{A vector of non-negative integers. The number of
reference reads observed in the individuals}

\item{sizevec}{A vector of positive integers. The total number of
reads in the individuals.}

\item{ploidy}{A non-negative integer. The ploidy of the species.}

\item{p1ref}{A vector of non-negative integers. The number of
reference reads observed in parent 1 (if the individuals are
all siblings).}

\item{p1size}{A vector of positive integers. The total number of
reads in parent 1 (if the individuals are
all siblings).}

\item{p2ref}{A vector of non-negative integers. The number of
reference reads observed in parent 2 (if the individuals are
all siblings).}

\item{p2size}{A vector of positive integers. The total number of
reads in parent 2 (if the individuals are
all siblings).}

\item{geno}{The individual genotypes.}

\item{seq}{The sequencing error rate.}

\item{bias}{The bias parameter.}

\item{maxpostprob}{A vector of the posterior probabilities of being at
the modal genotype.}

\item{p1geno}{Parent 1's genotype.}

\item{p2geno}{Parent 2's genotype.}

\item{use_colorblind}{A logical. Should we use a colorblind safe palette (\code{TRUE}),
or not (\code{FALSE})? Only allowed if \code{ploidy <= 6}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object for the genotype plot.
}
\description{
The x-axis is the counts of the non-reference allele,
and the y-axis is the counts of the reference allele.
Transparency is controlled by the \code{maxpostprob}
vector. These types of plots are used in Gerard et. al. (2018) and
Gerard and Ferrão (2019).
}
\details{
If parental genotypes are provided (\code{p1geno} and \code{p2geno}) then
they will be colored the same as the offspring. Since they are often hard to see,
a small black dot will also indicate their position.
}
\examples{
data("snpdat")
refvec  <- snpdat$counts[snpdat$snp == "SNP1"]
sizevec <- snpdat$size[snpdat$snp == "SNP1"]
ploidy  <- 6
plot_geno(refvec = refvec, sizevec = sizevec, ploidy = ploidy)

}
\references{
\itemize{
  \item{Gerard, D., Ferrão, L. F. V., Garcia, A. A. F., & Stephens, M. (2018). Genotyping Polyploids from Messy Sequencing Data. \emph{Genetics}, 210(3), 789-807. doi: \href{https://doi.org/10.1534/genetics.118.301468}{10.1534/genetics.118.301468}.}
  \item{Gerard, D. and Ferrão, L. F. V. (2019). Priors for Genotyping Polyploids. \emph{Bioinformatics}. doi: \href{https://doi.org/10.1093/bioinformatics/btz852}{10.1093/bioinformatics/btz852}.}
}
}
\author{
David Gerard
}
