% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/updog.R
\name{dbetabinom}
\alias{dbetabinom}
\alias{pbetabinom}
\alias{qbetabinom}
\alias{rbetabinom}
\alias{betabinom}
\title{The Beta-Binomial Distribution}
\usage{
dbetabinom(x, size, mu, rho, log)

pbetabinom(q, size, mu, rho, log_p)

qbetabinom(p, size, mu, rho)

rbetabinom(n, size, mu, rho)
}
\arguments{
\item{x, q}{A vector of quantiles.}

\item{size}{A vector of sizes.}

\item{mu}{Either a scalar of the mean for each observation,
or a vector of means of each observation, and thus
the same length as \code{x} and \code{size}. This must
be between 0 and 1.}

\item{rho}{Either a scalar of the overdispersion parameter
for each observation, or a vector of overdispersion
parameters of each observation, and thus the same length as
\code{x} and \code{size}. This must be between 0 and 1.}

\item{log, log_p}{A logical vector either of length 1 or the same
length as \code{x} and \code{size}. This determines whether
to return the log probabilities for all observations
(in the case that its length is 1) or for
each observation (in the case that
its length is that of \code{x} and \code{size}).}

\item{p}{A vector of probabilities.}

\item{n}{The number of observations.}
}
\value{
Either a random sample (\code{rbetabinom}),
    the density (\code{dbetabinom}), the tail
    probability (\code{pbetabinom}), or the quantile
    (\code{qbetabinom}) of the beta-binomial distribution.
}
\description{
Density, distribution function, quantile function and random generation
for the beta-binomial distribution when parameterized
by the mean \code{mu} and the overdispersion parameter \code{rho}
rather than the typical shape parameters.
}
\details{
Let \eqn{\mu} and \eqn{\rho} be the mean and overdispersion parameters.
Let \eqn{\alpha} and \eqn{\beta} be the usual shape parameters of
a beta distribution. Then we have the relation
\deqn{\mu = \alpha/(\alpha + \beta),}
and
\deqn{\rho = 1/(1 + \alpha + \beta).}
This necessarily means that
\deqn{\alpha = \mu (1 - \rho)/\rho,}
and
\deqn{\beta = (1 - \mu) (1 - \rho)/\rho.}
}
\section{Functions}{
\itemize{
\item \code{dbetabinom}: Density function.

\item \code{pbetabinom}: Distribution function.

\item \code{qbetabinom}: Quantile function.

\item \code{rbetabinom}: Random generation.
}}

\examples{
x <- rbetabinom(n = 10, size = 10, mu = 0.1, rho = 0.01)
dbetabinom(x = 1, size = 10, mu = 0.1, rho = 0.01, log = FALSE)
pbetabinom(q = 1, size = 10, mu = 0.1, rho = 0.01, log_p = FALSE)
qbetabinom(p = 0.6, size = 10, mu = 0.1, rho = 0.01)


}
\author{
David Gerard
}
