% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlbetapr.R
\name{mlbetapr}
\alias{mlbetapr}
\title{Beta prime distribution maximum likelihood estimation}
\usage{
mlbetapr(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{passed to \code{\link{mlbeta}}.}
}
\value{
\code{mlbetapr} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
\code{shape1} and \code{shape2} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
This function does not estimate the scale parameter for the \code{BetaPrime}
distribution. Transforms the data and uses \code{stat::nlm} to estimate
the parameters of the Beta distribution.
}
\details{
For the density function of the Beta prime distribution see
\link[extraDistr:BetaPrime]{BetaPrime}.

For \code{type}, the option \code{none} is fastest.
}
\examples{
AIC(mlbetapr(USArrests$Rape))
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995)
Continuous Univariate Distributions, Volume 2, Chapter 25. Wiley, New York.
}
\seealso{
\link[extraDistr:BetaPrime]{BetaPrime} for the Beta prime density,
\link[stats:nlm]{nlm} for the optimizer this function uses, \link{mlbeta} for
the Beta distribution maximum likelihood estimator.
}
