% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unigd.R
\name{ugd_save}
\alias{ugd_save}
\title{Render unigd plot to a file.}
\usage{
ugd_save(
  file,
  page = 0,
  width = -1,
  height = -1,
  zoom = 1,
  as = "auto",
  which = dev.cur()
)
}
\arguments{
\item{file}{Filepath to save plot.}

\item{page}{Plot page to render. If this is set to \code{0}, the last page will
be selected. Can be set to a numeric plot index or plot ID
(see \code{\link[=ugd_id]{ugd_id()}}).}

\item{width}{Width of the plot. If this is set to \code{-1}, the last width will
be selected.}

\item{height}{Height of the plot. If this is set to \code{-1}, the last height
will be selected.}

\item{zoom}{Zoom level. (For example: \code{2} corresponds to 200\%, \code{0.5} would
be 50\%.)}

\item{as}{Renderer. When set to \code{"auto"} renderer is inferred from the file
extension.}

\item{which}{Which device (ID).}
}
\value{
No return value. Plot will be saved to file.
}
\description{
See \code{\link[=ugd_render]{ugd_render()}} for accessing plot data directly in memory without
saving as a file.
This function will only work after starting a device with \code{\link[=ugd]{ugd()}}.
}
\examples{
ugd()

plot(1, 1)

tf <- tempfile()
on.exit(unlink(tf))

ugd_save(file = tf, width = 600, height = 400, as = "png")

dev.off()
}
