% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Magdeburg.R
\docType{data}
\name{uni_magdeburg_2}
\alias{uni_magdeburg_2}
\title{Faculty colors of the University of Magdeburg, Germany}
\format{
An object of class \code{character} of length 27.
}
\source{
Color definitions are based on the \href{https://www.ovgu.de/}{OVGU}'s 
\href{https://www.cd.ovgu.de/Logo_+Farbe_+Schrift/Farbe.html}{Corporate design} guidelines (HTML).
}
\usage{
uni_magdeburg_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_magdeburg_2} provides the faculty colors 
of the \href{https://www.ovgu.de/}{Otto von Guericke University Magdeburg} (OVGU), Germany.
}
\details{
The pre-defined set of faculty colors allows to target publications and presentations 
to each faculty, allowing for visual differentiation between different units.

Using a set of faculty colors usually prevents the use of the primary university color (and vice versa). 

\code{uni_magdeburg_2} is based on RGB color definitions.


Just as the primary \code{OVGU rot}, each faculty color should be used 
next to the logo for emphasis purposes.
Large areas of a faculty color obstruct a fresh and young appeal of a publication 
and should only be used in special cases. 

Whereas the background \code{white} is only implicitly perceived, 
it is the most important corporate design element of the OVGU. 
White areas are not wasted space, but rather necessary elements to structure content, 
reveal connections, set accents, and improve readability.

See \code{\link{uni_magdeburg_3}} for the colors of the medical faculty and university hospital 
of the \href{https://www.ovgu.de/}{OVGU Magdeburg}.
}
\examples{
uni_magdeburg_2
unikn::seecol(uni_magdeburg_2, col_bg = "grey90", 
              main = "Faculty colors of the Uni Magdeburg (OVGU)")  # view entire palette
              
# Using a partial palette: 
unikn::demopal(uni_magdeburg_2[c(19:21, 25:27)], type = 4, seed = 123, 
               main = "Colors of the Natural Sciences of the OVGU Magdeburg")
              
}
\seealso{
\code{\link{uni_magdeburg_1}} for primary colors of the OVGU Magdeburg;
\code{\link{uni_magdeburg_3}} for medical and hospital colors of the OVGU Magdeburg;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0}},
\code{\link{fu_1}},
\code{\link{fu_2}},
\code{\link{fu_3}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2023-10-03.
}
\concept{German university color palettes}
\keyword{datasets}
