% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Northwestern.R
\docType{data}
\name{northwestern_2}
\alias{northwestern_2}
\title{Secondary colors of Northwestern University, USA}
\format{
An object of class \code{character} of length 12.
}
\source{
Color definitions are based on the
\href{https://www.northwestern.edu/brand/visual-identity/color-palettes/}{Color manual}.
}
\usage{
northwestern_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{northwestern_2} provides the 12 secondary colors
of the \href{https://www.northwestern.edu}{Northwestern University}, USA.
}
\details{
The secondary colors should be used rarely and sparingly.
Under no circumstances should any of them become the predominant color for a school, center, institute or department.

These colors are
\code{"bright_green"} (defined as CMYK 68,00,100,00, RGB 88,185,71, HEX #58B947),
\code{"bright_blue"} (defined as CMYK 48/00/22/00, RGB 127/206/205, HEX #7FCECD),
\code{"bright_ocean"} (defined as CMYK 68/34/00/00, RGB 80/145/205, HEX #5091CD),
\code{"bright_yellow"} (defined as CMYK 10/00/89/00, RGB 237/233/59, HEX #EDE93B),
\code{"bright_orange"} (defined as CMYK 00/23/95/00, RGB 255/197/32, HEX #FFC520),
\code{"bright_red"} (defined as CMYK 01/82/80/00, RGB 239/085/063, HEX #EF553F),
\code{"dark_green"} (defined as CMYK 87/24/83/09, RGB 000/134/086, HEX #008656),
\code{"dark_blue"} (defined as CMYK 86/39/23/01, RGB 000/127/164, HEX #007FA4),
\code{"dark_ocean"} (defined as CMYK 100/85/05/36, RGB 013/045/108, HEX #0D2D6C),
\code{"dark_yellow"} (defined as CMYK 18/14/100/0, RGB 217/200/038, HEX #D9C826),
\code{"dark_orange1"} (defined as CMYK 00/48/97/21, RGB 202/124/027, HEX #CA7C1B), and
\code{"dark_orange2"} (defined as CMYK 02/77/100/09, RGB 216/088/032, HEX #D85820.
}
\examples{
northwestern_2
unikn::seecol(northwestern_2, main = "Secondary colors of NW") # view color palette

}
\seealso{
\code{\link{northwestern_1}} for primary colors of Northwestern University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2}},
\code{\link{stanford_3}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
