% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bangor.R
\docType{data}
\name{bangor_2}
\alias{bangor_2}
\title{Secondary colours of the University of Bangor, Wales}
\format{
An object of class \code{character} of length 16.
}
\source{
Colour definitions are based on \href{https://www.bangor.ac.uk}{Bangor}'s 
Brand guidelines (PDF).
}
\usage{
bangor_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{bangor_2} provides sixteen secondary colours 
of the \href{https://www.bangor.ac.uk}{University of Bangor}, Wales, UK.
}
\details{
\code{bangor_2} is based on HEX color definitions  
(see \href{https://www.bangor.ac.uk}{Bangor}'s 
Brand guidelines, PDF, p. 10, for names and details).


Motto: We are modern, forward thinkers.

Supporting the primary colourways is a palette of sixteen colours 
carefully bringing together distinctive tones with bolder colours to 
allow flexibility and freedom -- but always used thoughtfully following 
\href{https://www.bangor.ac.uk}{Bangor}'s key principles for using colour. 

The colours reflect \href{https://www.bangor.ac.uk}{Bangor}'s brand and university. 
Bold, confident, modern, energised and ambitious. 
These tones represent the \href{https://www.bangor.ac.uk}{Bangor} brand 
ambitions and beliefs, and are to be used in all marketing communications.
}
\examples{
bangor_2
unikn::seecol(bangor_2, col_bg = "grey96",
              main = "Secondary colours of the University of Bangor, Wales")  # view palette

}
\seealso{
\code{\link{bangor_1}} for primary corporate colours of Bangor;
\code{\link{bangor_3}} for tertiary colours of Bangor;
\code{\link{bangor_4}} for accessible web colours of Bangor;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Welsh university color palettes: 
\code{\link{aberystwyth_1}},
\code{\link{aberystwyth_2}},
\code{\link{bangor_1}},
\code{\link{bangor_3}},
\code{\link{bangor_4}},
\code{\link{cardiff_1}},
\code{\link{cardiff_2}}
}
\author{
\strong{unicol}, 2023-10-10.
}
\concept{Welsh university color palettes}
\keyword{datasets}
