## Concordia.R | 2023 09 28
## Colours of Concordia University, Canada
## ---------------------------------------

# Information: ------

# cur_pals: "concordia_1", "concordia_2", "concordia_3", "concordia_4" (4)
# inst: "Concordia University" (in English)
# inst_alt: "Concordia / CU"
# country: Canada
# URL: "https://www.concordia.ca"

# Color source:
# color_URL: <https://www.concordia.ca/web/design/ui-kit-style-guide-accessibility/web-palette-new.html>
# Last check: ???


# Colors: ------ 

# Color palette(s):


# - concordia_1: Primary colours of Concordia ------

#' Primary colours of Concordia University, Canada 
#'
#' \code{concordia_1} provides the eight primary colours 
#' of \href{https://www.concordia.ca}{Concordia University}, Canada.
#'
#' The 8 primary colours are
#' \code{"Burgundy"} (defined as HEX #912338), 
#' \code{"Magenta"} (defined as HEX #db0272), 
#' \code{"Orange"} (defined as HEX #da3a16),
#' \code{"Mauve"} (defined as HEX #573996),
#' \code{"Dark"} (defined as HEX #004085),
#' \code{"Blue"} (defined as HEX #0072a8),
#' \code{"Turquoise"} (defined as HEX #057d78), and
#' \code{"Grenn"} (defined as HEX #508212).
#'
#' \code{concordia_1} uses the HEX color definitions. 
#' 
#' @return 
#' A named vector of colors (HEX/HTML codes of type character).
#'
#' @author 
#' \strong{unicol}, 2023-06-26.
#'
#' @source 
#' Color definitions are based on \href{https://www.concordia.ca}{Concordia}'s 
#' \href{https://www.concordia.ca/web/design/ui-kit-style-guide-accessibility/web-palette-new.html}{web colour palette}. 
#'
#' @examples
#' concordia_1
#' unikn::seecol(concordia_1, main = "Primary colours of Concordia University, CA")  # view palette
#'
#' @family Canadian university color palettes
#'
#' @seealso
#' \code{\link{concordia_2}} for secondary colours of Concordia University;
#' \code{\link{concordia_3}} for background tints of Concordia University;
#' \code{\link{concordia_4}} for neutral colours of Concordia University;
#' \code{\link{seecol}} for viewing and comparing color palettes;
#' \code{\link{usecol}} for using color palettes;
#' \code{\link{simcol}} for finding similar colors;
#' \code{\link{newpal}} for defining new color palettes;
#' \code{\link{grepal}} for finding named colors.
#'
#' @export

concordia_1 <- unikn::newpal(col = c("#912338", "#db0272", "#da3a16", "#573996", 
                                     "#004085", "#0072a8", "#057d78", "#508212" ),
                             names = c("Burgundy", "Magenta", "Orange", "Mauve", 
                                       "Dark blue", "Blue", "Turquoise", "Grenn"),
                             as_df = FALSE)




# - concordia_2: Secondary colours of Concordia ------

#' Secondary colours of Concordia University, Canada 
#'
#' \code{concordia_2} provides the four secondary colours 
#' of \href{https://www.concordia.ca}{Concordia University}, Canada.
#'
#' The 4 secondary colours are
#' \code{"Yellow"} (defined as HEX #e5a712),
#' \code{"Gold"} (defined as HEX #cbb576), 
#' \code{"Cyan"} (defined as HEX #00adef), and
#' \code{"Lime"} (defined as HEX #8cc63e).
#'
#' \code{concordia_2} uses the HEX color definitions. 
#' 
#' @return 
#' A named vector of colors (HEX/HTML codes of type character).
#'
#' @author 
#' \strong{unicol}, 2023-06-26.
#'
#' @source 
#' Color definitions are based on \href{https://www.concordia.ca}{Concordia}'s 
#' \href{https://www.concordia.ca/web/design/ui-kit-style-guide-accessibility/web-palette-new.html}{web colour palette}. 
#'
#' @examples
#' concordia_2
#' unikn::seecol(concordia_2, main = "Secondary colours of Concordia University")  # view palette
#'
#' @family Canadian university color palettes
#'
#' @seealso
#' \code{\link{concordia_1}} for primary colours of Concordia University;
#' \code{\link{concordia_3}} for background tints of Concordia University;
#' \code{\link{concordia_4}} for neutral colours of Concordia University;
#' \code{\link{seecol}} for viewing and comparing color palettes;
#' \code{\link{usecol}} for using color palettes;
#' \code{\link{simcol}} for finding similar colors;
#' \code{\link{newpal}} for defining new color palettes;
#' \code{\link{grepal}} for finding named colors.
#'
#' @export

concordia_2 <- unikn::newpal(col = c("#e5a712", "#cbb576", "#00adef", "#8cc63e"),
                             names = c("Yellow", "Gold", "Cyan", "Lime"),
                             as_df = FALSE)



# - concordia_3: Background colours of Concordia ------

#' Background tints of Concordia University, Canada 
#'
#' \code{concordia_3} provides the nine background tints  
#' of \href{https://www.concordia.ca}{Concordia University}, Canada.
#'
#' The 9 background tints are
#' \code{"Burgundy 1"} (defined as HEX #E9D3D7),
#' \code{"Magenta 1"} (defined as HEX #FACDE3), 
#' \code{"Orange 1"} (defined as HEX #f9cdc3),
#' \code{"Mauve 1"} (defined as HEX #dcd6e8),
#' \code{"Dark blue 1"} (defined as HEX #B2C5DA),
#' \code{"Blue 1"} (defined as HEX #d3e1e9),
#' \code{"Turquoise 1"} (defined as HEX #CCE3E4),
#' \code{"Green 1"} (defined as HEX #dfeccf), and
#' \code{"Gold 1"} (defined as HEX #e9e3d3).
#'
#' \code{concordia_3} uses the HEX color definitions. 
#' 
#' @details
#' The background tint colours of \code{concordia_3} 
#' can be used to create blocks of background colour on a web page 
#' to separate and draw attention to content. 
#' 
#' @return 
#' A named vector of colors (HEX/HTML codes of type character).
#'
#' @author 
#' \strong{unicol}, 2023-06-26.
#'
#' @source 
#' Color definitions are based on \href{https://www.concordia.ca}{Concordia}'s 
#' \href{https://www.concordia.ca/web/design/ui-kit-style-guide-accessibility/web-palette-new.html}{web colour palette}. 
#' 
#' @examples
#' concordia_3
#' unikn::seecol(concordia_3, main = "Background tints of Concordia University")  # view palette
#'
#' @family Canadian university color palettes
#'
#' @seealso
#' \code{\link{concordia_1}} for primary colours of Concordia University;
#' \code{\link{concordia_2}} for secondary colours of Concordia University;
#' \code{\link{concordia_4}} for neutral colours of Concordia University;
#' \code{\link{seecol}} for viewing and comparing color palettes;
#' \code{\link{usecol}} for using color palettes;
#' \code{\link{simcol}} for finding similar colors;
#' \code{\link{newpal}} for defining new color palettes;
#' \code{\link{grepal}} for finding named colors.
#'
#' @export

concordia_3 <- unikn::newpal(col = c("#E9D3D7", "#FACDE3", "#f9cdc3", "#dcd6e8", "#B2C5DA", 
                                     "#d3e1e9", "#CCE3E4", "#dfeccf", "#e9e3d3"),
                             names = c("Burgundy 1", "Magenta 1", "Orange 1", "Mauve 1", "Dark blue 1", 
                                       "Blue 1", "Turquoise 1", "Green 1", "Gold 1"),
                             as_df = FALSE)





# - concordia_4: Neutral colours of Concordia ------

#' Neutral colours of Concordia University, Canada 
#'
#' \code{concordia_4} provides the five neutral colours 
#' of \href{https://www.concordia.ca}{Concordia University}, Canada.
#'
#' The 5 neutral colours are 
#' \code{"Light grey"} (defined as HEX #f0f0f0),
#' \code{"Medium grey"} (defined as HEX #c8c8c8), 
#' \code{"Dark grey"} (defined as HEX #6e6e6e),
#' \code{"Very dark grey"} (defined as HEX #2c2c2c), and
#' \code{"black"} (defined as HEX #000000).
#'
#' \code{concordia_4} uses the HEX color definitions. 
#' 
#' @return 
#' A named vector of colors (HEX/HTML codes of type character).
#'
#' @author 
#' \strong{unicol}, 2023-06-26.
#'
#' @source 
#' Color definitions are based on \href{https://www.concordia.ca}{Concordia}'s 
#' \href{https://www.concordia.ca/web/design/ui-kit-style-guide-accessibility/web-palette-new.html}{web colour palette}. 
#' 
#' @examples
#' concordia_4
#' unikn::seecol(concordia_4, main = "Neutral colours of Concordia University") # view color palette
#'
#' @family Canadian university color palettes
#'
#' @seealso
#' \code{\link{concordia_1}} for primary colours of Concordia University;
#' \code{\link{concordia_2}} for secondary colours of Concordia University;
#' \code{\link{concordia_3}} for background tints of Concordia University;
#' \code{\link{seecol}} for viewing and comparing color palettes;
#' \code{\link{usecol}} for using color palettes;
#' \code{\link{simcol}} for finding similar colors;
#' \code{\link{newpal}} for defining new color palettes;
#' \code{\link{grepal}} for finding named colors.
#'
#' @export

concordia_4 <- unikn::newpal(col = c("#f0f0f0", "#c8c8c8", "#6e6e6e", "#2c2c2c", 
                                     "#000000"),
                             names = c("Light grey", "Medium grey", "Dark grey", "Very dark grey", 
                                       "black"),
                             as_df = FALSE)

# # Check: 
# unikn::seecol(concordia_1, main = "Primary colours of Concordia University", col_bg = "white")
# unikn::seecol(concordia_2, main = "Secondary colours of Concordia University", col_bg = "white")
# unikn::seecol(concordia_3, main = "Background colours of Concordia University", col_bg = "white")
# unikn::seecol(concordia_4, main = "Neutral colours of Concordia University", col_bg = "white")



## ToDo: -------- 

# - etc.

## eof. ----------
