% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wollongong.R
\docType{data}
\name{wollongong_2}
\alias{wollongong_2}
\title{Secondary colours of the University of Wollongong, Australia}
\format{
An object of class \code{character} of length 2.
}
\source{
Color definitions are based on UOW's  
\href{https://www.uow.edu.au/brand/brand-system/colour/}{colour guide}.
}
\usage{
wollongong_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{wollongong_2} provides the two secondary colours 
of the \href{https://www.uow.edu.au}{University of Wollongong}, NSW, Australia.
}
\details{
The 2 secondary colours are 
\code{"black"} (defined as HEX \code{"#000000"}), and 
\code{Light grey} (defined as HEX \code{"#F2F2F2"}).


The secondary colour palette is used in support of our primary palette when limited colour application is available. 

In this situation, \code{"black"} replaces \code{Dark blue} and 
\code{Light grey} can be used as an alternative background colour to \code{"white"}.

Refer to the \href{https://www.uow.edu.au/brand/brand-system/colour/}{colour guide} 
for official breakdowns and accessibility guidance.
}
\examples{
wollongong_2
unikn::seecol(wollongong_2, 
              main = "Secondary colours of the University of Wollongong") # view color palette

}
\seealso{
\code{\link{wollongong_1}} for primary colours of the University of Wollongong;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Australian university color palettes: 
\code{\link{ANU_1}},
\code{\link{ANU_2}},
\code{\link{mq_1}},
\code{\link{mq_2}},
\code{\link{wollongong_1}}
}
\author{
\strong{unicol}, 2023-09-06.
}
\concept{Australian university color palettes}
\keyword{datasets}
