% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_unhcr.R
\name{theme_unhcr}
\alias{theme_unhcr}
\title{UNHCR \link{ggplot2} theme}
\usage{
theme_unhcr(
  font_family = if (lato_installed()) "Lato" else "sans",
  font_size = 12,
  plot_title_size = rel(1.35),
  plot_title_margin = font_size,
  subtitle_size = font_size,
  subtitle_margin = font_size * 1.5,
  strip_text_size = rel(0.9),
  strip_text_face = "bold",
  strip_text_just = 0,
  caption_size = rel(0.7),
  caption_margin = font_size,
  axis_text = TRUE,
  axis_text_size = rel(0.9),
  axis_title = TRUE,
  axis_title_size = rel(0.9),
  axis = FALSE,
  axis_ticks = FALSE,
  grid = "XY",
  legend = TRUE,
  legend_text_size = rel(0.9),
  legend_title = FALSE,
  legend_title_size = rel(0.9),
  plot_margin = margin(font_size, font_size, font_size, font_size),
  plot_background = "#ffffff",
  void = FALSE
)
}
\arguments{
\item{font_family}{Base font family "Lato".
You need to have "Lato" font installed on your device in order to use it.}

\item{font_size}{Base font size in pt. Default to 12 pts.}

\item{plot_title_size}{Plot title font size. Default to \code{font_size} * 1.35.}

\item{plot_title_margin}{Plot title bottom margin. Default to \code{font_size}.}

\item{subtitle_size}{Plot subtitle font size. Default to \code{font_size}.}

\item{subtitle_margin}{Plot subtitle bottom margin. Default to \code{font_size} * 1.5.}

\item{strip_text_size}{Facet label font size. Default to \code{font_size} * 0.9.}

\item{strip_text_face}{Facet label font face. Default to "bold".}

\item{strip_text_just}{Facet label justification. Default to 0.}

\item{caption_size}{Caption font size. Default to \code{font_size} * 0.7.}

\item{caption_margin}{Caption top margin. Default to \code{font_size}.}

\item{axis_text}{Logical \code{TRUE}/\code{FALSE} or \code{xy}. Turn on and off axis label.
Use \code{x} or \code{y} to have only the correspondent active. Default to \code{TRUE}.}

\item{axis_text_size}{Axis label font size. Default to \code{font_size} * 0.9.}

\item{axis_title}{Logical \code{TRUE}/\code{FALSE} or \code{xy}. Turn on and off axis title.
Use \code{x} or \code{y} to have only the correspondent active. Default to \code{TRUE}.}

\item{axis_title_size}{Axis title font size. Default to \code{font_size} * 0.9.}

\item{axis}{Logical \code{TRUE}/\code{FALSE} or \code{xy}. Turn on and off axis.
Use \code{x} or \code{y} to have only the correspondent axis active. Don't forget to review
the \code{expand} argument of the \verb{scale_x_*}/\verb{scale_y_*} to avoid spacing between
the axis and the baseline of the plot. Default to \code{FALSE}.}

\item{axis_ticks}{Logical \code{TRUE}/\code{FALSE} or \code{xy}. Turn on and off axis ticks.
Use \code{x} or \code{y} to have only the correspondent axis ticks active. Default to \code{FALSE}.}

\item{grid}{Logical \code{TRUE}/\code{FALSE} or a combination of \code{X} or \code{x} and \code{Y} or y\verb{. Turn on and off panel grids. Use }X\code{or}Y\verb{for major grids, and}x\code{or}y\verb{for minor grid.  Default to}XY`.}

\item{legend}{Logical \code{TRUE}/\code{FALSE}. Turn on and off the legend.
Default to \code{TRUE}.}

\item{legend_text_size}{Legend key font size. Default to \code{font_size} * 0.9.}

\item{legend_title}{Logical \code{TRUE}/\code{FALSE}. Turn on and off the legend title.
Default to \code{FALSE}.}

\item{legend_title_size}{Legend title font size. Default to \code{font_size} * 0.9.}

\item{plot_margin}{Plot margin (specify with \code{ggplot2::margin()}).
Default to \code{ggplot2::margin(font_size, font_size, font_size, font_size)}.}

\item{plot_background}{Plot background.
Put "transparent" for no background color. Default to "white".}

\item{void}{Logical \code{TRUE}/\code{FALSE}. If \code{TRUE}, all grid lines, ticks
and axes are removed. Default to \code{FALSE}.}
}
\value{
A ggplot2 theme object, the theme style.
}
\description{
\code{theme_unhcr} provides a basic \bold{UNHCR} theme
to use in \bold{ggplot2} commands.
}
\examples{
\dontrun{

library(ggplot2)

data(mpg, package = "ggplot2")

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  theme_unhcr()
}

}
