% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_polychoricMatrix3.R
\name{umx_polychoric}
\alias{umx_polychoric}
\title{FIML-based polychoric, polyserial, and Pearson correlations}
\usage{
umx_polychoric(
  data,
  useDeviations = TRUE,
  tryHard = c("no", "yes", "ordinal", "search")
)
}
\arguments{
\item{data}{Dataframe}

\item{useDeviations}{Whether to code the mode using deviation thresholds (default = TRUE)}

\item{tryHard}{'no' uses normal mxRun (default), "yes" uses mxTryHard, and others used named versions: "mxTryHardOrdinal", "mxTryHardWideSearch"}
}
\value{
- list of output and diagnostics. matrix of correlations = $polychorics
}
\description{
Compute polychoric/polyserial/Pearson correlations with FIML in OpenMx
}
\examples{
tmp = mtcars
tmp$am = umxFactor(mtcars$am)
tmp$vs = umxFactor(mtcars$vs)
tmp = umx_scale(tmp)
x = umx_polychoric(tmp[, c("am", "vs")], tryHard = "yes")
x$polychorics
cor(mtcars[, c("am", "vs")])

}
\references{
- \url{https://doi.org/10.3389/fpsyg.2016.00528}
}
\seealso{
Other Data Functions: 
\code{\link{umxFactor}()},
\code{\link{umxHetCor}()},
\code{\link{umx_as_numeric}()},
\code{\link{umx_cont_2_quantiles}()},
\code{\link{umx_lower2full}()},
\code{\link{umx_make_MR_data}()},
\code{\link{umx_make_TwinData}()},
\code{\link{umx_make_fake_data}()},
\code{\link{umx_make_raw_from_cov}()},
\code{\link{umx_polypairwise}()},
\code{\link{umx_polytriowise}()},
\code{\link{umx_read_lower}()},
\code{\link{umx_rename}()},
\code{\link{umx_reorder}()},
\code{\link{umx_select_valid}()},
\code{\link{umx_stack}()},
\code{\link{umx}}
}
\concept{Data Functions}
