% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umxEval}
\alias{umxEval}
\title{umxEval}
\usage{
umxEval(expstring, model, compute = FALSE, show = FALSE)
}
\arguments{
\item{expstring}{an expression string, i.e, "a + b"}

\item{model}{an \code{\link{mxModel}} to evaluate in}

\item{compute}{Whether to compute the result or not (default = FALSE)}

\item{show}{Whether to show??? (default = FALSE)}
}
\value{
- an openmx algebra (formula)
}
\description{
Takes an expression as a string, and evaluates it as an expression in model, optionally computing the result.
# TODO umxEval Currently broken... delete submit as update to OpenMx?
}
\examples{
m1 = mxModel("fit",
	mxMatrix("Full", nrow = 1, ncol = 1, free = TRUE, values = 1, name = "a"), 
	mxMatrix("Full", nrow = 1, ncol = 1, free = TRUE, values = 2, name = "b"), 
	mxAlgebra(a \%*\% b, name = "ab"), 
	mxConstraint(ab == 35, name = "maxHours"), 
	mxFitFunctionAlgebra(algebra = "ab", numObs= NA, numStats = NA)
)
m1 = mxRun(m1)
mxEval(list(ab = ab), m1)
}
\references{
- \url{https://www.github.com/tbates/umx}
}
\seealso{
Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{tmx_is.identified}}, \code{\link{umxAPA}},
  \code{\link{umxFactorScores}},
  \code{\link{umxGetParameters}}, \code{\link{umxReduce}},
  \code{\link{umxSummary}}, \code{\link{umxWeightedAIC}},
  \code{\link{umx_APA_model_CI}},
  \code{\link{umx_APA_pval}}, \code{\link{umx_aggregate}},
  \code{\link{umx_names}}, \code{\link{umx_parameters}},
  \code{\link{umx_print}},
  \code{\link{umx_show_fit_or_comparison}},
  \code{\link{umx_show}}, \code{\link{umx_time}},
  \code{\link{umx}}
}
\concept{Reporting Functions}
