% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmu_make_top.R
\name{xmu_make_top}
\alias{xmu_make_top}
\title{Helper to make a basic top, MZ, and DZ model}
\usage{
xmu_make_top(mzData, dzData, selDVs, sep = NULL, nSib = 2,
  numObsMZ = NULL, numObsDZ = NULL, equateMeans = TRUE,
  threshType = c("deviationBased", "WLS"), weightVar = NULL,
  bVector = FALSE, verbose = FALSE)
}
\arguments{
\item{mzData}{Dataframe containing the MZ data}

\item{dzData}{Dataframe containing the DZ data}

\item{selDVs}{List of base (e.g. BMI) (i.e., NOT 'BMI_T1') variable names}

\item{sep}{Used to expand selDVs into selDVs, i.e., "_T" to expand BMI into BMI_T1 and BMI_T2}

\item{nSib}{Number of members per family (default = 2)}

\item{numObsMZ}{Number of MZ observations contributing (for summary data only)}

\item{numObsDZ}{Number of DZ observations contributing (for summary data only)}

\item{equateMeans}{Whether to equate T1 and T2 means (default = TRUE)}

\item{threshType}{what type of thresholds to implement if needed.}

\item{weightVar}{If provided, a vector objective will be used to weight the data. (default = NULL).}

\item{bVector}{Whether to compute row-wise likelihoods (defaults to FALSE).}

\item{verbose}{(default = FALSE)}
}
\value{
\itemize{
\item \code{\link{mxModel}}s for top, MZ and DZ.
}
}
\description{
xmu_make_top makes basic \code{top}, \code{MZ}, and \code{DZ} models. It handles the thresholds matrix if needed.

This function takes the mzData and dzData, a list of the selDVs to analyse, along with other relevant information such as whether the user wants to equateMeans, and what threshType to use (currently "deviationBased", but hopefully "WLS" and. It can also handle a weightVar.

\code{varStarts} is computed as \code{sqrt(variance)/3} of the DVs and \code{obsMeans} as the variable means.
For raw data, a check is made for ordered variables.

For Binary variables, means are fixed at 0 and total variance (A+C+E) is fixed at 1.

For ordinal variables, the first 2 thresholds are fixed.

For continuous variables, \code{top} just contains an \code{expMean} matrix.

\code{MZ} and \code{DZ} is the data, and an expectation of for \code{top.expCovMZ} and \code{top.expMean}, possibly referencing vector = bVector in the fit function.

For continuous variables, \code{top} just contains an \code{expMean} matrix.

For ordinal, \code{top} gains \code{top.threshMat} (from a call to \code{umxThresholdMatrix}). \code{MZ} and \code{DZ} are as with continuous, but adding thresholds.

For binary, \code{Vtot} (A+C+E) is set to 1.

For summary data, top is just  name, and MZ and DZ have cov data in them.

If a weightVar is detected, this column is added to  mzWeightMatrix/mzWeightMatrix

If \code{equateMeans} is \code{TRUE}, then the Twin-2 vars in the mean matrix are equated by label with Twin-1.

On the TODO-list is to have WLS as an option. Also censored data.
}
\examples{
# ==============
# = Continuous =
# ==============
library(umx)
data(twinData)
selDVs = c("wt", "ht")
mzData = twinData[twinData$zygosity \%in\%  "MZFF",] 
dzData = twinData[twinData$zygosity \%in\%  "DZFF",]
bits = xmu_make_top(mzData = mzData, dzData = dzData, selDVs= selDVs, sep="", nSib = 2)
names(bits) # "top" "MZ"  "DZ" 

# ============================================
# = Bivariate continuous and ordinal example =
# ============================================
data(twinData)
selDVs = c("wt", "obese")
# Cut BMI column to form ordinal obesity variables
ordDVs          = c("obese1", "obese2")
obesityLevels   = c('normal', 'overweight', 'obese')
cutPoints       = quantile(twinData[, "bmi1"], probs = c(.5, .2), na.rm = TRUE)
twinData$obese1 = cut(twinData$bmi1, breaks = c(-Inf, cutPoints, Inf), labels = obesityLevels) 
twinData$obese2 = cut(twinData$bmi2, breaks = c(-Inf, cutPoints, Inf), labels = obesityLevels) 
# Make the ordinal variables into mxFactors (ensure ordered is TRUE, and require levels)
twinData[, ordDVs] = umxFactor(twinData[, ordDVs])
mzData = twinData[twinData$zygosity \%in\%  "MZFF",] 
dzData = twinData[twinData$zygosity \%in\%  "DZFF",]
bits = xmu_make_top(mzData = mzData, dzData = dzData, selDVs= selDVs, sep="", nSib = 2)
names(bits) # "top" "MZ"  "DZ" 

# ==============
# = One binary =
# ==============
data(twinData)
cutPoints       = quantile(twinData[, "bmi1"], probs = .2, na.rm = TRUE)
obesityLevels   = c('normal', 'obese')
twinData$obese1 = cut(twinData$bmi1, breaks = c(-Inf, cutPoints, Inf), labels = obesityLevels) 
twinData$obese2 = cut(twinData$bmi2, breaks = c(-Inf, cutPoints, Inf), labels = obesityLevels) 
ordDVs = c("obese1", "obese2")
twinData[, ordDVs] = umxFactor(twinData[, ordDVs])
selDVs = c("wt", "obese")
mzData = twinData[twinData$zygosity \%in\% "MZFF",]
dzData = twinData[twinData$zygosity \%in\% "DZFF",]
bits = xmu_make_top(mzData = mzData, dzData = dzData, selDVs = selDVs, sep = "", nSib = 2)

# ============
# = Cov data =
# ============
data(twinData)
selDVs = c("wt")
mz = cov(twinData[twinData$zygosity \%in\%  "MZFF", tvars(selDVs, sep="")], use = "complete")
dz = cov(twinData[twinData$zygosity \%in\%  "DZFF", tvars(selDVs, sep="")], use = "complete")
bits = xmu_make_top(mzData = mzData, dzData = dzData, selDVs= selDVs, sep= "", nSib = 2)
# TODO Add selCovs??
}
\seealso{
Other xmu internal not for end user: \code{\link{umxModel}},
  \code{\link{umx}}, \code{\link{xmuHasSquareBrackets}},
  \code{\link{xmuLabel_MATRIX_Model}},
  \code{\link{xmuLabel_Matrix}},
  \code{\link{xmuLabel_RAM_Model}}, \code{\link{xmuMI}},
  \code{\link{xmuMakeDeviationThresholdsMatrices}},
  \code{\link{xmuMakeOneHeadedPathsFromPathList}},
  \code{\link{xmuMakeTwoHeadedPathsFromPathList}},
  \code{\link{xmuMaxLevels}}, \code{\link{xmuMinLevels}},
  \code{\link{xmuPropagateLabels}},
  \code{\link{xmu_check_levels_identical}},
  \code{\link{xmu_dot_make_paths}},
  \code{\link{xmu_dot_make_residuals}},
  \code{\link{xmu_simplex_corner}},
  \code{\link{xmu_start_value_list}}
}
