% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxExpMeans}
\alias{umxExpMeans}
\title{Extract the expected means matrix from an \code{\link{mxModel}}}
\usage{
umxExpMeans(model, manifests = TRUE, latents = NULL, digits = NULL)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to get the means from}

\item{manifests}{Whether to select the manifest variables (defaults to TRUE)}

\item{latents}{Whether to select the latent variables (defaults to TRUE)}

\item{digits}{precision of reporting. Default (NULL) will not round at all.}
}
\value{
- expected means
}
\description{
Extract the expected means matrix from an \code{\link{mxModel}}
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("g")
manifests = names(demoOneFactor)
m1 = umxRAM("One Factor", data = demoOneFactor,
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1.0)
)
umxExpMeans(m1)
umxExpMeans(m1, digits = 3)
}
\references{
- \url{https://openmx.ssri.psu.edu/thread/2598}
}
\seealso{
Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxConfint}},
  \code{\link{umxExpCov}}, \code{\link{umxFitIndices}},
  \code{\link{umxPlotACEv}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umxSummarySimplex}},
  \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}
\concept{Reporting functions}
