% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxCF_SexLim.R
\name{umxCF_SexLim}
\alias{umxCF_SexLim}
\title{umxCF_SexLim}
\usage{
umxCF_SexLim(name = "ACE_sexlim", selDVs, mzmData, dzmData, mzfData, dzfData,
  dzoData, C_or_A = "A", suffix = NA)
}
\arguments{
\item{name}{The name of the model (Default = "CF_sexlim")}

\item{selDVs}{BASE NAMES of the variables in the analysis. You MUST provide suffixes.}

\item{mzmData}{Dataframe containing the MZ male data}

\item{dzmData}{Dataframe containing the DZ male data}

\item{mzfData}{Dataframe containing the MZ female data}

\item{dzfData}{Dataframe containing the DZ female data}

\item{dzoData}{Dataframe containing the DZ opposite-sex data (be sure and get in right order)}

\item{C_or_A}{Whether to model sex-limitation on C or on A. (Defaults to "A")}

\item{suffix}{Suffix used for twin variable naming. Allows using just the base names in selVars}
}
\value{
- CF SexLim model
}
\description{
Build a multivariate twin analysis with sex limitation based on a correlated factors model.
This allows Quantitative & Qualitative Sex-Limitation. The correlation approach ensures that variable order
does NOT affect ability of model to account for DZOS data.
Restrictions: Assumes means and variances can be equated across birth order within zygosity groups
}
\examples{
\dontrun{
# Load Libraries
require(umx)
# Create Functions to Assign Labels
laLower <- function(la,nVar) {
	paste(la,rev(nVar+1-sequence(1:nVar)),rep(1:nVar,nVar:1),sep="_")
}
laSdiag <- function(la,nVar) {
	paste(la,rev(nVar+1-sequence(1:(nVar-1))),rep(1:(nVar-1),(nVar-1):1),sep="_") 
}
laFull  <- function(la,nVar) {
	paste(la,1:nVar,rep(1:nVar,each=nVar),sep="_") 
}
laDiag  <- function(la,nVar) {
	paste(la,1:nVar,1:nVar,sep="_") 
}
laSymm  <- function(la,nVar) {
	paste(la,rev(nVar+1-sequence(1:nVar)),rep(1:nVar,nVar:1),sep="_") 
}
# =========================
# = Load and Process Data =
# =========================
data("us_skinfold_data")
# rescale vars
us_skinfold_data[,c('bic_T1', 'bic_T2')] <- us_skinfold_data[,c('bic_T1', 'bic_T2')]/3.4
us_skinfold_data[,c('tri_T1', 'tri_T2')] <- us_skinfold_data[,c('tri_T1', 'tri_T2')]/3
us_skinfold_data[,c('caf_T1', 'caf_T2')] <- us_skinfold_data[,c('caf_T1', 'caf_T2')]/3
us_skinfold_data[,c('ssc_T1', 'ssc_T2')] <- us_skinfold_data[,c('ssc_T1', 'ssc_T2')]/5
us_skinfold_data[,c('sil_T1', 'sil_T2')] <- us_skinfold_data[,c('sil_T1', 'sil_T2')]/5
# describe(us_skinfold_data, skew = FALSE)

# Select Variables for Analysis
varList = c('ssc','sil','caf','tri','bic')
selVars = umx_paste_names(varList, "_T", 1:2)
nVar = length(selVars)

# Data objects for Multiple Groups
mzmData = subset(us_skinfold_data, zyg == 1, selVars)
dzmData = subset(us_skinfold_data, zyg == 3, selVars)
mzfData = subset(us_skinfold_data, zyg == 2, selVars)
dzfData = subset(us_skinfold_data, zyg == 4, selVars)
dzoData = subset(us_skinfold_data, zyg == 5, selVars)

m1 = umxACESexLim(selDVs = varList, suffix = "_T",
       mzmData = mzmData, dzmData = dzmData, 
       mzfData = mzfData, dzfData = dzfData, 
       dzoData = dzoData)
m1 = mxRun(m1)
summary(m1)

# ===============================
# = 1 Nonscalar Sex Limitation  =
# ===============================
# Quantitative Sex Differences & Qualitative Sex Differences for A
# Male and female paths, plus male and female Ra, Rc and Re between variables
# Male-Female correlations in DZO group between 
# A factors Rao FREE, Rc constrained across male/female and opp-sex
# ===================================================
# = Test switching specific a from Males to females =
# ===================================================

m2 = umxSetParameters(m1, labels = "asm_.*", free = FALSE, values = 0, regex = TRUE)
m2 = umxSetParameters(m1, labels = "asf_.*", free = TRUE , values = 0, regex = TRUE)
m2 = mxRun(m2)
summary(m2)
mxCompare(m2, m1)
# ===============================
# = 2 Nonscalar Sex Limitation  =
# ===============================
# Quantitative Sex Differences & Qualitative Sex Differences for C
# Male and female paths, plus male and female Ra, Rc and Re between variables
# Male-Female correlations in DZO group between C 
# factors Rco FREE, Ra constrained across male/female and oppsex

# -------|---------|---------|---------|---------|---------|---------|---------|---------|-----|
# 3 Scalar Sex Limitation 
# Quantitative Sex Differences but NO Qualitative Sex Differences
# Male and female paths, but one set of Ra, Rc and Re between variables (same for male & female)
# ---------------------------------------------------------------------------------------------|

# =================================
# =================================
frODiag   <- c(rep(c(FALSE,rep(TRUE,nVar)),nVar-1),FALSE)
svODiag   <- c(rep(c(1,rep(.4,nVar)),nVar-1),1)
m3 = umxSetParameters(m2, labels = "asm_.*", free = FALSE, values = 0, regex = TRUE)
pathRam = mxMatrix(name="Ram", "Stand", nrow= nVar, free = TRUE, values = .4, 
		label = laSdiag("ra", nVar), lbound = -1, ubound = 1)
pathRaf = mxMatrix(name = "Raf", "Stand", nrow = nVar, free = TRUE, values = .4, 
		label=laSdiag("ra", nVar), lbound = -1, ubound = 1)
pathRcm = mxMatrix(name="Rcm", "Stand", nrow = nVar, free = TRUE, values = .4, 
		label=laSdiag("rc", nVar), lbound = -1, ubound = 1)
pathRcf = mxMatrix(name="Rcf", "Stand", nrow = nVar, free = TRUE, values = .4, 
		label=laSdiag("rc", nVar), lbound = -1, ubound = 1)
pathRem = mxMatrix(name="Rem", "Stand", nrow= nVar, free=TRUE, values = .4, 
		label = laSdiag("re", nVar), lbound = -1, ubound = 1)
pathRef = mxMatrix(name="Ref", "Stand", nrow= nVar, free=TRUE, values = .4, 
		label = laSdiag("re", nVar), lbound = -1, ubound = 1)
corRao  = mxMatrix(name="Rao", "Symm" , nrow= nVar, free = frODiag, values = svODiag,
         label = laSymm("ra", nVar), lbound = -1, ubound = 1)
corRco  = mxMatrix(name="Rco", "Symm" , nrow= nVar, free = frODiag, values = svODiag, 
         label = laSymm("rc", nVar), lbound = -1, ubound = 1)

# m3 <- makeModel("HetCfAce")
# m3 <- mxRun(m3)
# summary(m3)
# round(m3$VarsZm$result,4); round(m3$CorsZm$result,4)
# round(m3$VarsZf$result,4); round(m3$CorsZf$result,4)
# mxCompare(HetCfAceRgFit, m3)

# ===================
# = 4 Homogeneity 
# = NO Quantitative Sex Differences AND NO Qualitative Sex Differences
# = Same paths for males and females
# ===================

# =====================================
# = Equate [ace]m and [ace]f matrices =
# =====================================

pathAm = mxMatrix(name="am", "Diag", nrow = nVar, free = TRUE, values = .5, 
label = laDiag("a", nVar))
pathCm = mxMatrix(name="cm", "Diag", nrow = nVar, free = TRUE, values = .5, 
label = laDiag("c", nVar))
pathEm = mxMatrix(name="em", "Diag", nrow = nVar, free = TRUE, values = .5, 
label = laDiag("e", nVar))
pathAf = mxMatrix(name="af", "Diag", nrow = nVar, free = TRUE, values = .5, 
label = laDiag("a", nVar))
pathCf = mxMatrix(name="cf", "Diag", nrow = nVar, free = TRUE, values = .5, 
label = laDiag("c", nVar))
pathEf = mxMatrix(name="ef", "Diag", nrow = nVar, free = TRUE, values = .5, 
label = laDiag("e", nVar))

# m4 <- makeModel("HomCfAce")
# m4 <- mxRun(m4)
# summary(m4)
# round(m4$VarsZm$result,4); round(m4$CorsZm$result,4)
# round(m4$VarsZf$result,4); round(m4$CorsZf$result,4)
# mxCompare(m3, m4)

# ==============================================
# = Generate Output Table of all Nested Models =
# ==============================================

# mxCompare(HetCfAceRgFit, c(HetCfAceRcFit, m3, m4))

# rbind(
# 		mxCompare(HetCfAceRgFit, HetCfAceRcFit),
#  	mxCompare(HetCfAceRcFit, m3)[2,],
#  	mxCompare(m3, m4)[2,]
# )
}
}
\references{
- Neale et al. (2006). 
Multivariate genetic analysis of sex-lim and GxE interaction.
\emph{Twin Research & Human Genetics}, \bold{9}, pp. 481--489.
}
\seealso{
Other Twin Modeling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxACESexLim}}, \code{\link{umxACEcov}},
  \code{\link{umxACE}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxE}},
  \code{\link{umxIP}}, \code{\link{umxPlotACEcov}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umx_make_TwinData}}, \code{\link{umx}}
}
