% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_apply}
\alias{umx_apply}
\title{umx_apply}
\usage{
umx_apply(FUN, of, by = "columns", ...)
}
\arguments{
\item{FUN}{The function to apply}

\item{of}{The dataframe to work with}

\item{by}{What to apply the function to: columns or rows (default = "columns")}

\item{...}{optional arguments to FUN, i.e., na.rm = T}
}
\value{
- \code{\link{mxModel}}
}
\description{
Tries to make apply more readable. Other functions to think of include
\code{\link{cumsum}}, \code{\link{rowSums}}, \code{\link{colMeans}}, etc.
}
\examples{
umx_apply(mean, mtcars, by = "columns")
umx_apply(mean, of = mtcars, by = "columns")
umx_apply(mean, by = "rows", of = mtcars[1:3,], na.rm = TRUE)
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}, \url{http://openmx.psyc.virginia.edu}
}
\seealso{
Other Misc: \code{\link{umxEval}},
  \code{\link{umx_APA_model_CI}},
  \code{\link{umx_add_variances}},
  \code{\link{umx_default_option}},
  \code{\link{umx_get_bracket_addresses}},
  \code{\link{umx_object_as_str}},
  \code{\link{umx_string_to_algebra}}, \code{\link{umx}}
}

