## ----setup, include = FALSE----------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----cim-heading, eval=TRUE, echo=FALSE----------------------------------

digits <- x$input$digits;

if (!exists('headingLevel') || !is.numeric(headingLevel) || (length(headingLevel) != 1)) {
	headingLevel <- 3;
}


## ----cim-abbreviationLegend, tab.cap="Scales, items, and abbreviations.", echo=echoPartial, results='asis'----
knitr::kable(x$intermediate$abbreviationLegend);

## ----519cf46978397a36a53cd9b26b1b2a71, fig.height=6, fig.width=10, fig.cap='Factor loadings for Agreeableness and Conscientiousness', echo=FALSE, cache=FALSE, message=FALSE, results='asis'----
  grid::grid.newpage();
  grid::grid.draw(tmpPlotStorage);

## ----cim-graphs, echo=echoPartial, results='asis', fig.width=16, fig.height=6----

for (rowVar in names(x$input$scales)) {
  rowIndex <- which(names(x$input$scales) == rowVar);

  for (colVar in names(x$input$scales)) {
    colIndex <- which(names(x$input$scales) == colVar);
    ### Only for one half; not for the diagonal itself and
    ### the other half, because we combine those two.

    if (colIndex > rowIndex) {
      ufs::cat0("\n\n",
                ufs::repStr("#", headingLevel + 1),
                " Conceptual (in)dependence of ",
                rowVar, " and ",
                colVar, "\n\n");
      ufs::knitFig(gridExtra::grid.arrange(grobs=list(x$intermediate$grobsList[[rowIndex]][[colIndex]],
                                                      x$intermediate$grobsList[[colIndex]][[rowIndex]]),
                                           ncol=2),
                   figWidth = 10,
                   figHeight = 6,
                   figCaption=paste0("Factor loadings for ", rowVar, " and ", colVar),
                   catPlot=TRUE);
      cat("\n\n");
      
      ###----------------------------------------------------------------------
      ### EFA error, warning, message printing
      ###----------------------------------------------------------------------
      
      allErrors_efa <- 
        c(x$intermediate$errorsList[[rowIndex]][[colIndex]]$efa, 
          x$intermediate$errorsList[[colIndex]][[rowIndex]]$efa);
      allWarnings_efa <- 
        c(x$intermediate$warningsList[[rowIndex]][[colIndex]]$efa, 
          x$intermediate$warningsList[[colIndex]][[rowIndex]]$efa);
      allMessages_efa <- 
        c(x$intermediate$messagesList[[rowIndex]][[colIndex]]$efa, 
          x$intermediate$messagesList[[colIndex]][[rowIndex]]$efa);
      
      if (length(allErrors_efa) > 0) {
        cat("\n\nEncountered the following errors during EFA:\n\n");
        cat(paste0(paste("-", allErrors_efa), collapse="\n\n"));
      } else {
        cat("\n\nNo errors encountered during EFA.\n\n");
      }

      if (length(allWarnings_efa) > 0) {
        cat("\n\nEncountered the following warnings during EFA:\n\n");
        cat(paste0(paste("-", allWarnings_efa), collapse="\n\n"));
      } else {
        cat("\n\nNo warnings encountered during EFA.\n\n");
      }

      if (length(allMessages_efa) > 0) {
        cat("\n\nEncountered the following messages during EFA:\n\n");
        cat(paste0(paste("-", allMessages_efa), collapse="\n\n"));
      } else {
        cat("\n\nNo messages encountered during EFA.\n\n");
      }

      cat("\n\n");
      
      ###----------------------------------------------------------------------
      ### CFA for one factor error, warning, message printing
      ###----------------------------------------------------------------------

      cat("\n\n");
      
      allErrors_cfa1 <- 
        c(x$intermediate$errorsList[[rowIndex]][[colIndex]]$cfa1, 
          x$intermediate$errorsList[[colIndex]][[rowIndex]]$cfa1);
      allWarnings_cfa1 <- 
        c(x$intermediate$warningsList[[rowIndex]][[colIndex]]$cfa1, 
          x$intermediate$warningsList[[colIndex]][[rowIndex]]$cfa1);
      allMessages_cfa1 <- 
        c(x$intermediate$messagesList[[rowIndex]][[colIndex]]$cfa1, 
          x$intermediate$messagesList[[colIndex]][[rowIndex]]$cfa1);
      
      if (length(allErrors_cfa1) > 0) {
        cat("\n\nEncountered the following errors during one-factor CFA:\n\n");
        cat(paste0(paste("-", allErrors_cfa1), collapse="\n\n"));
      } else {
        cat("\n\nNo errors encountered during one-factor CFA\n\n");
      }

      if (length(allWarnings_cfa1) > 0) {
        cat("\n\nEncountered the following warnings during one-factor CFA:\n\n");
        cat(paste0(paste("-", allWarnings_cfa1), collapse="\n\n"));
      } else {
        cat("\n\nNo warnings encountered during one-factor CFA\n\n");
      }

      if (length(allMessages_cfa1) > 0) {
        cat("\n\nEncountered the following messages during one-factor CFA:\n\n");
        cat(paste0(paste("-", allMessages_cfa1), collapse="\n\n"));
      } else {
        cat("\n\nNo messages encountered during one-factor CFA\n\n");
      }

      cat("\n\n");
      
      ###----------------------------------------------------------------------
      ### CFA for two factors error, warning, message printing
      ###----------------------------------------------------------------------

      cat("\n\n");
      
      allErrors_cfa2 <- 
        c(x$intermediate$errorsList[[rowIndex]][[colIndex]]$cfa2, 
          x$intermediate$errorsList[[colIndex]][[rowIndex]]$cfa2);
      allWarnings_cfa2 <- 
        c(x$intermediate$warningsList[[rowIndex]][[colIndex]]$cfa2, 
          x$intermediate$warningsList[[colIndex]][[rowIndex]]$cfa2);
      allMessages_cfa2 <- 
        c(x$intermediate$messagesList[[rowIndex]][[colIndex]]$cfa2, 
          x$intermediate$messagesList[[colIndex]][[rowIndex]]$cfa2);
      
      if (length(allErrors_cfa2) > 0) {
        cat("\n\nEncountered the following errors during two-factor CFA:\n\n");
        cat(paste0(paste("-", allErrors_cfa2), collapse="\n\n"));
      } else {
        cat("\n\nNo errors encountered during two-factor CFA\n\n");
      }

      if (length(allWarnings_cfa2) > 0) {
        cat("\n\nEncountered the following warnings during two-factor CFA:\n\n");
        cat(paste0(paste("-", allWarnings_cfa2), collapse="\n\n"));
      } else {
        cat("\n\nNo warnings encountered during two-factor CFA\n\n");
      }

      if (length(allMessages_cfa2) > 0) {
        cat("\n\nEncountered the following messages during two-factor CFA:\n\n");
        cat(paste0(paste("-", allMessages_cfa2), collapse="\n\n"));
      } else {
        cat("\n\nNo messages encountered during two-factor CFA\n\n");
      }
      
      cat("\n\n");
            
    }
  }
}


## ---- fig.width=12, fig.height=6-----------------------------------------

### Load data from psych package
data(bfi, package= 'psych');

### Specify scales
bfiScales <-
  list(Agreeableness     = paste0("Agreeableness_item_", 1:5),
       Conscientiousness = paste0("Conscientiousness_item_", 1:5),
       Extraversion      = paste0("Extraversion_item_", 1:5),
       Neuroticism       = paste0("Neuroticism_item_", 1:5),
       Openness          = paste0("Openness_item_", 1:5));

names(bfi) <- c(unlist(bfiScales),
                c('gender', 'education', 'age'));

### Only select first two and the first three items to
### keep it quick; just pass the full 'bfiScales'
### object to run for all five the full scales
ufs::CIM(bfi,
         scales=lapply(bfiScales, head, 3)[1:2],
         n.iter=10);


