% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/associationMatrix.R
\name{computeStatistic_t}
\alias{computeStatistic_t}
\alias{computeStatistic_r}
\alias{computeStatistic_f}
\alias{computeStatistic_chisq}
\alias{computeEffectSize_d}
\alias{computeEffectSize_r}
\alias{computeEffectSize_etasq}
\alias{computeEffectSize_v}
\alias{associationMatrixESDefaults}
\alias{associationMatrixStatDefaults}
\alias{computeEffectSize_omegasq}
\title{associationMatrix Helper Functions}
\usage{
computeStatistic_t(var1, var2, conf.level = 0.95, var.equal = "test",
  ...)

computeStatistic_r(var1, var2, conf.level = 0.95, ...)

computeStatistic_f(var1, var2, conf.level = 0.95, ...)

computeStatistic_chisq(var1, var2, conf.level = 0.95, ...)

computeEffectSize_d(var1, var2, conf.level = 0.95, var.equal = "test",
  ...)

computeEffectSize_r(var1, var2, conf.level = 0.95, ...)

computeEffectSize_etasq(var1, var2, conf.level = 0.95, ...)

computeEffectSize_omegasq(var1, var2, conf.level = 0.95, ...)

computeEffectSize_v(var1, var2, conf.level = 0.95, bootstrap = FALSE,
  samples = 5000, ...)
}
\arguments{
\item{var1}{One of the two variables for which to compute a statistic or
effect size}

\item{var2}{The other variable for which to compute the statistic or effect
size}

\item{conf.level}{The confidence for the confidence interval for the effect
size}

\item{var.equal}{Whether to test for equal variances ('test'), assume
equality ('yes'), or assume unequality ('no'). See [userfriendlyscience::meanDiff()]
for more information.}

\item{\dots}{Any additonal arguments are sometimes used to specify exactly
how statistics and effect sizes should be computed.}

\item{bootstrap}{Whether to bootstrap to estimate the confidence interval
for Cramer's V.  If FALSE, the Fisher's Z conversion is used.}

\item{samples}{If bootstrapping, the number of samples to generate (of
course, more samples means more accuracy and longer processing time).}
}
\value{
associationMatrixStatDefaults and associationMatrixESDefaults contain the
default functions from computeStatistic and computeEffectSize that are
called (see the help file for associationMatrix for more details).

The other functions return an object with the relevant statistic or effect
size, with a confidence interval for the effect size.

For computeStatistic, this object always contains: \item{statistic}{The
relevant statistic} \item{statistic.type}{The type of statistic}
\item{parameter}{The degrees of freedom for this statistic} \item{p.raw}{The
p-value of this statistic for NHST} And in addition, it often contains
(among other things, sometimes): \item{object}{The object from which the
statistics are extracted}

For computeEffectSize, this object always contains: \item{es}{The point
estimate for the effect size} \item{esc.type}{The type of effect size}
\item{ci}{The confidence interval for the effect size} And in addition, it
often contains (among other things, sometimes): \item{object}{The object
from which the effect size is extracted}
}
\description{
These objects contain a number of settings and functions for
associationMatrix.
}
\examples{


computeStatistic_f(Orange$Tree, Orange$circumference)
computeEffectSize_etasq(Orange$Tree, Orange$circumference)

}
\seealso{
[userfriendlyscience::meanDiff()], [associationMatrix()]
}
\author{
Gjalt-Jorn Peters

Maintainer: Gjalt-Jorn Peters <gjalt-jorn@userfriendlyscience.com>
}
\keyword{bivar}
\keyword{utilities}
