% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udpipe_train.R
\name{as_fasttext}
\alias{as_fasttext}
\title{Combine labels and text as used in fasttext}
\usage{
as_fasttext(x, y, label = "__label__")
}
\arguments{
\item{x}{a character vector}

\item{y}{a character vector of labels or a list of labels. \code{y} should be of the same length as \code{x}}

\item{label}{the string to use to prepend to the label. Defaults to __label__}
}
\value{
a character vector of text where \code{x} and \code{y} are combined
}
\description{
Fasttext prepends a label or different labels to text using a special string (__label__).
This function takes a character vector of text and prepends the labels alongside the special string.
}
\examples{
as_fasttext(x = c("just a bit of txt", "example2", "more txt please", "more"), 
            y = c("pos", "neg", "neg", NA))
as_fasttext(x = c("just a bit of txt", "example2", "more txt please", "more"), 
            y = list(c("ok", "pos"), c("neg", "topic2"), "", NA))
}
