% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_effects.R
\name{plot_effects,ubmsFit-method}
\alias{plot_effects,ubmsFit-method}
\alias{plot_effects}
\alias{plot_marginal}
\alias{plot_marginal,ubmsFit-method}
\title{Plot Marginal Effects of Covariates}
\usage{
\S4method{plot_effects}{ubmsFit}(
  object,
  submodel,
  covariate = NULL,
  level = 0.95,
  draws = 1000,
  smooth = NULL,
  ...
)

\S4method{plot_marginal}{ubmsFit}(
  object,
  submodel,
  covariate = NULL,
  level = 0.95,
  draws = 1000,
  smooth = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted model of class \code{ubmsFit}}

\item{submodel}{Submodel to get plots for, for example \code{"det"}}

\item{covariate}{Plot a specific covariate; provide the name as a string}

\item{level}{Probability mass to include in the uncertainty interval}

\item{draws}{Number of draws from the posterior to use when generating the
plots. If fewer than \code{draws} are available, they are all used}

\item{smooth}{Smoother span (f) value used for LOWESS smoothing of the
upper and lower credible interval bounds for a continuous covariate.
No smoothing is done if \code{NULL}. A reasonable value to try is 0.05.
The larger the value, the smoother the curve. As with all smoothing, use
with caution}

\item{...}{Currently ignored}
}
\value{
A \code{ggplot} if a single covariate is plotted, or an object
 of class \code{grob} if there are multiple covariates/panels
}
\description{
Generates marginal fixed effects plots of one or more covariates from a
\code{ubmsFit} submodel. For each plot, the focal covariate is allowed to
vary across its range (or possible discrete values, for a factor), while
the other covariates are held at their medians or reference levels.
Random effects are ignored.
}
