% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_treepos.R
\name{treepos_FT}
\alias{treepos_FT}
\title{'ForestTools' tree top detection}
\usage{
treepos_FT(chm = NULL, winFun = function(x) {     0.5 * ((x^2) * 0.009
  + 2.51) }, minTreeAlt = 2, maxCrownArea = maxCrownArea,
  verbose = TRUE)
}
\arguments{
\item{chm}{Canopy height model in \code{raster}, \code{lasmetrics}, \code{matrix} or  object of \code{class LAS}.
Should be the same that was used to create
the input for \code{treepos}.}

\item{winFun}{function. The function that determines the size of the window at any given
location on the canopy. It should take the value of a given CHM pixel as its only argument,
and return the desired radius of the circular search window when centered on that pixel.}

\item{minTreeAlt}{Height threshold (m) below a pixel cannot be a local maximum. Local maxima values are used to define tree tops.}

\item{maxCrownArea}{numeric. A single value of the maximum individual tree crown radius expected.}

\item{verbose}{quiet (1)
height of \code{treepos}.}
}
\description{
Implements the variable window filter algorithm (Popescu & Wynne, 2004)
for detecting treetops from a canopy height model. Andrew Plowright:
R package \href{https://CRAN.R-project.org/package=ForestTools}{ForestTools}\cr
}
\examples{
##- required packages
 require(uavRst)

 data(chm_seg)
 
##- call ForestTools treepos function
 tposFT <- treepos_FT(chm = chm_seg[[1]],
            minTreeAlt = 10,
            maxCrownArea = 150)
            
##- visualize it
# mapview::mapview(tposFT)
raster::plot(tposFT)
}
