% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSMARconstructor.R, R/misc3methods.R,
%   R/plotMethods.R, R/printMethods.R
\name{GSMAR}
\alias{GSMAR}
\alias{logLik.gsmar}
\alias{residuals.gsmar}
\alias{summary.gsmar}
\alias{plot.gsmar}
\alias{print.gsmar}
\title{Create object of class 'gsmar' defining a GMAR, StMAR, or G-StMAR model}
\usage{
GSMAR(
  data,
  p,
  M,
  params,
  model = c("GMAR", "StMAR", "G-StMAR"),
  restricted = FALSE,
  constraints = NULL,
  conditional = TRUE,
  parametrization = c("intercept", "mean"),
  calc_qresiduals,
  calc_cond_moments,
  calc_std_errors = FALSE,
  custom_h = NULL
)

\method{logLik}{gsmar}(object, ...)

\method{residuals}{gsmar}(object, ...)

\method{summary}{gsmar}(object, ..., digits = 2)

\method{plot}{gsmar}(x, ..., include_dens = TRUE)

\method{print}{gsmar}(x, ..., digits = 2, summary_print = FALSE)
}
\arguments{
\item{data}{a numeric vector or class \code{'ts'} object containing the data. \code{NA} values are not supported.}

\item{p}{a positive integer specifying the autoregressive order of the model.}

\item{M}{\describe{
  \item{For \strong{GMAR} and \strong{StMAR} models:}{a positive integer specifying the number of mixture components.}
  \item{For \strong{G-StMAR} models:}{a size (2x1) integer vector specifying the number of \emph{GMAR type} components \code{M1} in the
   first element and \emph{StMAR type} components \code{M2} in the second element. The total number of mixture components is \code{M=M1+M2}.}
}}

\item{params}{a real valued parameter vector specifying the model.
 \describe{
   \item{For \strong{non-restricted} models:}{
     Size \eqn{(M(p+3)+M-M1-1x1)} vector \strong{\eqn{\theta}}\eqn{=}(\strong{\eqn{\upsilon_{1}}}\eqn{,...,}\strong{\eqn{\upsilon_{M}}},
     \eqn{\alpha_{1},...,\alpha_{M-1},}\strong{\eqn{\nu}}) where
     \itemize{
       \item \strong{\eqn{\upsilon_{m}}}\eqn{=(\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,}\eqn{\sigma_{m}^2)}
       \item \strong{\eqn{\phi_{m}}}\eqn{=(\phi_{m,1},...,\phi_{m,p}), m=1,...,M}
       \item \strong{\eqn{\nu}}\eqn{=(\nu_{M1+1},...,\nu_{M})}
       \item \eqn{M1} is the number of GMAR type regimes.
     }
     In the \strong{GMAR} model, \eqn{M1=M} and the parameter \strong{\eqn{\nu}} dropped. In the \strong{StMAR} model, \eqn{M1=0}.

     If the model imposes \strong{linear constraints} on the autoregressive parameters:
     Replace the vectors \strong{\eqn{\phi_{m}}} with the vectors \strong{\eqn{\psi_{m}}} that satisfy
      \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{C_{m}\psi_{m}}} (see the argument \code{constraints}).
     }
   \item{For \strong{restricted} models:}{
     Size \eqn{(3M+M-M1+p-1x1)} vector \strong{\eqn{\theta}}\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,}
     \eqn{\sigma_{1}^2,...,\sigma_{M}^2,}\eqn{\alpha_{1},...,\alpha_{M-1},}\strong{\eqn{\nu}}), where \strong{\eqn{\phi}}=\eqn{(\phi_{1},...,\phi_{p})}
     contains the AR coefficients, which are common for all regimes.

     If the model imposes \strong{linear constraints} on the autoregressive parameters:
     Replace the vector \strong{\eqn{\phi}} with the vector \strong{\eqn{\psi}} that satisfies
      \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{C\psi}} (see the argument \code{constraints}).
   }
 }
 Symbol \eqn{\phi} denotes an AR coefficient, \eqn{\sigma^2} a variance, \eqn{\alpha} a mixing weight, and \eqn{\nu} a degrees of
 freedom parameter. If \code{parametrization=="mean"}, just replace each intercept term \eqn{\phi_{m,0}} with the regimewise mean
 \eqn{\mu_m = \phi_{m,0}/(1-\sum\phi_{i,m})}. In the \strong{G-StMAR} model, the first \code{M1} components are \emph{GMAR type}
 and the rest \code{M2} components are \emph{StMAR type}.
 Note that in the case \strong{M=1}, the mixing weight parameters \eqn{\alpha} are dropped, and in the case of \strong{StMAR} or \strong{G-StMAR} model,
 the degrees of freedom parameters \eqn{\nu} have to be larger than \eqn{2}.}

\item{model}{is "GMAR", "StMAR", or "G-StMAR" model considered? In the G-StMAR model, the first \code{M1} components
are \emph{GMAR type} and the rest \code{M2} components are \emph{StMAR type}.}

\item{restricted}{a logical argument stating whether the AR coefficients \eqn{\phi_{m,1},...,\phi_{m,p}} are restricted
to be the same for all regimes.}

\item{constraints}{specifies linear constraints imposed to each regime's autoregressive parameters separately.
\describe{
\item{For \strong{non-restricted} models:}{a list of size \eqn{(pxq_{m})} constraint matrices \strong{\eqn{C_{m}}} of full column rank
  satisfying \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{C_{m}\psi_{m}}} for all \eqn{m=1,...,M}, where
  \strong{\eqn{\phi_{m}}}\eqn{=(\phi_{m,1},...,\phi_{m,p})} and \strong{\eqn{\psi_{m}}}\eqn{=(\psi_{m,1},...,\psi_{m,q_{m}})}.}
\item{For \strong{restricted} models:}{a size \eqn{(pxq)} constraint matrix \strong{\eqn{C}} of full column rank satisfying
  \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{C\psi}}, where \strong{\eqn{\phi}}\eqn{=(\phi_{1},...,\phi_{p})} and
  \strong{\eqn{\psi}}\eqn{=\psi_{1},...,\psi_{q}}.}
}
The symbol \eqn{\phi} denotes an AR coefficient. Note that regardless of any constraints, the autoregressive order
is always \code{p} for all regimes.
Ignore or set to \code{NULL} if applying linear constraints is not desired.}

\item{conditional}{a logical argument specifying whether the conditional or exact log-likelihood function should be used.}

\item{parametrization}{is the model parametrized with the "intercepts" \eqn{\phi_{m,0}} or
"means" \eqn{\mu_{m} = \phi_{m,0}/(1-\sum\phi_{i,m})}?}

\item{calc_qresiduals}{should quantile residuals be calculated? Default is \code{TRUE} iff the model contains data.}

\item{calc_cond_moments}{should conditional means and variances be calculated? Default is \code{TRUE} iff the model contains data.}

\item{calc_std_errors}{should approximate standard errors be calculated?}

\item{custom_h}{A numeric vector with same the length as the parameter vector: i:th element of custom_h is the difference
used in central difference approximation for partial differentials of the log-likelihood function for the i:th parameter.
If \code{NULL} (default), then the difference used for differentiating overly large degrees of freedom parameters
is adjusted to avoid numerical problems, and the difference is \code{6e-6} for the other parameters.}

\item{object}{object of class \code{'gsmar'} created with \code{fitGSMAR} or \code{GSMAR}.}

\item{...}{in the plot method: arguments passed to the function \code{density} which
calculates the kernel density estimate of the data.}

\item{digits}{number of digits to be printed (max 20)}

\item{x}{object of class \code{'gsmar'} created with \code{fitGSMAR} or \code{GSMAR}.}

\item{include_dens}{Plot also kernel density estimate of the data and model implied stationary
density with regimewise densities? See the details.}

\item{summary_print}{if set to \code{TRUE} then the print will include approximate
standard errors for the estimates, log-likelihood, information criteria values,
modulus of the roots of the characteristic AR polynomials for each regime, and
several unconditional moments.}
}
\value{
Returns an object of class \code{'gsmar'} defining the specified GMAR, StMAR, or G-StMAR model. If data is supplied,
 the returned object contains (by default) empirical mixing weights, some conditional and unconditional moments, and quantile
 residuals. Note that the first p observations are taken as the initial values so the mixing weights, conditional moments, and
 quantile residuals start from the p+1:th observation (interpreted as t=1).
}
\description{
\code{GSMAR} creates an S3 object of class \code{'gsmar'} that defines a GMAR, StMAR, or G-StMAR model.
}
\details{
Models can be built without data, e.q., in order to simulate from the process, but some things such as quantile
 residuals and conditional moments can't be calculated without data.

If \code{include_dens == TRUE}, the kernel density estimate of the data is calculated
  with the function \code{density} from the package \code{stats}. By default, the default
  settings of that function are used, including the usage of Gaussian kernel. Use the dot
  parameters to adjust the settings if desired.

  By the model implied stationary density we mean the stationary one-dimensional mixture
  density of M regimes (see KMS 2015, Theorem 1 and the discussion following it for the Gaussian
  case and Theorem 2 in PMS 2018 for the Student's t case). The regimewise densities (i.e. each
  density 1,...,M in the stationary mixture density) are multiplied with the mixing weight
  parameters accordingly.

  In the density plot black represents the kernel density estimate of the data, grey dashed line the
  model implied density, and the colored dotted lines the regime wise densities.
}
\section{Methods (by generic)}{
\itemize{
\item \code{logLik}: Log-likelihood method

\item \code{residuals}: residuals method to extract quantile residuals

\item \code{summary}: summary method, standard errors in brackets

\item \code{plot}: Plot method for class 'gsmar'

\item \code{print}: print method
}}

\examples{
# GMAR model without data
params22 <- c(0.9, 0.4, 0.2, 0.5, 0.7, 0.5, -0.2, 0.7, 0.7)
gmar22 <- GSMAR(p=2, M=2, params=params22, model="GMAR")
gmar22

# StMAR model, without data
params12t <- c(1.38, 0.88, 0.27, 3.8, 0.74, 3.15, 0.8, 300, 3.6)
stmar12t <- GSMAR(p=1, M=2, params=params12t, model="StMAR")
stmar12t

# G-StMAR model with data
params42gs <- c(0.04, 1.34, -0.59, 0.54, -0.36, 0.01, 0.06, 1.28, -0.36,
                0.2, -0.15, 0.04, 0.19, 9.75)
gstmar42 <- GSMAR(data=M10Y1Y, p=4, M=c(1, 1), params=params42gs,
                  model="G-StMAR")
gstmar42

# Restricted G-StMAR model with data
params42gsr <- c(0.13, 0.03, 1.29, -0.4, 0.25, -0.2, 0.03, 0.05, 0.51, 2.76)
gstmar42r <- GSMAR(data=M10Y1Y, p=4, M=c(1, 1), params=params42gsr,
                   model="G-StMAR", restricted=TRUE)
gstmar42r
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. forthcoming. A mixture autoregressive model based on Student's t-distribution.
           \emph{Communications in Statistics - Theory and Methods}, doi: 10.1080/03610926.2021.1916531
   \item Virolainen S. 2020. A mixture autoregressive model based on Gaussian and Student's t-distributions. arXiv:2003.05221 [econ.EM].
 }
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{iterate_more}}, \code{\link{add_data}}, \code{\link{stmar_to_gstmar}},
 \code{\link{swap_parametrization}}, \code{\link{get_gradient}}, \code{\link{simulateGSMAR}},
 \code{\link{predict.gsmar}}, \code{\link{cond_moments}}, \code{\link{uncond_moments}}, \code{\link{LR_test}}, \code{\link{Wald_test}}
}
