% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneticAlgorithm.R
\name{random_ind}
\alias{random_ind}
\alias{smart_ind}
\title{Create random GMAR, StMAR, or G-StMAR model compatible parameter vector}
\usage{
random_ind(
  p,
  M,
  model = c("GMAR", "StMAR", "G-StMAR"),
  restricted = FALSE,
  constraints = NULL,
  mu_scale,
  sigma_scale,
  forcestat = FALSE
)

smart_ind(
  p,
  M,
  params,
  model = c("GMAR", "StMAR", "G-StMAR"),
  restricted = FALSE,
  constraints = NULL,
  mu_scale,
  sigma_scale,
  accuracy,
  which_random = numeric(0),
  forcestat = FALSE
)
}
\arguments{
\item{p}{a positive integer specifying the autoregressive order of the model.}

\item{M}{\describe{
  \item{For \strong{GMAR} and \strong{StMAR} models:}{a positive integer specifying the number of mixture components.}
  \item{For \strong{G-StMAR} models:}{a size (2x1) integer vector specifying the number of \emph{GMAR type} components \code{M1} in the
   first element and \emph{StMAR type} components \code{M2} in the second element. The total number of mixture components is \code{M=M1+M2}.}
}}

\item{model}{is "GMAR", "StMAR", or "G-StMAR" model considered? In the G-StMAR model, the first \code{M1} components
are \emph{GMAR type} and the rest \code{M2} components are \emph{StMAR type}.}

\item{restricted}{a logical argument stating whether the AR coefficients \eqn{\phi_{m,1},...,\phi_{m,p}} are restricted
to be the same for all regimes.}

\item{constraints}{specifies linear constraints applied to the autoregressive parameters.
\describe{
\item{For \strong{non-restricted} models:}{a list of size \eqn{(pxq_{m})} constraint matrices \strong{\eqn{C_{m}}} of full column rank
  satisfying \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{C_{m}\psi_{m}}} for all \eqn{m=1,...,M}, where
  \strong{\eqn{\phi_{m}}}\eqn{=(\phi_{m,1},...,\phi_{m,p})} and \strong{\eqn{\psi_{m}}}\eqn{=(\psi_{m,1},...,\psi_{m,q_{m}})}.}
\item{For \strong{restricted} models:}{a size \eqn{(pxq)} constraint matrix \strong{\eqn{C}} of full column rank satisfying
  \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{C\psi}}, where \strong{\eqn{\phi}}\eqn{=(\phi_{1},...,\phi_{p})} and
  \strong{\eqn{\psi}}\eqn{=\psi_{1},...,\psi_{q}}.}
}
Symbol \eqn{\phi} denotes an AR coefficient. Note that regardless of any constraints, the nominal autoregressive order
is always \code{p} for all regimes.
Ignore or set to \code{NULL} if applying linear constraints is \strong{not} desired.}

\item{mu_scale}{a real valued vector of length two specifying the mean (the first element) and standard deviation (the second element)
of the normal distribution from which the \eqn{\phi_{m,0}} \strong{or} \eqn{\mu_{m}} (depending on the desired parametrization)
parameters (for random regimes) should be generated.}

\item{sigma_scale}{a positive real number specifying the standard deviation of the (zero mean, positive only by taking absolute value)
normal distribution from which the component variance parameters (for random regimes) should be generated.}

\item{forcestat}{use the algorithm by Monahan (1984) to force stationarity on the AR parameters (slower) for random regimes?
Not supported for constrained models.}

\item{params}{a real valued parameter vector specifying the model.
\describe{
  \item{For \strong{non-restricted} models:}{
    \describe{
      \item{For \strong{GMAR} model:}{Size \eqn{(M(p+3)-1x1)} vector \strong{\eqn{\theta}}\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
        \eqn{\alpha_{1},...,\alpha_{M-1}}), where \strong{\eqn{\upsilon_{m}}}\eqn{=(\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,
        \sigma_{m}^2)} and \strong{\eqn{\phi_{m}}}=\eqn{(\phi_{m,1},...,\phi_{m,p}), m=1,...,M}.}
      \item{For \strong{StMAR} model:}{Size \eqn{(M(p+4)-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
        \eqn{\alpha_{1},...,\alpha_{M-1}, \nu_{1},...,\nu_{M}}).}
      \item{For \strong{G-StMAR} model:}{Size \eqn{(M(p+3)+M2-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
        \eqn{\alpha_{1},...,\alpha_{M-1}, \nu_{M1+1},...,\nu_{M}}).}
      \item{With \strong{linear constraints}:}{Replace the vectors \strong{\eqn{\phi_{m}}} with vectors \strong{\eqn{\psi_{m}}} and provide a  list of constraint
        matrices \strong{C} that satisfy \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{R_{m}\psi_{m}}} for all \eqn{m=1,...,M}, where
        \strong{\eqn{\psi_{m}}}\eqn{=(\psi_{m,1},...,\psi_{m,q_{m}})}.}
    }
  }
  \item{For \strong{restricted} models:}{
    \describe{
      \item{For \strong{GMAR} model:}{Size \eqn{(3M+p-1x1)} vector \strong{\eqn{\theta}}\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
        \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1})}, where \strong{\eqn{\phi}}=\eqn{(\phi_{1},...,\phi_{p})}.}
      \item{For \strong{StMAR} model:}{Size \eqn{(4M+p-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
        \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1}, \nu_{1},...,\nu_{M})}.}
      \item{For \strong{G-StMAR} model:}{Size \eqn{(3M+M2+p-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
        \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1}, \nu_{M1+1},...,\nu_{M})}.}
      \item{With \strong{linear constraints}:}{Replace the vector \strong{\eqn{\phi}} with vector \strong{\eqn{\psi}} and provide a constraint matrix
        \strong{\eqn{C}} that satisfies \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{R\psi}}, where
        \strong{\eqn{\psi}}\eqn{=(\psi_{1},...,\psi_{q})}.}
    }
  }
}
Symbol \eqn{\phi} denotes an AR coefficient, \eqn{\sigma^2} a variance, \eqn{\alpha} a mixing weight, and \eqn{\nu} a degrees of
freedom parameter. If \code{parametrization=="mean"}, just replace each intercept term \eqn{\phi_{m,0}} with regimewise mean
\eqn{\mu_m = \phi_{m,0}/(1-\sum\phi_{i,m})}. In the \strong{G-StMAR} model, the first \code{M1} components are \emph{GMAR type}
and the rest \code{M2} components are \emph{StMAR type}.
Note that in the case \strong{M=1}, the parameter \eqn{\alpha} is dropped, and in the case of \strong{StMAR} or \strong{G-StMAR} model,
the degrees of freedom parameters \eqn{\nu_{m}} have to be larger than \eqn{2}.}

\item{accuracy}{a real number larger than zero specifying how close to \code{params} the generated parameter vector should be.
Standard deviation of the normal distribution from which new parameter values are drawn from will be corresponding parameter
value divided by \code{accuracy}.}

\item{which_random}{a numeric vector of maximum length \code{M} specifying which regimes should be random instead of "smart" when
using \code{smart_ind}. Does not affect mixing weight parameters. Default in none.}
}
\value{
Returns estimated parameter vector with the form described in \code{initpop}.
}
\description{
\code{random_ind} creates a random GMAR, StMAR, or G-StMAR model compatible mean-parametrized parameter vector.

\code{smart_ind} creates a random GMAR, StMAR, or G-StMAR model compatible parameter vector close to argument \code{params}.
  Sometimes returns exactly the given parameter vector.
}
\details{
These functions can be used, for example, to create initial populations for the genetic algorithm. Mean-parametrization
  (instead of intercept terms \eqn{\phi_{m,0}}) is assumed.
}
\examples{
set.seed(1)

# GMAR model parameter vector
params22 <- random_ind(p=2, M=2, mu_scale=c(0, 1), sigma_scale=1)
smart22 <- smart_ind(p=2, M=2, params22, accuracy=10)
cbind(params22, smart22)

# Restricted GMAR parameter vector
params12r <- random_ind(p=1, M=2, restricted=TRUE, mu_scale=c(-2, 2), sigma_scale=2)
smart12r <- smart_ind(p=1, M=2, params12r, restricted=TRUE, accuracy=20)
cbind(params12r, smart12r)

# StMAR parameter vector: first regime is random in the "smart individual"
params13t <- random_ind(p=1, M=3, model="StMAR", mu_scale=c(3, 1), sigma_scale=3)
smart13t <- smart_ind(p=1, M=3, params13t, model="StMAR", accuracy=15,
                      mu_scale=c(3, 3), sigma_scale=3, which_random=1)
cbind(params13t, smart13t)

# Restricted StMAR parameter vector
params22tr <- random_ind(p=2, M=2, model="StMAR", restricted=TRUE,
                         mu_scale=c(3, 2), sigma_scale=0.5)
smart22tr <- smart_ind(p=2, M=2, params22tr, model="StMAR", restricted=TRUE,
                       accuracy=30)
cbind(params22tr, smart22tr)

# G-StMAR parameter vector
params12gs <- random_ind(p=1, M=c(1, 1), model="G-StMAR", mu_scale=c(0, 1),
                         sigma_scale=1)
smart12gs <- smart_ind(p=1, M=c(1, 1), params12gs, model="G-StMAR",
                       accuracy=20)
cbind(params12gs, smart12gs)

# Such StMAR(3,2) that the AR coefficients are restricted to be
# the same for both regimes and that the second AR coefficients are
# constrained to zero. Second regime is random in the "smart individual".
params32trc <- random_ind(p=3, M=2, model="StMAR", restricted=TRUE,
                          constraints=matrix(c(1, 0, 0, 0, 0, 1), ncol=2),
                          mu_scale=c(-2, 0.5), sigma_scale=4)
smart32trc <- smart_ind(p=3, M=2, params32trc, model="StMAR", restricted=TRUE,
                        constraints=matrix(c(1, 0, 0, 0, 0, 1), ncol=2),
                        mu_scale=c(0, 0.1), sigma_scale=0.1, which_random=2,
                        accuracy=20)
cbind(params32trc, smart32trc)
}
\references{
\itemize{
   \item Monahan J.F. 1984. A Note on Enforcing Stationarity in Autoregressive-Moving Average Models.
         \emph{Biometrica} \strong{71}, 403-404.
 }
}
