% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numericalDifferentiation.R
\name{calc_gradient}
\alias{calc_gradient}
\alias{calc_hessian}
\alias{get_gradient}
\alias{get_hessian}
\title{Calculate gradient or Hessian matrix}
\usage{
calc_gradient(x, fn, h = 6e-06, ...)

calc_hessian(x, fn, h = 6e-06, ...)

get_gradient(gsmar, h = 6e-06)

get_hessian(gsmar, h = 6e-06)
}
\arguments{
\item{x}{a numeric vector specifying the point where the gradient or Hessian should be calculated.}

\item{fn}{a function that takes in argument \code{x} as the \strong{first} argument.}

\item{h}{difference used to approximate the derivates.}

\item{...}{other arguments passed to \code{fn}}

\item{gsmar}{object of class \code{'gsmar'}, generated by function \code{fitGSMAR()} or \code{GSMAR()}.}
}
\value{
Gradient functions return numerical approximation of the gradient, and Hessian functions return
 numerical approximation of the Hessian.
}
\description{
\code{calc_gradient} or \code{calc_hessian} calculates the gradient or Hessian matrix
 of the given function at the given point using central difference numerical approximation.
 \code{get_gradient} or \code{get_hessian} calculates the gradient or Hessian matrix of the
 log-likelihood function at the parameter estimates of class \code{'gsmar'} object.
}
\details{
Especially the functions \code{get_gradient()} or \code{get_hessian()} can be used to check whether
 the found estimates denote a (local) maximum point, a saddle point or something else.
}
\section{Warning}{

 No argument checks!
}

\examples{
 # Simple function
 foo <- function(x) x^2 + x
 calc_gradient(x=1, fn=foo)
 calc_gradient(x=-0.5, fn=foo)

 # More complicated function
 foo <- function(x, a, b) a*x[1]^2 - b*x[2]^2
 calc_gradient(x=c(1, 2), fn=foo, a=0.3, b=0.1)

 # GMAR model:
 params12 <- c(1.12321, 0.90557, 0.29288,
  4.53131, 0.70309, 3.21154, 0.83888)
 gmar12 <- GSMAR(VIX, 1, 2, params12)
 get_gradient(gmar12)
 get_hessian(gmar12)
}
