% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{SpectralInfo-class}
\alias{SpectralInfo-class}
\title{Spectral info}
\value{
An S4 object of class "Spectral_info"
}
\description{
General class that holds basic information about an image. Usually used when working with mosaics, as in this case the image is not read/loaded to R until is processed (e.g. by running a mosaic_sam process). Currently, the only function that returns an object of this class is he \code{\link{mosaic_info}} function. The object can by used later to read/load to R a single mosaic chuck using the \code{\link{mosaic_chunk}} function, or to process the whole mosaic image by calling the \code{\link{mosaic_sam}} function.

The class \code{\link[=Tile-class]{Tile}} contains the "Spectral_info" class. By this means, an object of class \code{\link[=Tile-class]{Tile}} holds the same information about the reading, and an extra slot called "Spectra" that holds the actual readings.
}
\section{Slots}{

\describe{
\item{\code{file}}{character.  The full path to the .dmt or .bsp file.}

\item{\code{date}}{POSIXct.  The date in which the image (mosaic or tile) was taken.}

\item{\code{fpasize}}{numeric. The size of the focal plane array used when measuring.}

\item{\code{wavenumbers}}{numeric. The wavenumbers at which the tarject image (mosaic or tile) was taken.}

\item{\code{path}}{character.  The path to the folder that holds all the uFTIR Microscope output files.}
}}

\examples{
NULL
}
\seealso{
\code{\link[=Tile-class]{Tile}}
}
