% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yt_oauth.R
\name{yt_oauth}
\alias{yt_oauth}
\title{Set up Authorization}
\usage{
yt_oauth(app_id = NULL, app_secret = NULL, scope = "ssl",
  remove_old_oauth = FALSE)
}
\arguments{
\item{app_id}{client id; required; no default}

\item{app_secret}{client secret; required; no default}

\item{scope}{"ssl" or "basic"; required; default is ssl. The scopes are largely exchangeable but ssl yields extra authorizations that come in handy.}

\item{remove_old_oauth}{required; default is FALSE. It will remove .httr-oauth if such a file exists in the working directory}
}
\value{
sets the google_token option and also saves .httr_auth in the working directory (find out the working directory via getwd())
}
\description{
The function looks for .httr-oauth in the working directory. If it doesn't find it, it expects an application ID and a secret.
If you want to remove the existing .httr-oauth, set remove_old_oauth to TRUE. By default, it is set to FALSE.
The function launches a browser to allow you to authorize the application
}
\examples{
 \dontrun{
  yt_oauth("998136489867-5t3tq1g7hbovoj46dreqd6k5kd35ctjn.apps.googleusercontent.com", 
           "MbOSt6cQhhFkwETXKur-L9rN")
}
}
\references{
\url{https://console.developers.google.com/project}

\url{https://developers.google.com/youtube/v3/guides/auth/client-side-web-apps} for different scopes
}

