% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluss.R
\name{fluss_score}
\alias{fluss_score}
\title{FLUSS - Prediction score calculation}
\usage{
fluss_score(gtruth, extracted, data_size)
}
\arguments{
\item{gtruth}{an \code{int} or \code{vector} of \code{int} with the ground truth index of segments.}

\item{extracted}{an \code{int} or \code{vector} of \code{int} with the extracted indexes from \code{\link[=fluss_extract]{fluss_extract()}}.}

\item{data_size}{an \code{int}. Size of original input data.}
}
\value{
Returns the score of predicted semantic transitions compared with the ground truth.
Zero is the best, One is the worst.
}
\description{
FLUSS - Prediction score calculation
}
\examples{
data <- mp_fluss_data$tilt_abp$data[1:1000]
w <- 10
truth <- c(945, 875)
mp <- tsmp(data, window_size = w, verbose = 0)
mp <- fluss_cac(mp)
mp <- fluss_extract(mp, 2)
score <- fluss_score(truth, mp$fluss, length(data))
}
\references{
\itemize{
\item Gharghabi S, Ding Y, Yeh C-CM, Kamgar K, Ulanova L, Keogh E. Matrix Profile VIII: Domain Agnostic Online Semantic Segmentation at Superhuman Performance Levels. In: 2017 IEEE International Conference on Data Mining (ICDM). IEEE; 2017. p. 117–26.
}

Website: \url{https://sites.google.com/site/onlinesemanticsegmentation/}

Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
\seealso{
Other Semantic Segmentations: \code{\link{fluss_cac}},
  \code{\link{fluss_extract}}, \code{\link{fluss}}
}
\concept{Semantic Segmentations}
