% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/period.R
\name{yearmonth}
\alias{yearmonth}
\alias{yearquarter}
\title{Represent year-month or year-quarter objects}
\usage{
yearmonth(x)

yearquarter(x)
}
\arguments{
\item{x}{Other object.}
}
\value{
Year-month (\code{yearmonth}) or year-quarter (\code{yearquarter})
objects.
}
\description{
Create or coerce using \code{yearmonth()}, or \code{yearquarter()}
}
\details{
It's a known issue that these attributes will be dropped when using
\link{group_by} and \link{mutate} together. It is recommended to \link{ungroup} first, and
then use \link{mutate}.
}
\section{Index functions}{

The tsibble \code{yearmonth()} and \code{yearquarter()} function preserve the time zone of
the input \code{x}, contrasting to their zoo counterparts.
}

\examples{
# coerce dates to yearmonth, yearquarter ----
x <- seq(as.Date("2016-01-01"), as.Date("2016-12-31"), by = "1 month")
yearmonth(x)
yearquarter(x)

# coerce numerics to yearmonth, yearquarter ----
yearmonth(seq(2010, 2017, by = 1 / 12))
yearquarter(seq(2010, 2017, by = 1 / 4))

# coerce yearmonths to yearquarter ----
y <- yearmonth(x)
yearquarter(y)
}
\seealso{
\link{pull_interval}
}
