% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.nlar}
\alias{predict}
\alias{predict.nlar}
\title{Predict method for objects of class \sQuote{\code{nlar}}.}
\usage{
\method{predict}{nlar}(object, newdata, n.ahead = 1, type = c("naive", "MC",
  "bootstrap", "block-bootstrap"), nboot = 100, ci = 0.95, block.size = 3,
  boot1Zero = TRUE, ...)
}
\arguments{
\item{object}{An object of class \sQuote{\code{nlar}}; generated by
\command{setar()} or \command{lstar()}.}

\item{newdata}{Optional. A new data frame to predict from.}

\item{n.ahead}{An integer specifying the number of forecast steps.}

\item{type}{Type of forecasting method used. See details.}

\item{nboot}{The number of replications for type MC or bootstrap.}

\item{ci}{The forecast confidence interval (available only with types MC and
bootstrap).}

\item{block.size}{The block size when the block-bootstrap is used.}

\item{boot1Zero}{Whether the first innovation for MC/bootstrap should be set
to zero.}

\item{\dots}{Currently not used.}
}
\value{
A \sQuote{\code{ts}} object, or, in the case of MC/bootstrap, a list
containing the prediction (pred) and the forecast standard errors
(\code{se}).
}
\description{
Forecating a non-linear model object of general class \sQuote{\code{nlar}},
including \sQuote{\code{setar}} and \sQuote{\code{star}}.
}
\details{
The forecasts are obtained recursively from the estimated model.  Given that
the models are non-linear, ignoring the residuals in the 2- and more steps
ahead forecasts leads to biased forecasts (so-called naive).  Different
resampling methods, averaging \code{n.boot} times over future residuals, are
available:

\describe{ \item{naive}{No residuals} \item{MC}{Monte-Carlo method, where
residuals are taken from a normal distribution, with sd. equal to the
residuals sd. } \item{bootstrap}{Residuals are resampled from the empirical
residuals from the model.} \item{block-bootstrap}{Same as bootstrap, but
residuals are resampled in block, with size \code{block.size}} }

The \code{MC} and \code{bootstrap} methods correspond to equations 3.90 and
3.91 of Franses and van Dijk (2000, p. 121).  The bootstrap/MC is initiated
either from the first forecast, \code{n.ahead}=1 (set with \code{boot1zero}
to TRUE), or from the second only.

When the forecast method is based on resampling, forecast intervals are
available. These are obtained simply as empirical \code{ci} quantiles of the
resampled forecasts (cf Method 2 in Franses and van Dijk, 2000, p. 122).
}
\examples{
x.train <- window(log10(lynx), end = 1924)
x.test <- window(log10(lynx), start = 1925)


### Use different forecasting methods:
mod.set <- setar(x.train, m=2, thDelay=0)
pred_setar_naive <- predict(mod.set, n.ahead=10)
pred_setar_boot <- predict(mod.set, n.ahead=10, type="bootstrap", n.boot=200)
pred_setar_Bboot <- predict(mod.set, n.ahead=10, type="block-bootstrap", n.boot=200)
pred_setar_MC <- predict(mod.set, n.ahead=10, type="bootstrap", n.boot=200)

## Plot to compare results:
pred_range <- range(pred_setar_naive, pred_setar_boot$pred, pred_setar_MC$pred, na.rm=TRUE)
plot(x.test, ylim=pred_range, main="Comparison of forecasts methods from same SETAR")
lines(pred_setar_naive, lty=2, col=2)
lines(pred_setar_boot$pred, lty=3, col=3)
lines(pred_setar_Bboot$pred, lty=4, col=4)
lines(pred_setar_MC$pred, lty=5, col=5)

legLabels <- c("Observed", "Naive F", "Bootstrap F","Block-Bootstrap F", "MC F")
legend("bottomleft", leg=legLabels, lty=1:5, col=1:5)
}
\author{
Matthieu Stigler
}
\references{
Non-linear time series models in empirical finance, Philip Hans
Franses and Dick van Dijk, Cambridge: Cambridge University Press (2000).
}
\seealso{
The model fitting functions \code{\link{setar}},
\code{\link{lstar}}.

A more sophisticated predict function, allowing to do sub-sample rolling
predictions: \code{\link{predict_rolling}}.
}
\keyword{regression}

