% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tryLog.R
\name{tryLog}
\alias{tryLog}
\title{Try an expression with condition logging and error recovery}
\usage{
tryLog(expr,
  write.error.dump.file = getOption("tryCatchLog.write.error.dump.file",
  FALSE), silent.warnings = getOption("tryCatchLog.silent.warnings", FALSE),
  silent.messages = getOption("tryCatchLog.silent.messages", FALSE))
}
\arguments{
\item{expr}{expression to be evaluated}

\item{write.error.dump.file}{\code{TRUE}: Saves a dump of the workspace and the call stack named \code{dump_<YYYYMMDD_HHMMSS>.rda}}

\item{silent.warnings}{\code{TRUE}: Warnings are logged, but not propagated to the caller.\cr
\code{FALSE}: Warnings are logged and treated according to the global
setting in \code{\link{getOption}("warn")}. See also \code{\link{warning}}.}

\item{silent.messages}{\code{TRUE}: Messages are logged, but not propagated to the caller.\cr
\code{FALSE}: Messages are logged and propagated to the caller.}
}
\value{
The value of the expression (if \code{expr} is evaluated without an error.\cr
        In case of an error: An invisible object of the class \code{"try-error"} containing the error message
        and error condition as the \code{"condition"} attribute.
}
\description{
\code{tryLog} is a wrapper function around \code{\link{tryCatchLog}}
that traps any errors that occur during the evaluation of an expression without stopping the execution
of the script (similar to \code{\link{try}}). Errors, warnings and messages are logged.
In contrast to \code{\link{tryCatchLog}} it returns but does not stop in case of an error and therefore does
not have the \code{error} and \code{finally} parameters to pass in custom handler functions.
}
\details{
\code{tryLog} is implemented using \code{\link{tryCatchLog}}. If you need need more flexibility for
         catching and handling errors use the latter.
         Error messages are never printed to the \code{\link{stderr}} connection but logged only.
}
\examples{
tryLog(log(-1))   # logs a warning
tryLog(log("a"))  # logs an error
}
\seealso{
\code{\link{tryCatchLog}},
         \code{\link{last.tryCatchLog.result}}
}
