% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropicalsparse.mm.R
\name{tropicalsparse.mm}
\alias{tropicalsparse.mm}
\title{tropicalsparse.mm()}
\usage{
tropicalsparse.mm(alpha = NULL, A, opA = FALSE, B, opB = FALSE,
  beta = NULL, C, opC = FALSE, store = NULL, algebraType)
}
\arguments{
\item{alpha}{is a single real value.}

\item{A}{is a matrix.}

\item{opA}{is transpose of \code{A}.}

\item{B}{is a matrix.}

\item{opB}{is transpose of \code{B}.}

\item{beta}{is a single real value.}

\item{C}{is a matrix.}

\item{opC}{is transpose of \code{C}.}

\item{store}{is storage technique.}

\item{algebraType}{is string input that can be \code{minplus} or \code{maxplus}.}
}
\value{
Returns the resultant matrix.
}
\description{
\code{tropicalsparse.mm} function performs the matrix-matrix operation on the equation: y = alpha * op(A) * op(B) + beta * op(C).
}
\details{
The input of this function is three matrices, two constants, operation on these matrices, storage
technique and  type of Tropical Algebra. Matrices and \code{algebraType} inputs are compulsory while all other
inputs are optional. \code{A}, \code{B} and \code{C} must be the matrix of same dimensions and these matrices
must be sparse otherwise error occured. \code{alpha} and \code{beta} must be the single real value. \code{opA},
\code{opB} and \code{opC} can be set to TRUE to take transpose of \code{A}, \code{B} and \code{C} matrices
repectively. \code{store} input can be \code{coo}, \code{csc} and \code{csr} for applying following storage
techniques respectively: Coordinate-Wise, Compressed Sparse Row, Compressed Sparse Column. If \code{store} is
not specified then functionality is performed without using any storage technique. \code{algebraType} is used
to specify type of Tropical Algebra. This can be \code{minplus} or \code{maxplus}. For more details about
\code{algebraType}, see \code{detail} section of \code{\link{check.infinityM}} or \code{\link{check.infinityV}}.
First of all \code{A} is multiplied with \code{B} and if \code{alpha} is given then the product of \code{A} and
\code{B} will be multipied with \code{alpha} otherwise it remais the same. After this, \code{beta} is
multiplied with \code{C} only if \code{beta} is given. Finally, both result are added to each other and the
resultant matrix is obtained. Same functionailty is applied if any of the \code{store} technique is specified.
}
\examples{
a <- matrix(data = c(2, Inf, Inf, 0, Inf, Inf, Inf, 10, Inf),
nrow = 3, ncol = 3, byrow = TRUE)

b <- matrix(data = c(Inf, Inf, 4, Inf, -0.3, Inf, Inf, 2, Inf),
nrow = 3, ncol = 3, byrow = TRUE)

c <- matrix(data = c(1, Inf, Inf, Inf, 0, 6, Inf, Inf, Inf),
nrow = 3, ncol = 3, byrow = TRUE)

tropicalsparse.mm(A = a, alpha = 5, opB = TRUE, B = b, C = c,
store = 'csr', algebraType = 'minplus')

#      [,1] [,2] [,3]
# [1,]    1  Inf  Inf
# [2,]  Inf  0.0    6
# [3,]  Inf 14.7   17

}
