\docType{class}
\name{trip-class}
\alias{lines,trip-method}
\alias{plot,trip,missing-method}
\alias{show,summary.TORdata-method}
\alias{show,trip-method}
\alias{subset,trip-method}
\alias{summary,trip-method}
\alias{trip-class}
\title{A class for sets of animal trips (track data).}
\description{
  An extension of \code{\link[sp]{SpatialPointsDataFrame}}
  by including \code{"TimeOrderedRecords"}.  The records
  within the data frame are explicitly ordered by DateTime
  data within IDs.
}
\section{Objects from the Class}{
  Objects can be created by calls of the form
  \code{trip(obj="SpatialPointsDataFrame",
  TORnames="TimeOrderedRecords")}. The object contains all
  the slots present within a
  \code{\link[sp]{SpatialPointsDataFrame}}, particularly
  \code{data} which contains columns of at least those
  specified by \code{TOR.columns}.
}
\examples{
showClass("trip")

## Examples of general methods
## Continuing the example from '?trip-methods:
utils::example("trip-methods", package="trip",
               ask=FALSE, echo=FALSE)
summary(tr)
plot(tr)
lines(tr)

dim(tr)
names(tr)
subset(tr, id == "2")
as.data.frame(tr)

tr[1:3, ]
tr[, 1]
tr[[1]]

if (exists("porpoise")) {
    dim(porpoise)
    names(porpoise)
    porpoise[porpoise[["id"]] == "GUS", ]
}
}
\seealso{
  \code{\link{trip}} for examples of directly using the
  class.

  \code{\link{trip-accessors}} describes methods for
  accessing information on \code{trip} objects.
}
\keyword{classes}

