! This file contains general functions for a logic regression that
! are required for performing a trio logic regression.
! This file is a modified version of the file slogic.f from the R package
! LogicReg developed by Ingo Ruczinski and Charles Kooperberg and has
! been generated by removing all functionalities and features not required
! for a trio logic regression from slogic.f and by renaming the
! subroutines and functions.
! Score and fitting functions for a trio logic regression are stored
! in trioLR.f.

! Modifications were made by Holger Schwender. 

! =====================================================================
! Copyright (C) 1999-2011  Ingo Ruczinski and Charles Kooperberg

! This program is free software; you can redistribute it and/or modify
! it under the terms of the GNU General Public License as published by
! the Free Software Foundation; either version 2 of the License, or
! (at your option) any later version.

! This program is distributed in the hope that it will be useful,
! but WITHOUT ANY WARRANTY; without even the implied warranty of
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
! GNU General Public License for more details.

! The text of the GNU General Public License, version 2, is available
! as http://www.gnu.org/copyleft or by writing to the Free Software
! Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

! The main reference for Logic Regression is
! Ruczinski I, Kooperberg C, LeBlanc M (2003). Logic Regression,
! Journal of Computational and Graphical Statistics, 12, 475-511
! Other references can be found on our homepages
! http://www.biostat.jhsph.edu/~iruczins/
! http://kooperberg.fhcrc.org
! You can contact us at ingo@jhu.edu and clk@fhcrc.org
! =======================================================================


      ! Name in slogic.f: annealing

      SUBROUTINE tanneal(n1,n2,mdl,nkn,ntr,conc,negs,pick,term,
     #                     storage,slprbc,datri,weight,tstr,tend,tint,
     #                     ehm,msz,nsep,seps,cnc,score,betas,
     #                     ssize,dcph,ordrs,nfcnt,penalty,resp,mtm,
     #                     mcmc,hyperpars,rd1,rd2,rd3,rd4,bout)
      IMPLICIT NONE

        ! parameters
          INTEGER LGCnknMAX,LGCntrMAX,LGCn1MAX,LGCn2MAX,LGCbetaMAX
          PARAMETER (LGCn1MAX   = 20000)
          PARAMETER (LGCn2MAX   =  1000)
          PARAMETER (LGCnknMAX  =   128)
          PARAMETER (LGCntrMAX  =     5)
          PARAMETER (LGCbetaMAX =    55)

        ! arguments in
          INTEGER ehm,n1,n2,mdl,msz,nkn,ntr,nsep,nfcnt,mtm
          INTEGER cnc(3),dcph(n1),ordrs(n1),storage(2*ntr*nkn*n1) 
          REAL tstr,tend,tint,slprbc(25),weight(n1),rd2(1),rd3(1)
          REAL resp(n1),seps(nsep,n1)
          REAL penalty,hyperpars(10)
          INTEGER datri(n2,n1),mcmc,rd1(1),rd4(1),bout
        ! local
          INTEGER i,j,accept,fcnt,hm,nac,nop,npertemp,tcnt,nrj,nde
          INTEGER nac2,ntot,npckmv(6,LGCntrMAX)
          INTEGER pickmv(6,LGCnknMAX,LGCntrMAX),nsame,nsame2
          REAL acr,sco,temp,rsp(LGCn1MAX)
          INTEGER iearly(0:6,LGCntrMAX,0:LGCnknMAX,LGCn2MAX,0:1,2)
          INTEGER earlyup
          REAL rearly(0:6,LGCntrMAX,0:LGCnknMAX,LGCn2MAX,0:1,2)
          INTEGER prtr(LGCn1MAX,LGCntrMAX)
          REAL cbetas(0:LGCbetaMAX),xtxsep(LGCbetaMAX+1,LGCbetaMAX+1)
          INTEGER visit(2+ntr*nkn),new
          REAL lvisit(2)

        ! arguments out
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER pick(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
          INTEGER ssize
          REAL score(3),betas(3,0:(nsep+ntr))
          CHARACTER *80 astring

        ! npckmv: how many available for a move of a particular type 
        ! pickmv: which available for a move of a particular type
        ! prtr: logic trees predictions

      ! calculate response for scoring function
        DO i=1,LGCn1MAX
           DO j=1,LGCntrMAX
              prtr(i,j)=0
           END DO
        END DO
        nsame2=0
        nac2=0
        DO j=0,(nsep+ntr)
           betas(1,j)=0
           betas(2,j)=0
           betas(3,j)=0
        END DO
        DO j=1,n1
          rsp(j)=resp(j) 
        END DO
      ! carry out an initial simulated annealing step
        CALL tsainit(n1,n2,mdl,nkn,ntr,conc,negs,pick,term,
     #                      storage,datri,rsp,weight,npckmv,
     #                      pickmv,score,betas,ssize,nsep,seps,
     #                      nop,dcph,ordrs,penalty,prtr,cbetas,xtxsep,
     #                      mtm,mcmc,hyperpars)
        IF (msz.EQ.0) THEN
          GOTO 2424
        END IF
        earlyup=0
        CALL tclearly(iearly,ntr,nkn,n2)

      ! carry out an annealing chain
        IF (tstr.EQ.0.0.AND.tend.EQ.0.0) THEN
      !   carry out an annealing chain with defaults
      !   find starting temperature
          tstr=3
          acr=1.0 
          tcnt=0
          hm=100
          temp=(10.0**tstr)
          DO WHILE (acr.GT.0.75)
            temp=(10.0**tstr)*(10.0**(-tcnt/5.0))
            nac=0
            nsame=0
            nrj=0
            nde=0
            DO j=1,hm        
              sco=score(1)
              new=nac
              CALL tsastep(n1,n2,mdl,nkn,ntr,conc,negs,
     #                            pick,term,storage,npckmv,
     #                            pickmv,temp,slprbc,datri,rsp,
     #                            weight,msz,nsep,seps,cnc,score,
     #                            betas,ssize,nop,dcph,ordrs,accept,
     #                            penalty,iearly,rearly,earlyup,prtr,
     #                            cbetas,xtxsep,mtm,mcmc,hyperpars)
              IF(accept.LT.0)score(1)=sco
              IF(accept.LT.0)nrj=nrj+1
              IF(accept.EQ.0)nde=nde+1
              IF(accept.GT.0)THEN
                earlyup=earlyup+2
                  nac=nac+1
                  IF(sco.EQ.score(1))nsame=nsame+1
              END IF
            END DO
            acr=REAL(nac)/REAL(hm-nrj)
            tcnt=tcnt+1
          END DO

      !   start annealing using the scheme just found
          tstr=REAL(INT(LOG10(temp)))+1+1
          temp=(10.0**tstr)
          CALL twriteinfo(ehm,mdl,0,nsep,ntr,temp,score,betas,
     #         nac,nrj,nde,nsame)
          npertemp=MIN(5000,50*n2)
          if(ehm.GT.0) ehm=npertemp
          tcnt=1
          fcnt=0
          CALL twriteinfo(ehm,mdl,0,nsep,ntr,temp,score,betas,
     #                   nac,nrj,nde,nsame)
          DO WHILE (fcnt.LT.5)
            nac=0
            nsame=0
            nrj=0
            nde=0
            temp=(10.0**tstr)*(10.0**(-tcnt/20.0))
            DO j=1,npertemp        
              sco=score(1)
              new=nac
              CALL tsastep(n1,n2,mdl,nkn,ntr,conc,negs,
     #                            pick,term,storage,npckmv,
     #                            pickmv,temp,slprbc,datri,rsp,
     #                            weight,msz,nsep,seps,cnc,score,
     #                            betas,ssize,nop,dcph,ordrs,accept,
     #                            penalty,iearly,rearly,earlyup,prtr,
     #                            cbetas,xtxsep,mtm,mcmc,hyperpars)
              IF(accept.LT.0)score(1)=sco
              IF(accept.LT.0)nrj=nrj+1
              IF(accept.GT.0)THEN
                earlyup=earlyup+2
                nac=nac+1
                IF(sco.EQ.score(1))nsame=nsame+1
              END IF
              IF (sco.NE.score(1))THEN
                earlyup=earlyup+2
              END IF
              nde=j-nrj-nac
              nac2=nac
              nsame2=nsame
              CALL twriteinfo(ehm,mdl,j,nsep,ntr,temp,score,betas,
     #                       nac,nrj,nde,nsame)
              IF (nac.GT.500.AND.j.LT.npertemp) THEN
                CALL twriteinfo(ehm,mdl,ehm,nsep,ntr,temp,score,
     #                         betas,nac,nrj,nde,nsame)
                GOTO 1212
              END IF
            END DO
 1212       CONTINUE
            IF ((nac2-nsame2).LE.10) fcnt=fcnt+1
            IF ((nac2-nsame2).GT.10) fcnt=0
            tcnt=tcnt+1
          END DO
          tstr=0.0
          tend=0.0
        ELSE
      !   carry out an annealing chain with pre-specified values
          fcnt=0
          nac=0
          nrj=0
          nde=0
          nac2=0
          nsame=0
          ntot=0
          DO i=0,INT(tint)
            temp=(10.0**tstr)*(10.0**((tend-tstr)/tint))**REAL(i)
            if(mcmc.GT.0)temp= -(REAL(i)/10000)-1
            CALL twriteinfo(ehm,mdl,i,nsep,ntr,temp,score,betas,
     #                     nac,nrj,nde,nsame)
            temp=(10.0**tstr)*(10.0**((tend-tstr)/tint))**REAL(i)
            sco=score(1)
            new=nac
            CALL tsastep(n1,n2,mdl,nkn,ntr,conc,negs,pick,
     #                          term,storage,npckmv,pickmv,
     #                          temp,slprbc,datri,rsp,weight,msz,
     #                          nsep,seps,cnc,score,betas,ssize,nop,
     #                          dcph,ordrs,accept,penalty,iearly,
     #                          rearly,earlyup,prtr,cbetas,xtxsep,mtm,
     #                          mcmc,hyperpars)
             IF(accept.LT.0)score(1)=sco
             IF(accept.LT.0)nrj=nrj+1
             IF(accept.GT.0)THEN
               earlyup=earlyup+2
               nac=nac+1
               IF(sco.EQ.score(1))nsame=nsame+1
             END IF
             IF(sco.NE.score(1))THEN
               earlyup=earlyup+2
             END IF
             IF(accept.EQ.0)nde=nde+1
             IF(sco.NE.score(1).and.accept.GT.0) nac2=nac2+1
             ntot=ntot+1
             IF(ntot.EQ.nfcnt.AND.mcmc.EQ.0) THEN
               IF(nac2.LE.10)fcnt=fcnt+1
               IF(nac2.GT.10)fcnt=0
               nac2=0
               ntot=0
               IF(fcnt.EQ.5)goto 1216
             END IF
             IF(mcmc.GT.0.AND.i.GT.nfcnt)THEN
                IF(i.EQ.(nfcnt+1))THEN
                   CALL tstore1(mcmc,new,hyperpars,lvisit,visit,
     #                           ntr,nkn,conc,negs,term,-17,
     #                           rd1,rd2,rd3,rd4,bout,n2)
                   IF(bout.GE.0)CALL ctiwrite()
                ELSE
                   CALL tstore1(mcmc,new,hyperpars,lvisit,visit,
     #                           ntr,nkn,conc,negs,term,nac,
     #                           rd1,rd2,rd3,rd4,bout,n2)
                END IF
             END IF
          END DO
 1216     CONTINUE
        END IF
        IF(nac+nrj+nde.GT.1)THEN
          CALL twriteinfo(ehm,mdl,ehm,nsep,ntr,temp,score,
     #                   betas,nac,nrj,nde,nsame)
        END IF
 2424   CONTINUE
      END 

      ! *****************************************************************
      ! *****************************************************************

      ! Name in slogic.f: annealing_init

      SUBROUTINE tsainit(n1,n2,mdl,nkn,ntr,conc,negs,pick,term,
     #                          storage,datri,rsp,weight,npckmv,
     #                          pickmv,score,betas,ssize,nsep,
     #                          seps,nop,dcph,ordrs,penalty,prtr,cbetas,
     #                          xtxsep,mtm,mcmc,hyperpars)
      IMPLICIT NONE

      ! arguments in
        INTEGER n1,n2,mdl,nkn,nsep,ntr,dcph(n1),ordrs(n1),mtm
        INTEGER conc(nkn,ntr,3),mcmc
        INTEGER negs(nkn,ntr,3)
        INTEGER pick(nkn,ntr,3)
        INTEGER term(nkn,ntr,3)
        INTEGER storage(2*ntr*nkn*n1)
        INTEGER prtr(n1,ntr),datri(n2,n1)
        REAL rsp(n1),weight(n1),hyperpars(10)
        REAL seps(nsep,n1),cbetas(0:(nsep+ntr)),xtxsep(0:nsep,0:nsep)
      ! local
        INTEGER j,i,k,wh
        REAL penalty,pp
      ! arguments out
        INTEGER nop,reject,ssize,npckmv(6,ntr)
        INTEGER pickmv(6,nkn,ntr)
        REAL score(3),betas(3,0:(nsep+ntr))

      ! initialize and score the first model
        CALL tinit(n1,ntr,nkn,conc,term,negs,pick,storage,score)
        CALL tstore(nkn,ntr,conc,pick,npckmv,pickmv,ssize,nop)
        DO wh=1,ntr
          CALL tevalfirst(wh,n1,n2,nkn,ntr,conc,term,negs,pick,
     #                        datri,prtr)
        END DO
        CALL tscore(prtr,rsp,dcph,ordrs,weight,n1,ntr,mdl,nop,
     #               wh,nsep,seps,score,cbetas,reject,xtxsep,mtm,0)
        DO j=0,(nsep+ntr)
          betas(1,j)=cbetas(j)
        END DO
        IF (reject.EQ.1) THEN
          CALL REXIT("Initial model could not be fitted!")
        END IF
        score(1)=score(1)+penalty*ssize
        DO j=1,3
          IF(mcmc.EQ.0)score(j)=score(1)
          DO k=0,(nsep+ntr)
            betas(j,k)=betas(1,k)
          END DO
        END DO
        IF(mcmc.GT.0)THEN
           CALL poorprior(score,ssize,ntr,nkn,
     #           hyperpars,n2,-1,weight,(REAL(1.)),0)
        END IF
      END

      ! *****************************************************************
      ! *****************************************************************

      ! Name in slogic.f: annealing_step

      SUBROUTINE tsastep(n1,n2,mdl,nkn,ntr,conc,negs,pick,
     #                          term,storage,npckmv,pickmv,
     #                          temp,slprbc,datri,rsp,weight,msz,
     #                          nsep,seps,cnc,score,betas,ssize,nop,
     #                          dcph,ordrs,accept,penalty,iearly,rearly,
     #                          earlyup,prtr,cbetas,xtxsep,mtm,mcmc,
     #                          hyperpars)
      IMPLICIT NONE
        ! parameters
          INTEGER LGCnknMAX
          PARAMETER (LGCnknMAX  =   128)
        ! arguments in
          INTEGER n1,n2,msz,mdl,nkn,nsep,ntr,mtm
          INTEGER cnc(3),mcmc
          INTEGER dcph(n1),ordrs(n1)
          INTEGER npckmv(6,ntr)
          INTEGER pickmv(6,nkn,ntr)
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER pick(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
          INTEGER storage(2*ntr*nkn*n1)
          INTEGER prtr(n1,ntr),datri(n2,n1)
          REAL temp,penalty,hyperpars(10)
          REAL score(3),cbetas(0:(nsep+ntr))
          REAL rsp(n1),weight(n1),zz,zz2
          REAL slprbc(25)
          REAL xtxsep(0:nsep,0:nsep)
          REAL seps(nsep,n1)
          INTEGER iearly(0:6,ntr,0:nkn,n2,0:1,2),earlyup
          REAL rearly(0:6,ntr,0:nkn,n2,0:1,2)
        ! local
          INTEGER j,l1,l2,letter,neg,opper
          INTEGER knt,mtp,nwkv,reject,wh
          INTEGER wkv(LGCnknMAX),xrej,nopold
          REAL xsc(3)
        ! arguments out
          INTEGER accept,nop,ssize,mctry
          REAL betas(3,0:(nsep+ntr)),rr,rr2,rr3
          

      ! carry out one annealing step
        hyperpars(8)=0.
        if(mcmc.GT.0)temp=1.
        mctry=0
147     CALL tmove(n2,nkn,ntr,conc,negs,pick,term,slprbc,cnc,mcmc,
     #             npckmv,pickmv,msz,ssize,nop,wh,knt,mtp,mctry)
        letter=1
        neg=1
        opper=1
        IF(mtp.EQ.1)THEN
           letter=term(knt,wh,1)
           neg=negs(knt,wh,1)
        END IF
        IF(mtp.EQ.4.or.mtp.EQ.5)THEN
           letter=term(2*knt+1,wh,1)
           neg=negs(2*knt+1,wh,1)
           opper=conc(knt,wh,1)
        END IF

        IF(mtp.GE.3)THEN
           rr=npckmv(mtp,wh)
           rr2=slprbc(1)
           IF(npckmv(2,wh).GT.0)rr2=rr2+slprbc(2)-slprbc(1)
           IF(npckmv(3,wh).GT.0)rr2=rr2+slprbc(3)-slprbc(2)
           IF(npckmv(4,wh).GT.0)rr2=rr2+slprbc(4)-slprbc(3)
           IF(npckmv(5,wh).GT.0)rr2=rr2+slprbc(5)-slprbc(4)
           IF(npckmv(6,wh).GT.0)rr2=rr2+slprbc(6)-slprbc(5)
           rr2=(slprbc(mtp)-slprbc(mtp-1))/rr2
           rr=rr/rr2
         END IF
        IF(iearly(mtp,wh,knt,letter,neg,opper).LE.
     #               earlyup.OR.(mcmc.GT.0).OR.(mtp.eq.0))THEN
        nopold=nop
        CALL tstore(nkn,ntr,conc,pick,npckmv,pickmv,ssize,nop)
        CALL tevaluate(wh,knt,mtp,n1,n2,nkn,ntr,conc,term,negs,
     #                  datri,prtr,storage,nwkv,wkv)
        CALL tscore(prtr,rsp,dcph,ordrs,weight,n1,ntr,mdl,nop,wh,
     #               nsep,seps,score,cbetas,reject,xtxsep,mtm,nopold)

      ! take care that the there is real convergence
          l1=0 
          l2=0
          zz2=0
          IF(betas(1,1).GT. -10000.)l1=1
          IF(betas(1,1).LT. 10000.)l2=1
          IF(l1+l2.EQ.0)reject=1
          IF(reject.eq.0.and.mcmc.gt.0.and.mdl.eq.1)THEN
             zz=0
             DO j=1,n1
                zz=zz+rsp(j)
             END DO
             zz=zz/n1
             zz2=0
             DO j=1,n1
                zz2=zz2+(rsp(j)-zz)*(rsp(j)-zz)
             END DO
             zz2=(zz2/(n1-1))
          END IF
          DO j=0,(nsep+ntr)
            betas(1,j)=cbetas(j)
          END DO
          IF (reject.EQ.1) THEN
            accept=-1
            iearly(mtp,wh,knt,letter,neg,opper)=earlyup+2
          ELSE 
            IF(mdl.EQ.2)THEN
               score(1)=score(1)+penalty/(REAL(n1))*ssize
            ELSE 
               score(1)=score(1)+penalty*ssize
            END IF
            IF(mdl.EQ.1.and.mcmc.GT.0)THEN
               score(1)=score(1)*score(1)*n1/zz2
            END IF
            iearly(mtp,wh,knt,letter,neg,opper)=earlyup+1
            rearly(mtp,wh,knt,letter,neg,opper)=score(1)
            IF(mcmc.GT.0) THEN
               IF(mtp.GE.3)THEN
                  IF(mtp.EQ.3)rr=rr/(REAL(npckmv(4,wh)))
                  IF(mtp.EQ.4)rr=rr/(REAL(npckmv(3,wh)))
                  IF(mtp.EQ.5)rr=rr/(REAL(npckmv(6,wh)))
                  IF(mtp.EQ.6)rr=rr/(REAL(npckmv(5,wh)))
                  rr3=slprbc(1)
                  IF(npckmv(2,wh).GT.0)rr3=rr3+slprbc(2)-slprbc(1)
                  IF(npckmv(3,wh).GT.0)rr3=rr3+slprbc(3)-slprbc(2)
                  IF(npckmv(4,wh).GT.0)rr3=rr3+slprbc(4)-slprbc(3)
                  IF(npckmv(5,wh).GT.0)rr3=rr3+slprbc(5)-slprbc(4)
                  IF(npckmv(6,wh).GT.0)rr3=rr3+slprbc(6)-slprbc(5)
                  IF(mtp.EQ.3)rr3=(slprbc(4)-slprbc(3))/rr3
                  IF(mtp.EQ.4)rr3=(slprbc(3)-slprbc(2))/rr3
                  IF(mtp.EQ.5)rr3=(slprbc(6)-slprbc(5))/rr3
                  IF(mtp.EQ.6)rr3=(slprbc(5)-slprbc(4))/rr3
                  rr=rr*rr3
               ELSE
                  rr=1.
               END IF
               CALL poorprior(score,ssize,ntr,nkn,
     #           hyperpars,n2,mtp,slprbc,rr,nopold-nop)
            END IF
            CALL tdecide(score,temp,accept,hyperpars(8),mcmc)
          END IF
          CALL trecord(accept,wh,nkn,ntr,nsep,score,betas,
     #                   conc,negs,pick,term,mcmc)
          CALL trestore(accept,wh,n1,nkn,ntr,storage,nwkv,wkv)
          CALL tstore(nkn,ntr,conc,pick,npckmv,pickmv,ssize,nop)
          IF(reject.EQ.1.AND.mcmc.GE.0.AND.mctry.LT.10)THEN
             mctry=mctry+1
             GOTO 147
          END IF
        ELSE
          IF(iearly(mtp,wh,knt,letter,neg,opper).EQ.(earlyup+2))THEN
            reject=1
            accept=-1
          ELSE
            reject=0
            score(1)=rearly(mtp,wh,knt,letter,neg,opper)
            CALL tdecide(score,temp,accept,hyperpars(8),mcmc)
            IF(accept.EQ.1)THEN
              CALL tstore(nkn,ntr,conc,pick,npckmv,pickmv,ssize,nop)
              CALL tevaluate(wh,knt,mtp,n1,n2,nkn,ntr,conc,term,negs,
     #                        datri,prtr,storage,nwkv,wkv)
              CALL tscore(prtr,rsp,dcph,ordrs,weight,n1,ntr,mdl,nop,wh,
     #                     nsep,seps,xsc,cbetas,xrej,xtxsep,mtm,1000)
              CALL trecord(accept,wh,nkn,ntr,nsep,score,betas,
     #                       conc,negs,pick,term,mcmc)
              CALL trestore(accept,wh,n1,nkn,ntr,storage,nwkv,wkv)
              CALL tstore(nkn,ntr,conc,pick,npckmv,pickmv,ssize,nop)
            ELSE
              score(1)=score(2)
            END IF
          END IF
        END IF
           
      END 

      ! *****************************************************************
      ! *****************************************************************

      ! Name in slogic.f: writeinfo

      SUBROUTINE twriteinfo(ehm,mdl,i,nsep,ntr,temp,score,betas,
     #                   nac,nrj,nde,nsame)
      IMPLICIT NONE

        ! arguments in
          INTEGER ehm,i,mdl,nsep,ntr,nac,nrj,nde,nsame
          REAL temp,score(3),betas(3,0:(ntr+nsep)),t2
          DOUBLE PRECISION t1,ourlog
        ! local
          INTEGER j
          CHARACTER *120 astring
        ! arguments out
        ! none

      ! print info
        t1=temp
        IF(t1.GT.0.0)  THEN
            t1=ourlog(t1)/2.302585092994046
        ELSE 
            t1= -temp-1 
        END IF
        t2=t1
        IF (ehm.GT.0) THEN
          IF (mdl.EQ.1) THEN
            IF (i.EQ.0) THEN
              astring(1:26)="log-temp current score    "
              astring(27:59)="best score        acc / rej /sing"
              CALL tprintstring(astring,59)
            END IF
            IF (MOD(i,ehm).EQ.0) THEN
              CALL maketrstring(1,8,astring,t2,4,3)
              CALL maketrstring(9,22,astring,score(1),9,4)
              CALL maketrstring(23,36,astring,score(3),9,4)
              CALL maketstring(37,42,astring,nac-nsame,6)
              astring(43:43)="("
              CALL maketstring(44,46,astring,nsame,3)
              astring(47:47)=")"
              CALL maketstring(48,53,astring,nde,6)
              CALL maketstring(54,59,astring,nrj,6)
              CALL tprintstring(astring,59)
            END IF
          ELSE 
            IF (i.EQ.0) THEN
              astring(1:26)="log-temp current score    "
              IF(temp.LT.0)astring(1:26)="iter(10k)  current scr    "
              astring(27:59)="best score        acc / rej /sing"
              astring(60:81)="    current parameters"
              CALL tprintstring(astring,81)
            END IF
            IF (MOD(i,ehm).EQ.0) THEN
              CALL maketrstring(1,8,astring,t2,4,3)
              CALL maketrstring(9,22,astring,score(1),9,4)
              CALL maketrstring(23,36,astring,score(3),9,4)
              IF(i.eq.0.AND.temp.LT.0)THEN
              CALL maketrstring(23,36,astring,score(1),9,4)
              END IF
              CALL maketstring(37,42,astring,nac-nsame,6)
              astring(43:43)="("
              CALL maketstring(44,46,astring,nsame,3)
              astring(47:47)=")"
              CALL maketstring(48,53,astring,nde,6)
              CALL maketstring(54,59,astring,nrj,6)
              IF((nsep+ntr).LT.4)THEN
                DO j=0,(nsep+ntr)
                  astring((60+j*9):(60+j*9))=" "
                  CALL maketrstring(61+j*9,68+j*9,astring,
     #                               betas(1,j),4,3)
                END DO
                CALL tprintstring(astring,68+9*(nsep+ntr))
              ELSE
                DO j=0,4
                  astring((60+j*9):(60+j*9))=" "
                  CALL maketrstring(61+j*9,68+j*9,astring,
     #                               betas(1,j),4,3)
                END DO
                CALL tprintstring(astring,68+9*4)
                astring(1:12)="===========>"
                astring(13:32)="                    "
                astring(33:52)="                    "
                astring(53:72)="                    "
                astring(73:92)="                    "
                DO j=5,(nsep+ntr)
                  IF(j.LT.13)THEN
                    CALL maketrstring(j*9-13,j*9-6,astring,
     #                               betas(1,j),4,3)
                  END IF
                  IF(j.EQ.13) astring(85:89)="...."
                END DO
                IF(nsep+ntr.GE.13)THEN
                   CALL tprintstring(astring,89)
                ELSE
                   IF(nsep+ntr.GT.4)
     #               CALL tprintstring(astring,(nsep+ntr-2)*9-5)
                END IF
              END IF
            END IF
          END IF
          IF (MOD(i,ehm).EQ.0) THEN
            nac=0
            nde=0
            nrj=0
            nsame=0
          END IF
        END IF

      END 


      ! *****************************************************************
      ! *****************************************************************


      ! Name in slogic.f: deciding

      SUBROUTINE tdecide(score,temp,accept,postrat,mcmc)
      IMPLICIT NONE

        ! arguments in
          REAL temp,score(3),postrat
        ! local
          REAL rnum,ourrand
          DOUBLE PRECISION crit,z,ourexp
        ! arguments out
          INTEGER accept,mcmc

      ! make decision using standard acceptance function
        rnum=ourrand(0)
        accept=0
        IF(mcmc.EQ.0)THEN
           z=-(score(1)-score(2))/temp
        ELSE
      ! Bayesian
           z= -score(1)+score(2)+postrat
        END IF
        IF(z.GT.0)THEN
          accept=1
        ELSE
          crit=ourexp(z)
          IF (rnum.LT.crit) accept=1
        END IF

      END 

      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine evaluates the initial (empty) logic trees.
      ! to start with non-empty trees, use commented out statement
      ! in the last line for some more programming.
      ! it is rather inefficient, but only used in the very first step
      ! of the algorithm, so it doesn't matter.
      ! Name in slogic.f: evaluate_first

      SUBROUTINE tevalfirst(wh,n1,n2,nkn,ntr,conc,term,negs,pick,
     #                          datri,prtr)
      IMPLICIT NONE

        ! parameters
          INTEGER LGCnknMAX,LGCn1MAX
          PARAMETER (LGCn1MAX   = 20000)
          PARAMETER (LGCnknMAX  =   128)
        ! arguments in
          INTEGER n1,n2,nkn,ntr,wh
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER pick(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
          INTEGER datri(n2,n1)
        ! local
          INTEGER dim,dp,i,j,k,pc,shuffle,rank(LGCnknMAX),iterm
          INTEGER mat(LGCn1MAX+2,LGCnknMAX)
        ! arguments out
          INTEGER prtr(n1,ntr)


        ! initialize mat and rank
          DO k=1,nkn
            rank(k)=0
            DO j=1,(n1+2)
              mat(j,k)=0
            END DO
          END DO

      ! write leaf information into mat
        pc=1
        DO i=1,nkn
          IF (pick(i,wh,1).EQ.1) THEN
            IF (conc(i,wh,1).EQ.3) THEN
             iterm=term(i,wh,1)
              IF (negs(i,wh,1).EQ.0) THEN
                DO dp=1,n1
                  mat(dp,pc)=datri(iterm,dp)           
                END DO
              ELSE
                DO dp=1,n1
                  mat(dp,pc)=(1-datri(iterm,dp))**2  
                END DO
              END IF
              mat(n1+1,pc)=i
              IF (i.GT.1) mat(n1+2,pc)=conc(INT(i/2),wh,1)
              pc=pc+1
            END IF
          END IF
        END DO
        dim=pc-1

      ! evaluate mat sequentially in the second argument as good as possible
 1000   CONTINUE
        IF (dim.GT.1) THEN
          DO pc=dim,2,-1
            IF (((MOD(mat(n1+1,pc),2).EQ.1).AND.
     #           (mat(n1+1,pc).EQ.mat(n1+1,pc-1)+1)).OR.
     #         ((MOD(mat(n1+1,pc),2).EQ.0).AND.
     #           (mat(n1+1,pc).EQ.mat(n1+1,pc-1)-1))) THEN
              IF (mat(n1+2,pc).EQ.1) THEN
                DO j=1,n1
                  mat(j,pc-1)=mat(j,pc-1)*mat(j,pc)
                END DO
              ELSE
                DO j=1,n1
                  mat(j,pc-1)= MAX(mat(j,pc-1),mat(j,pc))
                END DO
              END IF
              mat(n1+1,pc-1)=INT(mat(n1+1,pc)/2)
              IF (INT(mat(n1+1,pc)/2).GT.1) THEN
                 mat(n1+2,pc-1)=conc(INT(INT(mat(n1+1,pc)/2)/2),wh,1)
              ELSE
                mat(n1+2,pc-1)=0
              END IF
              DO k=pc,dim
                DO j=1,n1+2
                  mat(j,k)=mat(j,k+1)
                END DO
              END DO
              dim=dim-1
              GOTO 1000
            END IF
          END DO
        END IF

      ! shuffle mat in second argument if necessary
        IF (dim.GT.1) THEN
          shuffle=0
 2000     CONTINUE
          DO WHILE (shuffle.LT.dim)
            shuffle=shuffle+1
            DO i=1,dim
              rank(i)=1
              DO j=1,dim
                IF (mat(n1+1,i).GT.mat(n1+1,j)) rank(i)=rank(i)+1
              END DO
            END DO 
            DO i=1,dim
              DO j=1,(dim-1)
                IF ((rank(j).EQ.i).AND.(i.NE.j)) THEN
                  DO k=1,n1+2
                    mat(k,dim+1)=mat(k,i)
                    mat(k,i)=mat(k,j)
                    mat(k,j)=mat(k,dim+1)                    
                    mat(k,dim+1)=0
                  END DO
                  GOTO 2000
                END IF 
              END DO
            END DO 
          END DO
          GOTO 1000
        END IF         

      ! write out tree prediction
        DO j=1,n1
          prtr(j,wh)=mat(j,1)
        END DO

      END 

      ! *****************************************************************
      ! *****************************************************************


      ! this subroutine chooses the appropriate evaluation routine
      ! name in slogic.f: evaluating

      SUBROUTINE tevaluate(wh,knt,mtp,n1,n2,nkn,ntr,conc,term,negs,
     #                      datri,prtr,storage,nwkv,wkv)
      IMPLICIT NONE

        ! arguments in
          INTEGER knt,mtp,n1,n2,nkn,ntr,wh
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
          INTEGER datri(n2,n1)
        ! local
          INTEGER j,k
        ! arguments out
      ! choose routine
          INTEGER nwkv,wkv(nkn),prtr(n1,ntr)
          INTEGER storage(2*ntr*nkn*n1)

        IF (mtp.EQ.0) THEN
          CALL tevalfirstknot(wh,n1,n2,nkn,ntr,term,negs,
     #                            datri,storage,nwkv,wkv)
        ELSE IF (mtp.EQ.1) THEN
          CALL tevalaltlf(wh,knt,n1,n2,nkn,ntr,conc,term,negs,
     #                        datri,storage,nwkv,wkv)
        ELSE IF (mtp.EQ.2) THEN
          CALL tevalaltop(wh,knt,n1,nkn,ntr,conc,
     #                        storage,nwkv,wkv)
        ELSE IF (mtp.EQ.3) THEN
          CALL tevaldelete(wh,knt,n1,nkn,ntr,conc,
     #                         storage,nwkv,wkv)
        ELSE IF (mtp.EQ.4) THEN
          CALL tevalsplit(wh,knt,n1,n2,nkn,ntr,conc,term,negs,
     #                        datri,storage,nwkv,wkv)
        ELSE IF (mtp.EQ.5) THEN
          CALL tevalbranch(wh,knt,n1,n2,nkn,ntr,conc,term,negs,
     #                         datri,storage,nwkv,wkv)
        ELSE IF (mtp.EQ.6) THEN
          CALL tevalprune(wh,knt,n1,n2,nkn,ntr,conc,term,negs,
     #                        datri,storage,nwkv,wkv)
        END IF

        DO j=1,ntr
          DO k=1,n1
            prtr(k,j)=storage(k+n1*(j-1)*nkn)
          END DO
        END DO

      END 

      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine evaluates the tree that has been started
      ! name in slogic.f: evaluate_firstknot

      SUBROUTINE tevalfirstknot(wh,n1,n2,nkn,ntr,term,negs,
     #                              datri,storage,nwkv,wkv)
      IMPLICIT NONE

        ! arguments in
          INTEGER n1,n2,nkn,ntr,wh,negs(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
          INTEGER datri(n2,n1)
        ! local
          INTEGER j,iterm,pp
        ! arguments out
          INTEGER nwkv,wkv(nkn)
          INTEGER storage(2*ntr*nkn*n1)

      ! wkv stands for "Which Knots Visited" (used in restoring routine)
        nwkv=0
        DO j=1,nkn
          wkv(j)=0
        END DO

      ! store predictor in first knot
        iterm=term(1,wh,1)
        pp=(wh-1)*nkn*n1
        IF (negs(1,wh,1).EQ.0) THEN
          DO j=1,n1
            storage(j+pp)=datri(iterm,j)
          END DO
        ELSE 
          DO j=1,n1
            storage(j+pp)=1-datri(iterm,j)
          END DO
        END IF
        nwkv=nwkv+1
        wkv(nwkv)=1

      END

      ! *****************************************************************
      ! *****************************************************************



      ! this subroutine evaluates the tree after a leaf was changed
      ! name in slogic.f: evaluate_altlf

      SUBROUTINE tevalaltlf(wh,knt,n1,n2,nkn,ntr,conc,term,negs,
     #                          datri,storage,nwkv,wkv)
      IMPLICIT NONE

        ! arguments in
          INTEGER knt,n1,n2,nkn,ntr,wh
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
          INTEGER datri(n2,n1)
        ! local
          INTEGER j,knac,iterm,knac2,pp,pp2,pp2b
        ! arguments out
          INTEGER nwkv,wkv(nkn)
          INTEGER storage(2*ntr*nkn*n1)

      ! wkv stands for "Which Knots Visited" (used in restoring routine)
        nwkv=0
        DO j=1,nkn
          wkv(j)=0
        END DO

      ! store predictor in knt
        knac=knt
        iterm=term(knac,wh,1)
        pp=(wh-1)*nkn*n1+(knac-1)*n1
        IF (negs(knac,wh,1).EQ.0) THEN
          DO j=1,n1
            storage(pp+j)=datri(iterm,j)
          END DO
        ELSE 
          DO j=1,n1
            storage(pp+j)=1-datri(iterm,j)
          END DO
        END IF
        nwkv=nwkv+1
        wkv(nwkv)=knac
        knac=INT(REAL(knac)/2.0)

      ! calculate predictions in storage
        DO WHILE (knac.GT.0)
          knac2=2*knac
          pp=(wh-1)*nkn*n1+(knac-1)*n1
          pp2=(wh-1)*nkn*n1+(knac2-1)*n1
          pp2b=(wh-1)*nkn*n1+(knac2)*n1
          IF (conc(knac,wh,1).EQ.1) THEN
            DO j=1,n1
              storage(pp+j)=storage(pp2+j)*storage(pp2b+j)
            END DO
          ELSE  
            DO j=1,n1
              storage(pp+j)=1-(1-storage(pp2+j))*(1-storage(pp2b+j))
            END DO
          END IF
          nwkv=nwkv+1
          wkv(nwkv)=knac
          knac=INT(REAL(knac)/2.0)
        ENDDO

      END

      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine evaluates the tree after an operator was changed
      ! name in slogic.f: evaluate_altop

      SUBROUTINE tevalaltop(wh,knt,n1,nkn,ntr,conc,
     #                          storage,nwkv,wkv)
      IMPLICIT NONE

        ! arguments in
          INTEGER knt,n1,nkn,ntr,wh
          INTEGER conc(nkn,ntr,3)
        ! local
          INTEGER j,knac,knac2,pp,pp2,pp2b
        ! arguments out
          INTEGER nwkv,wkv(nkn)
          INTEGER storage(2*ntr*nkn*n1)

      ! wkv stands for "Which Knots Visited" (used in restoring routine)
        nwkv=0
        DO j=1,nkn
          wkv(j)=0
        END DO

      ! calculate predictions in storage
        knac=knt
        DO WHILE (knac.GT.0)
          knac2=2*knac
          pp=(wh-1)*nkn*n1+(knac-1)*n1
          pp2=(wh-1)*nkn*n1+(knac2-1)*n1
          pp2b=(wh-1)*nkn*n1+(knac2)*n1
          IF (conc(knac,wh,1).EQ.1) THEN
            DO j=1,n1
              storage(pp+j)=storage(pp2+j)*storage(pp2b+j)
            END DO
          ELSE  
            DO j=1,n1
              storage(pp+j)=1-(1-storage(pp2+j))*(1-storage(pp2b+j))
            END DO
          END IF
          nwkv=nwkv+1
          wkv(nwkv)=knac
          knac=INT(REAL(knac)/2.0)
        ENDDO

      END

      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine evaluates the tree after a leaf was deleted
      ! name in slogic.f: evaluate_delete

      SUBROUTINE tevaldelete(wh,knt,n1,nkn,ntr,conc,
     #                           storage,nwkv,wkv)
      IMPLICIT NONE

        ! arguments in
          INTEGER knt,n1,nkn,ntr,wh
          INTEGER conc(nkn,ntr,3)
        ! local
          INTEGER j,knac,sibling,knac2,pp,pp2,pp2b
        ! arguments out
          INTEGER nwkv,wkv(nkn)
          INTEGER storage(2*ntr*nkn*n1)

      ! wkv stands for "Which Knots Visited" (used in restoring routine)
        nwkv=0
        DO j=1,nkn
          wkv(j)=0
        END DO

      ! calculate predictions in storage
        IF (knt.EQ.1) THEN
          pp=(wh-1)*nkn*n1
          DO j=1,n1
            storage(pp+j)=0
          END DO
          nwkv=1
          wkv(nwkv)=1
        ELSE 
          knac=INT(REAL(knt)/2.0)
          IF (MOD(knt,2).EQ.0) THEN
            sibling=knt+1
          ELSE
            sibling=knt-1
          END IF
          pp=(wh-1)*nkn*n1+(knac-1)*n1
          pp2=(wh-1)*nkn*n1+(sibling-1)*n1
          DO j=1,n1
            storage(pp+j)=storage(pp2+j)
          END DO
          nwkv=nwkv+1
          wkv(nwkv)=knac
          IF (knac.GT.1) THEN
            knac=INT(REAL(knac)/2.0)
            DO WHILE (knac.GT.0)
              knac2=2*knac
              pp=(wh-1)*nkn*n1+(knac-1)*n1
              pp2=(wh-1)*nkn*n1+(knac2-1)*n1
              pp2b=(wh-1)*nkn*n1+(knac2)*n1
              IF (conc(knac,wh,1).EQ.1) THEN
                DO j=1,n1
                  storage(pp+j)=storage(pp2+j)*storage(pp2b+j)
                END DO
              ELSE  
                DO j=1,n1
                  storage(pp+j)=1-(1-storage(pp2+j))*(1-storage(pp2b+j))
                END DO
              END IF
              nwkv=nwkv+1
              wkv(nwkv)=knac
              knac=INT(REAL(knac)/2.0)
            ENDDO
          ENDIF 
        ENDIF

      END 

      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine evaluates the tree after a leaf was split
      ! name in slogic.f: evaluate_split

      SUBROUTINE tevalsplit(wh,knt,n1,n2,nkn,ntr,conc,term,negs,
     #                          datri,storage,nwkv,wkv)
      IMPLICIT NONE

        ! arguments in
          INTEGER knt,n1,n2,nkn,ntr,wh
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
          INTEGER datri(n2,n1)
        ! local
          INTEGER j,knac,iterm,knac2,pp,pp2,pp2b
        ! arguments out
          INTEGER nwkv,wkv(nkn)
          INTEGER storage(2*ntr*nkn*n1)

      ! wkv stands for "Which Knots Visited" (used in restoring routine)
        nwkv=0
        DO j=1,nkn
          wkv(j)=0
        END DO

      ! store predictor in 2*knt and 2*knt+1
        knac=2*knt
        iterm=term(knac,wh,1)
        pp=(wh-1)*nkn*n1+(knac-1)*n1
        IF (negs(knac,wh,1).EQ.0) THEN
          DO j=1,n1
            storage(pp+j)=datri(iterm,j)
          END DO
        ELSE 
          DO j=1,n1
            storage(pp+j)=1-datri(iterm,j)
          END DO
        END IF
        nwkv=nwkv+1
        wkv(nwkv)=knac
        iterm=term(knac+1,wh,1)
        pp=(wh-1)*nkn*n1+knac*n1
        IF (negs(knac+1,wh,1).EQ.0) THEN
          DO j=1,n1
            storage(pp+j)=datri(iterm,j)
          END DO
        ELSE 
          DO j=1,n1
            storage(pp+j)=1-datri(iterm,j)
          END DO
        END IF
        nwkv=nwkv+1
        wkv(nwkv)=knac+1
        knac=INT(REAL(knac)/2.0)

      ! calculate predictions in storage
        DO WHILE (knac.GT.0)
          knac2=2*knac
          pp=(wh-1)*nkn*n1+(knac-1)*n1
          pp2=(wh-1)*nkn*n1+(knac2-1)*n1
          pp2b=(wh-1)*nkn*n1+(knac2)*n1
          IF (conc(knac,wh,1).EQ.1) THEN
            DO j=1,n1
              storage(pp+j)=storage(pp2+j)*storage(pp2b+j)
            END DO
          ELSE  
            DO j=1,n1
              storage(pp+j)=1-(1-storage(pp2+j))*(1-storage(pp2b+j))
            END DO
          END IF
          nwkv=nwkv+1
          wkv(nwkv)=knac
          knac=INT(REAL(knac)/2.0)
        ENDDO

      END

      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine evaluates the tree after a leaf was split
      ! Name in slogic.f: evaluate_branch

      SUBROUTINE tevalbranch(wh,knt,n1,n2,nkn,ntr,conc,term,negs,
     #                           datri,storage,nwkv,wkv)
      IMPLICIT NONE

        ! arguments in
          INTEGER knt,n1,n2,nkn,ntr,wh
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
          INTEGER datri(n2,n1)
        ! local
          INTEGER j,knac,iterm,knac2,pp,pp2,pp2b
        ! arguments out
          INTEGER nwkv,wkv(nkn)
          INTEGER storage(2*ntr*nkn*n1)

      ! wkv stands for "Which Knots Visited" (used in restoring routine)
        nwkv=0
        DO j=1,nkn
          wkv(j)=0
        END DO

      ! store predictor in 4*knt and 4*knt+1 and 2*knt
        knac=2*knt+1
        iterm=term(knac,wh,1)
        pp=(wh-1)*nkn*n1+(knac-1)*n1
        IF (negs(knac,wh,1).EQ.0) THEN
          DO j=1,n1
            storage(pp+j)=datri(iterm,j)
          END DO
        ELSE 
          DO j=1,n1
            storage(pp+j)=1-datri(iterm,j)
          END DO
        END IF
        nwkv=nwkv+1
        wkv(nwkv)=knac
        knac=4*knt+1
        iterm=term(knac,wh,1)
        pp=(wh-1)*nkn*n1+(knac-1)*n1
        IF (negs(knac,wh,1).EQ.0) THEN
          DO j=1,n1
            storage(pp+j)=datri(iterm,j)
          END DO
        ELSE 
          DO j=1,n1
            storage(pp+j)=1-datri(iterm,j)
          END DO
        END IF
        nwkv=nwkv+1
        wkv(nwkv)=knac
        knac=4*knt
        iterm=term(knac,wh,1)
        pp=(wh-1)*nkn*n1+(knac-1)*n1
        IF (negs(knac,wh,1).EQ.0) THEN
          DO j=1,n1
            storage(pp+j)=datri(iterm,j)
          END DO
        ELSE 
          DO j=1,n1
            storage(pp+j)=1-datri(iterm,j)
          END DO
        END IF
        nwkv=nwkv+1
        wkv(nwkv)=knac
        knac=INT(REAL(knac)/2.0)

      ! calculate predictions in storage
        DO WHILE (knac.GT.0)
          knac2=2*knac
          pp=(wh-1)*nkn*n1+(knac-1)*n1
          pp2=(wh-1)*nkn*n1+(knac2-1)*n1
          pp2b=(wh-1)*nkn*n1+(knac2)*n1
          IF (conc(knac,wh,1).EQ.1) THEN
            DO j=1,n1
              storage(pp+j)=storage(pp2+j)*storage(pp2b+j)
            END DO
          ELSE  
            DO j=1,n1
              storage(pp+j)=1-(1-storage(pp2+j))*(1-storage(pp2b+j))
            END DO
          END IF
          nwkv=nwkv+1
          wkv(nwkv)=knac
          knac=INT(REAL(knac)/2.0)
        ENDDO

      END 

      ! *****************************************************************
      ! *****************************************************************



      ! this subroutine evaluates the tree after a leaf was split
      ! Name in slogic.f: evaluate_prune

      SUBROUTINE tevalprune(wh,knt,n1,n2,nkn,ntr,conc,term,negs,
     #                          datri,storage,nwkv,wkv)
      IMPLICIT NONE

        ! arguments in
          INTEGER knt,n1,n2,nkn,ntr,wh
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
          INTEGER datri(n2,n1)
        ! local
          INTEGER j,knac,iterm,knac2,pp,pp2,pp2b
        ! arguments out
          INTEGER nwkv,wkv(nkn)
          INTEGER storage(2*ntr*nkn*n1)

      ! wkv stands for "Which Knots Visited" (used in restoring routine)
        nwkv=0
        DO j=1,nkn
          wkv(j)=0
        END DO

      ! store predictor in 4*knt and 4*knt+1 and 2*knt
        knac=2*knt
        iterm=term(knac,wh,1)
        pp=(wh-1)*nkn*n1+(knac-1)*n1
        IF (negs(knac,wh,1).EQ.0) THEN
          DO j=1,n1
            storage(pp+j)=datri(iterm,j)
          END DO
        ELSE 
          DO j=1,n1
            storage(pp+j)=1-datri(iterm,j)
          END DO
        END IF
        nwkv=nwkv+1
        wkv(nwkv)=knac
        knac=2*knt+1
        iterm=term(knac,wh,1)
        pp=(wh-1)*nkn*n1+(knac-1)*n1
        IF (negs(knac,wh,1).EQ.0) THEN
          DO j=1,n1
            storage(pp+j)=datri(iterm,j)
          END DO
        ELSE 
          DO j=1,n1
            storage(pp+j)=1-datri(iterm,j)
          END DO
        END IF
        nwkv=nwkv+1
        wkv(nwkv)=knac
        knac=INT(REAL(knac)/2.0)

      ! calculate predictions in storage
        DO WHILE (knac.GT.0)
          knac2=2*knac
          pp=(wh-1)*nkn*n1+(knac-1)*n1
          pp2=(wh-1)*nkn*n1+(knac2-1)*n1
          pp2b=(wh-1)*nkn*n1+(knac2)*n1
          IF (conc(knac,wh,1).EQ.1) THEN
            DO j=1,n1
              storage(pp+j)=storage(pp2+j)*storage(pp2b+j)
            END DO
          ELSE  
            DO j=1,n1
              storage(pp+j)=1-(1-storage(pp2+j))*(1-storage(pp2b+j))
            END DO
          END IF
          nwkv=nwkv+1
          wkv(nwkv)=knac
          knac=INT(REAL(knac)/2.0)
        ENDDO

      END

      ! *****************************************************************
      ! *****************************************************************


      ! this subroutine initializes the variables needed in logic
      ! regression
      ! name in slogic.f: initialize

      SUBROUTINE tinit(n1,ntr,nkn,conc,term,negs,pick,storage,
     #                      score)
      IMPLICIT NONE

        ! arguments in
        INTEGER n1,ntr,nkn
        ! local
        INTEGER i,j,k,l,i2
        ! arguments out
        INTEGER conc(nkn,ntr,3)
        INTEGER negs(nkn,ntr,3)
        INTEGER pick(nkn,ntr,3)
        INTEGER term(nkn,ntr,3)
        INTEGER storage(2*ntr*nkn*n1)
        REAL score(3)

        ! tree specifications
        DO i=1,nkn
          DO j=1,ntr
            DO k=1,3
              conc(i,j,k)=0
              term(i,j,k)=0
              negs(i,j,k)=0
              pick(i,j,k)=0
            END DO
          END DO
        END DO

        ! stored values to compute the predictions of the trees
          DO j=1,ntr
            DO k=1,nkn
              i=n1*(k-1)+n1*nkn*(j-1)
              i2=n1*(k-1)+n1*nkn*(j-1)+ntr*n1*nkn
              DO l=1,n1
                storage(l+i)=0
                storage(l+i2)=0
             END DO
            END DO
          END DO

        ! others
        DO i=1,3
          score(i)=100000000.0
        ENDDO

      END

      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine reads the selection probabilities/relations
      ! name in slogic.f: selprob

      SUBROUTINE tselectprob(nsp,cnc,slprbc)
      IMPLICIT NONE

        ! arguments in
          INTEGER nsp,cnc(3)
        ! local
          INTEGER j,k
          REAL denom,slprb(25)  
        ! arguments out
          REAL slprbc(25)

        slprb(1)=10
        slprb(2)=1
        slprb(3)=3
        slprb(4)=3
        slprb(5)=3
        slprb(6)=3

      ! correct for one operator only
        IF (cnc(2).EQ.1.OR.cnc(1).EQ.2) THEN
          slprb(2)=0.0
        END IF

      ! compute cumulative selection probabilities
        denom=0.0        
        DO j=1,nsp
          denom=denom+slprb(j)
        END DO
        DO j=1,nsp
          slprbc(j)=0
        END DO
        DO j=1,nsp
          DO k=1,j
            slprbc(j)=slprbc(j)+slprb(k)
          END DO
        END DO
        DO j=1,nsp
          slprb(j)=slprb(j)/denom
          slprbc(j)=slprbc(j)/denom
        END DO
        GOTO 2000
 2000   CONTINUE

      END 

      ! *****************************************************************
      ! *****************************************************************

      ! Name in slogic.f: slogreg

      SUBROUTINE tlogreg(n1,n2,nsep,intpars,rpars,seps,dcph,orders,resp,
     #                   weight,datri,iotrees,iocoef,ioscores,rd4)

      INTEGER LGCnknMAX,LGCntrMAX
      PARAMETER (LGCnknMAX  =   128)
      PARAMETER (LGCntrMAX  =     5)
      INTEGER n1,n2,nsep,cnc(3),mdl,msz,nkn,ehm,mszlo,mszup
      INTEGER ntrlo,ntrup,seed,kfold,nrep,choice,nfcnt,mtm
      INTEGER intpars(17),dcph(n1),orders(n1),datri(n2,n1)
      INTEGER iotrees(1),bout
      REAL seps(nsep,n1),resp(n1),weight(n1),rpars(14),tstr,tend,tint
      REAL penalty,iocoef(1),ioscores(1),hyperpars(10)
      INTEGER conc(LGCnknMAX,LGCntrMAX,3),rd4(1)
      INTEGER negs(LGCnknMAX,LGCntrMAX,3),i,j,k
      INTEGER pick(LGCnknMAX,LGCntrMAX,3)
      INTEGER term(LGCnknMAX,LGCntrMAX,3)

      DO i=1,LGCnknMAX
         DO j=1,LGCntrMAX
            DO k=1,3
               conc(i,j,k)=0
               negs(i,j,k)=0
               pick(i,j,k)=0
               term(i,j,k)=0
            END DO
         END DO
      END DO
      mdl=intpars(1)
      msz=intpars(2)
      mszlo=intpars(2)
      mszup=intpars(3)
      ntr=intpars(6)
      nkn=intpars(4)
      if(msz.LT.0) msz=ntr*nkn
      nkn=2*nkn-1
      ntrlo=intpars(5)
      ntrup=intpars(6)
      IF (intpars(7).EQ.2) THEN
          cnc(1)=1
          cnc(2)=1
        ELSE IF (intpars(7).EQ.3) THEN
          cnc(1)=2
          cnc(2)=2
        ELSE
          cnc(1)=1
          cnc(2)=2
        END IF

      tstr=rpars(1)
      tend=rpars(2)
      tint=rpars(3)
      ehm=intpars(8)
      seed=intpars(9)
      kfold=intpars(10)
      nrep=intpars(10)
      choice=intpars(11)
      nfcnt=intpars(12)
      penalty=rpars(4)
      mtm=intpars(13)
      bout=0
      DO i=1,10
         hyperpars(i)=rpars(i+4)
      END DO
      IF(choice.EQ.7)THEN
         tstr=1.
         tend=1.
         tint=intpars(14)+intpars(15)
         nfcnt=intpars(14)
         bout=intpars(16)
      END IF
      CALL tlr(mdl,msz,n1,n2,nkn,ntr,cnc,nsep,tstr,tend,tint,ehm,
     #                  mszlo,mszup,ntrlo,ntrup,seed,kfold,nrep,
     #                  choice,nfcnt,penalty,mtm,seps,dcph,orders,
     #                  resp,weight,datri,iotrees,ltree,iocoef,
     #                  ioscores,conc,negs,pick,term,hyperpars,rd4,bout)
      intpars(1)=ltree
      END
      
      ! Name in slogic.f: logreg

      SUBROUTINE tlr(mdl,msz,n1,n2,nkn,ntr,cnc,nsep,tstr,tend,tint,
     #                  ehm,mszlo,mszup,ntrlo,ntrup,seed,kfold,
     #                  nrep,choice,nfcnt,penalty,mtm,seps,dcph,
     #                  ordrs,resp,weight,datri,iotree,iosclast,iocoef,
     #                  ioscores,conc,negs,pick,term,hyperpars,rd4,
     #                  bout)
      IMPLICIT NONE
        
        ! parameters to be determined by the user
        ! INTEGER n1    number of subjects
        ! INTEGER n2    number of predictors
        ! INTEGER mdl   model type under consideration
        ! INTEGER ntr   number of trees
        ! INTEGER nkn   number of knots
        ! INTEGER msz   maximal size of model
        ! INTEGER nsep  how many separate predictors

        ! how many selection probabilities/relations:
  
        ! parameters
          INTEGER LGCn1MAX,LGCnknMAX,LGCntrMAX,ltree,iotree(1)
          INTEGER LGCbetaMAX
          PARAMETER (LGCn1MAX   = 20000)
          PARAMETER (LGCnknMAX  =   128)
          PARAMETER (LGCntrMAX  =     5)
          PARAMETER (LGCbetaMAX =    55)

          INTEGER i,j,ssize,ehm,seed,nfcnt,error,nsp,k,rd4(1),bout
          INTEGER choice,kfold,mdl,msz,n1,n2,nkn,nsep,ntr
          INTEGER ntrnew,mszlo,mszup,nrep,ntrlo,ntrup
          INTEGER cnc(3),mtm
          INTEGER dcph(n1),ordrs(n1)
          INTEGER conc(nkn,ntrup,3)
          INTEGER negs(nkn,ntrup,3)
          INTEGER pick(nkn,ntrup,3)
          INTEGER term(nkn,ntrup,3)
          INTEGER storage(2*LGCntrMAX*LGCnknMAX*LGCn1MAX)
          INTEGER*4 sseed(3)
          REAL tstr,tend,tint,score(3),slprbc(25),penalty,hyperpars(10)
          REAL weight(n1),betas(3,0:LGCbetaMAX),resp(n1),iocoef(1)
          INTEGER datri(n2,n1),mcmc
          REAL seps(nsep,n1),rnumsrr(LGCn1MAX),ioscores(n1),ourrand
          INTEGER mszmax,iolast,iosclast
          INTEGER prtr(LGCn1MAX,LGCntrMAX)
          REAL cbetas(0:LGCbetaMAX),xtxsep(LGCbetaMAX+1,LGCbetaMAX+1)
          INTEGER npckmv(6,LGCntrMAX)
          INTEGER pickmv(6,LGCnknMAX,LGCntrMAX)
          CHARACTER *100 astring
          
        ! betas: the parameter estimates in the model - current/stored/best
        ! choice: which type of logic regression
        ! cnc: specifies which operators will be considered
        ! conc: operators in the logic trees
        ! datr: data stored as reals
        ! dcph: indicator for censoring (mdl=4 only)
        ! ehm: every how many iterations you get a score update
        ! kfold: k in k-fold cross validation
        ! negs: indicator (complement 0/1) in the logic trees
        ! nrep: number of permutations in the randomization test
        ! ordrs: order of responses (mdl=4 only)
        ! pick: indicator (taken 0/1) in the logic trees
        ! score: scores of current/stored/best model,resp(LGCn1MAX)
        ! seps: separate variables to condition on
        ! ssize: size of the current model
        ! slprbc: cumulative selection probabilities
        ! storage: array that stores the values in the knots of the 
        !   logic trees
        ! term: predictors in the logic trees
        ! weight: case weights
        ! nfcnt: number of iterations after which to check whether there
        !        are 10 changes
        ! penalty: penalty parameter for model size
        iolast=0
        iosclast=0
        ltree=0
        mcmc=0
        DO i=1,3
          DO j=0,LGCbetaMAX
             betas(i,j)=0.
          END DO
        END DO
      ! read in data, weights, selection probabilities, etc
        DO i=1,LGCn1MAX
           DO j=1,LGCntrMAX
              prtr(i,j)=0
           END DO
        END DO
        error=0
        nsp=6
        CALL tselectprob(nsp,cnc,slprbc)

      ! set random seed
        
        IF(seed.NE.0)THEN
          sseed(1)=seed
          IF(sseed(1).LT.0)THEN
             sseed(1)= -seed
          END IF
          i=ourrand(sseed(1))
        ELSE
          i=ourrand(1773)
        END IF

      ! find the single best model -----------------------------------
        IF (choice.EQ.1) THEN
          ltree=ntr
          CALL tanneal(n1,n2,mdl,nkn,ntr,conc,negs,pick,term,
     #                   storage,slprbc,datri,weight,tstr,tend,tint,ehm,
     #                   msz,nsep,seps,cnc,score,betas,ssize,dcph,ordrs,
     #                   nfcnt,penalty,resp,mtm,mcmc,hyperpars,iotree,
     #                   iocoef,ioscores,rd4,bout)
          DO j=0,(nsep+ntr)
             iolast=iolast+1
             iocoef(iolast)=betas(3,j)
          END DO
          DO j=1,ntr
            iotree((j-1)*(4*nkn+3)+1)=msz
            iotree((j-1)*(4*nkn+3)+2)=ntr
            iotree((j-1)*(4*nkn+3)+3)=j
            DO k=1,nkn
              iotree((j-1)*(4*nkn+3)+(k-1)*4+4)=conc(k,j,3)
              iotree((j-1)*(4*nkn+3)+(k-1)*4+5)=term(k,j,3)
              iotree((j-1)*(4*nkn+3)+(k-1)*4+6)=negs(k,j,3)
              iotree((j-1)*(4*nkn+3)+(k-1)*4+7)=pick(k,j,3)
            END DO
          END DO
          ioscores(1)=score(3)

      ! MCMC -----------------------------------
        ELSE IF (choice.EQ.7) THEN
          mcmc=1
          ltree=ntr
          CALL tanneal(n1,n2,mdl,nkn,ntr,conc,negs,pick,term,
     #                   storage,slprbc,datri,weight,tstr,tend,tint,ehm,
     #                   msz,nsep,seps,cnc,score,betas,ssize,dcph,ordrs,
     #                   nfcnt,penalty,resp,mtm,mcmc,hyperpars,iotree,
     #                   iocoef,ioscores,rd4,bout)

      ! find multiple models -----------------------------------------
        ELSE IF (choice.EQ.6) THEN
          iolast=0
          iosclast=0
          ntr=ntrup
          DO msz=0,mszup
            IF(msz.eq.0)THEN
              CALL tsainit(n1,n2,mdl,nkn,ntr,conc,negs,pick,term,
     #        storage,datri,resp,weight,npckmv,pickmv,
     #        score,betas,ssize,nsep,seps,ntrnew,dcph,ordrs,penalty,
     #        prtr,cbetas,xtxsep,mtm,mcmc,hyperpars)
            ELSE
              CALL tgreedy1step(nkn,ntr,conc,negs,pick,term,n1,n2,
     #        storage,prtr,datri,nsep,seps,cbetas,xtxsep,mdl,
     #        ntrnew,ordrs,dcph,resp,weight,score(1),mtm,cnc,
     #        penalty)
              IF(ntr.LT.0)THEN
                GOTO 6677
              END IF
            END IF
            DO j=0,(nsep+ntrnew)
              iolast=iolast+1
              iocoef(iolast)=cbetas(j)
            END DO
            DO j=(ntrnew+1),ntr
              iolast=iolast+1
              iocoef(iolast)=0.
            END DO
            DO j=1,ntrnew
              ltree=ltree+1
              iotree((ltree-1)*(4*nkn+3)+1)=msz
              iotree((ltree-1)*(4*nkn+3)+2)=ntr
              iotree((ltree-1)*(4*nkn+3)+3)=j
              DO k=1,nkn
                CALL teorder(iotree,conc,term,negs,pick,ltree,k,j,
     #                         nkn,ntrlo)
              END DO
            END DO
            DO j=(ntrnew+1),ntr
              ltree=ltree+1
              iotree((ltree-1)*(4*nkn+3)+1)=msz
              iotree((ltree-1)*(4*nkn+3)+2)=ntr
              iotree((ltree-1)*(4*nkn+3)+3)=j
              DO k=1,nkn
                iotree((ltree-1)*(4*nkn+3)+(k-1)*4+4)=0
                iotree((ltree-1)*(4*nkn+3)+(k-1)*4+5)=0
                iotree((ltree-1)*(4*nkn+3)+(k-1)*4+6)=0
                iotree((ltree-1)*(4*nkn+3)+(k-1)*4+7)=0
              END DO
            END DO
            iosclast=iosclast+1
            ioscores(iosclast)=score(1)
          END DO
6677      CONTINUE

      ! find multiple models -----------------------------------------
        ELSE IF (choice.EQ.2) THEN
          ltree=0
          DO ntr=ntrlo,ntrup
            DO msz=mszlo,mszup
                ntrnew=MIN(ntr,msz)
                CALL tanneal(n1,n2,mdl,nkn,ntrnew,
     #                       conc,negs,pick,term,
     #                       storage,slprbc,datri,weight,tstr,tend,tint,
     #                       ehm,msz,nsep,seps,cnc,score,betas,ssize,
     #                       dcph,ordrs,nfcnt,penalty,resp,mtm,
     #                       mcmc,hyperpars,iotree,
     #                       iocoef,ioscores,rd4,bout)

                DO j=0,(nsep+ntrnew)
                   iolast=iolast+1
                   iocoef(iolast)=betas(3,j)
                END DO
                DO j=(ntrnew+1),ntr
                   iolast=iolast+1
                   iocoef(iolast)=0.
                END DO
                DO j=1,ntrnew
                  ltree=ltree+1
                  iotree((ltree-1)*(4*nkn+3)+1)=msz
                  iotree((ltree-1)*(4*nkn+3)+2)=ntr
                  iotree((ltree-1)*(4*nkn+3)+3)=j
                  DO k=1,nkn
                    CALL teorder(iotree,conc,term,negs,pick,ltree,k,j,
     #                           nkn,ntrnew)
                  END DO
                END DO
                DO j=(ntrnew+1),ntr
                  ltree=ltree+1
                  iotree((ltree-1)*(4*nkn+3)+1)=msz
                  iotree((ltree-1)*(4*nkn+3)+2)=ntr
                  iotree((ltree-1)*(4*nkn+3)+3)=j
                  DO k=1,nkn
                    iotree((ltree-1)*(4*nkn+3)+(k-1)*4+4)=0
                    iotree((ltree-1)*(4*nkn+3)+(k-1)*4+5)=0
                    iotree((ltree-1)*(4*nkn+3)+(k-1)*4+6)=0
                    iotree((ltree-1)*(4*nkn+3)+(k-1)*4+7)=0
                  END DO
                END DO
                iosclast=iosclast+1
                ioscores(iosclast)=score(3)
            END DO
          END DO
        END IF

      END 

      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine selects a move for a given tree
      ! name in slogic.f: moving

      SUBROUTINE tmove(n2,nkn,ntr,conc,negs,pick,term,slprbc,cnc,
     #                mcmc,npckmv,pickmv,msz,ssize,nop,wh,knt,mtp,mctry)
      IMPLICIT NONE

        ! arguments in
          INTEGER n2,msz,nkn,ntr,nop,ssize,cnc(3),npckmv(6,ntr)
          INTEGER pickmv(6,nkn,ntr),mcmc,mctry
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER pick(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
          REAL slprbc(25)
        ! local
          REAL rnum,ourrand
          INTEGER i,j,mtpx,whx
        ! arguments out
          INTEGER knt,mtp,wh

      ! randomly select tree 
 1000   CONTINUE
        CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,-1,2,1)
        rnum=ourrand(0)
        IF(mctry.GT.0)THEN
          IF(mtp.NE.0)THEN
            DO j=0,(nop)
              DO i=1,2
                IF(i+j.GT.1)THEN
                  whx=wh+j
                  IF(whx.GT.nop)whx=whx-nop
                  mtpx=mtp
                  IF(mtp.LT.3.and.i.EQ.2)mtpx=3-mtp
                  IF(mtp.GE.3.and.i.EQ.2)mtpx=9-mtp
                  IF(npckmv(mtpx,whx).GT.0)THEN
                    mtp=mtpx
                    wh=whx
                    CALL tdecision(n2,nkn,ntr,wh,conc,negs,pick,
     #              term,slprbc,cnc,npckmv,pickmv,msz,ssize,
     #              knt,mtp,mcmc,mctry)
                    GOTO 169
                  END IF
                END IF
              END DO
            END DO
          ELSE
            CALL tstartknot(n2,nkn,ntr,wh,conc,negs,pick,term,-1,-1)
            knt=0
            mtp=0
            GOTO 169
          END IF
        END IF
        mtp=-1
        mctry=0
      ! wh=INT(REAL(MIN(ntr,nop+1))*rnum)+1
        wh=INT(REAL(ntr)*rnum)+1
        IF(wh.GT.nop+1)wh=nop+1
        IF (pick(1,wh,1).EQ.0) THEN
          IF (ssize.EQ.msz) GOTO 1000 
          IF(mcmc.GT.0)mcmc=2
          CALL tstartknot(n2,nkn,ntr,wh,conc,negs,pick,term,-1,-1)
          knt=0
          mtp=0
        ELSE
          CALL tdecision(n2,nkn,ntr,wh,conc,negs,pick,term,slprbc,
     #                  cnc,npckmv,pickmv,msz,ssize,
     #                  knt,mtp,mcmc,mctry)
        END IF
169     CONTINUE
      END 

      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine starts a new tree
      ! name in slogic.f: firstknot

      SUBROUTINE tstartknot(n2,nkn,ntr,wh,conc,negs,pick,term,r1,r2)
      IMPLICIT NONE

        ! arguments in
          INTEGER n2,nkn,ntr,wh,r1,r2
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER pick(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
        ! local
          INTEGER letter,neg
          REAL rnum,ourrand
        ! arguments out

      ! randomly select predictor
        IF(r1.LT.0)THEN
           rnum=ourrand(0)
           letter=INT(REAL(n2)*rnum)+1
           rnum=ourrand(0)
           neg=INT(2.0*rnum)
        ELSE
           letter=r1
           neg=r2
        END IF

        conc(1,wh,1)=3
        term(1,wh,1)=letter
        negs(1,wh,1)=neg
        pick(1,wh,1)=1

      END 

      ! *****************************************************************
      ! *****************************************************************



      ! this subroutine makes a decision which move to carry out
      ! name in slogic.f: decision

      SUBROUTINE tdecision(n2,nkn,ntr,wh,conc,negs,pick,term,slprbc,
     #                    cnc,npckmv,pickmv,msz,ssize,
     #                    knt,mtp,mcmc,mctry)
      IMPLICIT NONE

        ! arguments in
          INTEGER msz,n2,nkn,ntr,ssize,wh,cnc(3)
          INTEGER npckmv(6,ntr),pickmv(6,nkn,ntr)
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER pick(nkn,ntr,3)
          INTEGER term(nkn,ntr,3),mcmc
          REAL slprbc(25)
        ! local
          INTEGER sng,dbl,mctry
          REAL rnum,ourrand
        ! arguments out
          INTEGER knt,mtp,rnd1,rnd2,rnd3

      ! select move from selection scheme
        IF(mcmc.GT.0)mcmc=1
        IF(mcmc.GT.0)mcmc=mcmc+1
        IF(mcmc.EQ.0)mctry=0
 1000   CONTINUE
        rnum=ourrand(0)
        IF(mctry.GT.0)rnum=3.
        IF (rnum.LE.slprbc(1).OR.(mctry.GT.0.AND.mtp.EQ.1)) THEN
          rnum=ourrand(0)
          knt=pickmv(1,INT(REAL(npckmv(1,wh))*rnum)+1,wh)
          rnd1= -1
          CALL taltleaf(knt,n2,nkn,ntr,wh,negs,term,rnd1,rnd2)
          mtp=1
        ELSE IF (rnum.LT.slprbc(2).OR.(mctry.GT.0.AND.mtp.EQ.2)) THEN
          IF (npckmv(2,wh).EQ.0) GOTO 1000
          rnum=ourrand(0)
          knt=pickmv(2,INT(REAL(npckmv(2,wh))*rnum)+1,wh)
          CALL taltoper(knt,nkn,ntr,wh,conc)
          mtp=2
        ELSE IF (rnum.LT.slprbc(3).OR.(mctry.GT.0.AND.mtp.EQ.3)) THEN
          rnum=ourrand(0)
          IF (npckmv(3,wh).EQ.0) GOTO 1000
          knt=pickmv(3,INT(REAL(npckmv(3,wh))*rnum)+1,wh)
          CALL tdeleting(knt,nkn,ntr,wh,conc,negs,pick,term)
          mtp=3
        ELSE IF (rnum.LT.slprbc(4).OR.(mctry.GT.0.AND.mtp.EQ.4)) THEN
          IF (ssize.EQ.msz) GOTO 1000
          rnum=ourrand(0)
          IF (npckmv(4,wh).EQ.0) GOTO 1000
          knt=pickmv(4,INT(REAL(npckmv(4,wh))*rnum)+1,wh)
          rnd1= -1
          CALL tsplitting(knt,n2,nkn,ntr,wh,cnc,conc,negs,pick,term,
     #                rnd1,rnd2,rnd3)
          mtp=4
        ELSE IF (rnum.LT.slprbc(5).OR.(mctry.GT.0.AND.mtp.EQ.5)) THEN
          IF (ssize.EQ.msz) GOTO 1000
          rnum=ourrand(0)
          IF (npckmv(5,wh).EQ.0) GOTO 1000
          knt=pickmv(5,INT(REAL(npckmv(5,wh))*rnum)+1,wh)
          rnd1= -1
          CALL tbranching(knt,n2,nkn,ntr,wh,cnc,conc,negs,pick,term,
     #                rnd1,rnd2,rnd3)
          mtp=5
        ELSE IF (rnum.LE.slprbc(6).OR.(mctry.GT.0.AND.mtp.EQ.6)) THEN
          IF (npckmv(6,wh).EQ.0) GOTO 1000
          rnum=ourrand(0)
          knt=pickmv(6,INT(REAL(npckmv(6,wh))*rnum)+1,wh)
          IF(knt.GT.0)THEN
            sng=2*knt
            dbl=2*knt+1
          ELSE
            knt= -knt
            sng=2*knt+1
            dbl=2*knt
          END IF
          CALL tpruning(knt,dbl,sng,nkn,ntr,wh,conc,negs,pick,term)
          mtp=6
        ELSE
          CALL REXIT("This move is not defined!")
        END IF
      END 

      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine alternates a leaf
      ! name in slogic.f: altlf

      SUBROUTINE taltleaf(knt,n2,nkn,ntr,wh,negs,term,rnd1,rnd2)
      IMPLICIT NONE

        ! arguments in
          INTEGER knt,n2,nkn,ntr,wh,rnd1,rnd2
          INTEGER negs(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
        ! local
          INTEGER letter,neg
          REAL rnum,ourrand
        ! arguments out

      ! alternate leaf
 300    CONTINUE
        IF(rnd1.GT.0)THEN
          letter=rnd1
        ELSE
          rnum=ourrand(0)
          letter=INT(REAL(n2)*rnum)+1
        END IF
      ! avoid creating redundancies such as (X and X^c)
        IF (knt.GT.1) THEN
          IF (MOD(knt,2).EQ.0) THEN
            IF (letter.EQ.term(knt+1,wh,1)) THEN
              IF(rnd1.GT.0)GOTO 388
              GOTO 300
            END IF
          ELSE
            IF (letter.EQ.term(knt-1,wh,1)) THEN
              IF(rnd1.GT.0)THEN
                 rnd1=-1
                 GOTO 388
              END IF
              GOTO 300
            END IF
          ENDIF
        END IF
        IF(rnd1.GT.0)THEN
          neg=rnd2
        ELSE
          rnum=ourrand(0)
          neg=INT(2.0*rnum)
        END IF
        term(knt,wh,1)=letter         
        negs(knt,wh,1)=neg
388     CONTINUE
      END 

      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine alternates an operator
      ! name in slogic.f: altop

      SUBROUTINE taltoper(knt,nkn,ntr,wh,conc)
      IMPLICIT NONE

        ! arguments in
          INTEGER knt,nkn,ntr,wh
          INTEGER conc(nkn,ntr,3)
        ! arguments out

      ! exchange operator
        conc(knt,wh,1)=3-conc(knt,wh,1)       

      END 

      ! *****************************************************************
      ! *****************************************************************



      ! this subroutine deletes a leaf
      ! name in slogic.R: xdelete

      SUBROUTINE tdeleting(knt,nkn,ntr,wh,conc,negs,pick,term)
      IMPLICIT NONE

        ! arguments in
          INTEGER knt,nkn,ntr,wh
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER pick(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
        ! local
          INTEGER head,sibling,token
        ! arguments out

      ! delete the leaf 
        IF (knt.EQ.1) THEN
          conc(knt,wh,1)=0
          term(knt,wh,1)=0
          negs(knt,wh,1)=0
          pick(knt,wh,1)=0
        ELSE
          head=INT(knt/2)
          IF (MOD(knt,2).EQ.0) THEN
            sibling=knt+1
          ELSE
            sibling=knt-1
          END IF
          conc(head,wh,1)=conc(sibling,wh,1)
          term(head,wh,1)=term(sibling,wh,1)
          negs(head,wh,1)=negs(sibling,wh,1)
          token=knt
          conc(token,wh,1)=0
          term(token,wh,1)=0
          negs(token,wh,1)=0
          pick(token,wh,1)=0
          token=sibling
          conc(token,wh,1)=0
          term(token,wh,1)=0
          negs(token,wh,1)=0
          pick(token,wh,1)=0 
        END IF

      END 

      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine splits a leaf
      ! name in slogic.f: xsplit

      SUBROUTINE tsplitting(knt,n2,nkn,ntr,wh,cnc,conc,negs,pick,term,
     #                  r1,r2,r3)
      IMPLICIT NONE


        ! arguments in
          INTEGER knt,n2,nkn,ntr,wh,r1,r2,r3
          INTEGER cnc(3)
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER pick(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
        ! local
          INTEGER letter,neg
          REAL rnum,ourrand
        ! arguments out

      ! move leaf and create operator
        conc(2*knt,wh,1)=3
        term(2*knt,wh,1)=term(knt,wh,1)
        negs(2*knt,wh,1)=negs(knt,wh,1)
        pick(2*knt,wh,1)=1
        term(knt,wh,1)=0
        negs(knt,wh,1)=0        
      ! create the new leaf 
        IF(r1.GE.0)THEN
          conc(knt,wh,1)=cnc(r2)
          letter=r1
          IF (letter.EQ.term(2*knt,wh,1))THEN
            r1= -1
            GOTO 599
          END IF
          neg=r3
        ELSE
          rnum=ourrand(0)
          conc(knt,wh,1)=cnc(INT(2*rnum)+1)
 500      CONTINUE
          rnum=ourrand(0)
          letter=INT(n2*rnum)+1
          IF (letter.EQ.term(2*knt,wh,1)) GOTO 500
          rnum=ourrand(0)
          neg=INT(2*rnum)
        END IF
        conc(2*knt+1,wh,1)=3
        term(2*knt+1,wh,1)=letter
        negs(2*knt+1,wh,1)=neg
        pick(2*knt+1,wh,1)=1
599     CONTINUE
      END 

      ! *****************************************************************
      ! *****************************************************************


      ! this subroutine grows a branch
      ! name in slogic.f: branch

      SUBROUTINE tbranching(knt,n2,nkn,ntr,wh,cnc,conc,negs,pick,term,
     #                  r1,r2,r3)
      IMPLICIT NONE

        ! arguments in
          INTEGER knt,n2,nkn,ntr,wh,r1,r2,r3
          INTEGER cnc(3)
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER pick(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
        ! local
          INTEGER letter,neg,loc1,loc2
          REAL rnum,ourrand
        ! arguments out

      ! pass old substructure
        loc1=2*knt
        loc2=4*knt
        conc(loc2,wh,1)=3
        term(loc2,wh,1)=term(loc1,wh,1)
        negs(loc2,wh,1)=negs(loc1,wh,1)
        pick(loc2,wh,1)=1
        loc1=2*knt+1
        loc2=4*knt+1
        conc(loc2,wh,1)=3
        term(loc2,wh,1)=term(loc1,wh,1)
        negs(loc2,wh,1)=negs(loc1,wh,1)
        pick(loc2,wh,1)=1
        loc1=knt
        loc2=2*knt
        conc(loc2,wh,1)=conc(loc1,wh,1)
        term(loc2,wh,1)=term(loc1,wh,1)
        negs(loc2,wh,1)=0
      ! create the new leaf 
        conc(2*knt+1,wh,1)=3
        pick(2*knt+1,wh,1)=1
        term(knt,wh,1)=0
        negs(knt,wh,1)=0        
        IF(r1.LT.0)THEN
 500      CONTINUE
          rnum=ourrand(0)
          letter=INT(n2*rnum)+1
          IF (letter.EQ.term(4*knt,wh,1).OR.
     #      letter.EQ.term(4*knt+1,wh,1)) GOTO 500
          rnum=ourrand(0)
          neg=INT(2*rnum)
      ! create operator in knt
          rnum=ourrand(0)
          conc(knt,wh,1)=cnc(INT(2*rnum)+1)
        ELSE
          letter=r1
          IF (letter.EQ.term(4*knt,wh,1).OR.
     #      letter.EQ.term(4*knt+1,wh,1)) THEN
            r1 = -1
            GOTO 592
          END IF
          neg=r2
          conc(knt,wh,1)=cnc(r3)
        END IF
        term(2*knt+1,wh,1)=letter
        negs(2*knt+1,wh,1)=neg
592     CONTINUE
      END

      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine prunes a leaf
      ! name in slogic.f: prune

      SUBROUTINE tpruning(knt,dbl,sng,nkn,ntr,wh,conc,negs,pick,term)
      IMPLICIT NONE

        ! arguments in
          INTEGER knt,nkn,ntr,wh,dbl,sng,loc1,loc2
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER pick(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
        ! arguments out

      ! move operator 
        loc1=dbl
        loc2=knt
        conc(loc2,wh,1)=conc(loc1,wh,1)
        term(loc2,wh,1)=0
        negs(loc2,wh,1)=0
      ! move leaves
        loc1=2*dbl
        loc2=sng
        conc(loc2,wh,1)=conc(loc1,wh,1)
        term(loc2,wh,1)=term(loc1,wh,1)
        negs(loc2,wh,1)=negs(loc1,wh,1)
        pick(loc2,wh,1)=pick(loc1,wh,1)
        conc(loc1,wh,1)=0
        term(loc1,wh,1)=0
        negs(loc1,wh,1)=0
        pick(loc1,wh,1)=0
        loc1=2*dbl+1
        loc2=dbl
        conc(loc2,wh,1)=conc(loc1,wh,1)
        term(loc2,wh,1)=term(loc1,wh,1)
        negs(loc2,wh,1)=negs(loc1,wh,1)
        pick(loc2,wh,1)=pick(loc1,wh,1)
        conc(loc1,wh,1)=0
        term(loc1,wh,1)=0
        negs(loc1,wh,1)=0
        pick(loc1,wh,1)=0

      END 


      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine keeps track of the scores, trees etc.
      ! name in slogic.f: recording

      SUBROUTINE trecord(accept,wh,nkn,ntr,nsep,score,betas,
     #                     conc,negs,pick,term,mcmc)
      IMPLICIT NONE

        ! arguments in
          INTEGER accept,nkn,nsep,ntr,wh,mcmc
          INTEGER conc(nkn,ntr,3)
          INTEGER negs(nkn,ntr,3)
          INTEGER pick(nkn,ntr,3)
          INTEGER term(nkn,ntr,3)
          REAL score(3)
          REAL betas(3,0:(nkn+ntr))
        ! local
          INTEGER k
        ! arguments out

      ! record trees
        IF (score(1).LT.score(3)) THEN
          IF(accept.GT.0)THEN
          CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,-1,1,3)
          DO k=0,(nsep+ntr)
            betas(3,k)=betas(1,k)
          END DO
          END IF
        END IF
        IF(mcmc.GE.1)THEN
          CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,-1,2,3)
        END IF
        IF (accept.EQ.1) THEN
          CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,wh,1,2)
          DO k=0,(nsep+ntr)
            betas(2,k)=betas(1,k)
          END DO
        ELSE
          CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,wh,2,1)
          DO k=0,(nsep+ntr)
            betas(1,k)=betas(2,k)
          END DO
        END IF

      ! record scores
        IF (score(1).LT.score(3).and.accept.eq.1) score(3)=score(1)
        IF (accept.EQ.1) THEN
          score(2)=score(1)
        ELSE
          score(1)=score(2)
        END IF

      END 

      ! *****************************************************************
      ! *****************************************************************

      ! storing or restoring data after mtp 0
      ! name in slogic.f: restoring

      SUBROUTINE trestore(accept,wh,n1,nkn,ntr,storage,nwkv,wkv)
      IMPLICIT NONE

        ! arguments in
          INTEGER accept,n1,nkn,ntr,nwkv,wh
          INTEGER wkv(nkn)
        ! local
          INTEGER j,k,wkvj,pp,pp2
        ! arguments out
          INTEGER storage(2*ntr*nkn*n1)

      ! storing/restoring
        pp2=ntr*nkn*n1
        IF (accept.EQ.1) THEN
          DO j=1,nwkv
            wkvj=wkv(j)
            pp=(wh-1)*nkn*n1+(wkvj-1)*n1
            DO k=1,n1
              storage(pp2+pp+k)=storage(pp+k)
            END DO
          END DO
        ELSE
          DO j=1,nwkv
            wkvj=wkv(j)
            pp=(wh-1)*nkn*n1+(wkvj-1)*n1
            DO k=1,n1
              storage(pp+k)=storage(pp2+pp+k)
            END DO
          END DO
        END IF

      END

      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine calculates the score of the model under
      ! consideration
      ! name in slogic.f: scoring

      SUBROUTINE tscore(prtr,rsp,dcph,ordrs,weight,n1,ntr,mdl,nop,wh,
     #                   nsep,seps,score,betas,reject,xtxsep,mtm,nopold)
      IMPLICIT NONE

        ! parameters
          INTEGER LGCbetaMAX,mtm
          PARAMETER (LGCbetaMAX = 55)
        ! arguments in
          INTEGER mdl,n1,nop,nsep,ntr,wh
          INTEGER dcph(n1),ordrs(n1),nopold
          INTEGER prtr(n1,ntr)
          REAL rsp(n1),weight(n1)
          REAL seps(nsep,n1),xtxsep(0:nsep,0:nsep)
        ! local
          INTEGER j,oops
          REAL smbetas(0:LGCbetaMAX)
        ! arguments out
          INTEGER reject
          REAL score(3)
          REAL betas(0:(nsep+ntr))

      ! initialize
        DO j=0,nsep+ntr
          betas(j)=0.0
        END DO
        reject=0

      ! choose scoring function for model type
        IF (mdl.NE.1.AND.nopold.LE.nop)
     #    CALL tsingular(n1,nop,ntr,wh,prtr,nsep,seps,reject,mtm)
        IF (reject.EQ.0) THEN
          IF (mdl.EQ.0)THEN
          ! name of triofitting in slogic.f: My_own_fitting
            CALL triofitting(prtr,rsp,dcph,ordrs,weight,n1,ntr,
     #                        nop,wh,nsep,seps,score(1),smbetas,reject)
            DO j=0,(nsep+ntr)
              betas(j)=smbetas(j)
            END DO 
          END IF
        END IF

      END 

      ! *****************************************************************
      ! *****************************************************************

      ! this subroutine checks for singularities in the proposed model
      ! name in slogic.f: singularities

      SUBROUTINE tsingular(n1,nop,ntr,wh,prtr,nsep,seps,reject,mtm)
      IMPLICIT NONE

        ! arguments in
          INTEGER n1,nop,nsep,ntr,wh,prtr(n1,ntr),mtm
          REAL seps(nsep,n1)
        ! local
          INTEGER hmuch,sum1,TSUMI,j,k,l,m
          REAL nr1
        ! arguments out
          INTEGER reject,n4

      ! check for singularities in the predicted trees 
        reject=0
        n4=0
        sum1=0
        IF (nop.GT.0) THEN
          sum1=TSUMI(prtr,n1,ntr,1,wh,1,n1)
          nr1=REAL(n1)
          n4=INT(0.05*nr1)
          if(n4.gt.15)n4=15
          if(mtm.gt.0)n4=mtm
          IF (sum1.LT.n4.OR.sum1.GT.(n1-n4)) THEN
            reject=1
          END IF
        END IF

      ! check for singularities with other predictors 
        IF (reject.EQ.0.AND.nop.GT.1) THEN
          DO j=1,nop
            IF (j.NE.wh) THEN
              hmuch=0
              l=1
              m=-1
              IF(prtr(1,wh).EQ.prtr(1,j))l=0
              IF(prtr(1,wh).EQ.prtr(1,j))m= 1
              DO k=1,n1
                IF(prtr(k,wh).NE.(l+m*prtr(k,j)))GOTO 4000
              END DO 
              reject=1
              GOTO 1000
            END IF
 4000       CONTINUE
          END DO
        END IF
 1000   CONTINUE

        IF (reject.EQ.0.AND.nop.GE.1.AND.nsep.GT.0) THEN
          DO j=1,nsep
            DO k=1,n1
              IF((seps(j,k).NE.0.0).AND.(seps(j,k).NE.1.0))GOTO 3000
            END DO 
            l=1
            m=-1
            IF(prtr(1,wh).EQ.seps(j,1))l=0
            IF(prtr(1,wh).EQ.seps(j,1))m= 1
            DO k=1,n1
              IF(prtr(k,wh).NE.(l+m*seps(j,k))) GOTO 3000
            END DO 
            reject=1
            GOTO 2000
 3000       CONTINUE
          END DO
        END IF
 2000   CONTINUE
      END 


      ! *****************************************************************
      ! *****************************************************************



      ! this subroutine stores some variables needed in other routines
      ! name in slogic.f: storing

      SUBROUTINE tstore(nkn,ntr,conc,pick,npckmv,pickmv,ssize,nop)
      IMPLICIT NONE

        ! parameters 
        ! arguments in
          INTEGER nkn,ntr
          INTEGER conc(nkn,ntr,3)
          INTEGER pick(nkn,ntr,3)
        ! local
          INTEGER i,j,sibling
        ! arguments out
          INTEGER nop,ssize
          INTEGER npckmv(6,ntr)
          INTEGER pickmv(6,nkn,ntr)

      ! determine which moves we can make
        ssize=0
        nop=0
        DO j=1,ntr
          DO i=1,6
            npckmv(i,j)=0
          END DO
          DO i=1,nkn
            IF (pick(i,j,1).EQ.1) THEN
              nop=j
              IF (conc(i,j,1).EQ.3) THEN
                ssize=ssize+1
                npckmv(1,j)=npckmv(1,j)+1
                pickmv(1,npckmv(1,j),j)=i
                IF(i.EQ.1)THEN
                   npckmv(3,j)=npckmv(3,j)+1
                   pickmv(3,npckmv(3,j),j)=i
                ELSE
                   IF (MOD(i,2).EQ.0) THEN
                     sibling=i+1
                   ELSE
                      sibling=i-1
                   END IF
                   IF (conc(sibling,j,1).EQ.3) THEN
                     npckmv(3,j)=npckmv(3,j)+1
                     pickmv(3,npckmv(3,j),j)=i
                   END IF
                END IF
                IF(2*i.LE.nkn) THEN
                   npckmv(4,j)=npckmv(4,j)+1
                   pickmv(4,npckmv(4,j),j)=i
                END IF
              ELSE
                npckmv(2,j)=npckmv(2,j)+1
                pickmv(2,npckmv(2,j),j)=i
                IF(4*i.LE.nkn)THEN
                 IF((conc(2*i,j,1).EQ.3).AND.(conc(2*i+1,j,1).EQ.3))THEN
                     npckmv(5,j)=npckmv(5,j)+1
                     pickmv(5,npckmv(5,j),j)=i
                  END IF
                  IF(conc(2*i,j,1).EQ.3.AND.conc(4*i+2,j,1).EQ.3.AND.
     #               conc(4*i+3,j,1).EQ.3) THEN
                     npckmv(6,j)=npckmv(6,j)+1
                     pickmv(6,npckmv(6,j),j)=i
                  ELSE IF (conc(2*i+1,j,1).EQ.3.AND.conc(4*i,j,1).EQ.3
     #                      .AND.conc(4*i+1,j,1).EQ.3) THEN
                     npckmv(6,j)=npckmv(6,j)+1
                     pickmv(6,npckmv(6,j),j)= -i
                  END IF
                END IF
              END IF
            END IF
          END DO
        END DO
      END 

      !***************************************************************
      !***************************************************************

      ! This function calculates the sum of an array (integers)
      ! name in slogic.f: SUM2I

      INTEGER FUNCTION TSUMI(x,n1,n2,iin,f1,fr,tto)

        ! arguments in
          INTEGER n1,n2,iin,f1,fr,tto
          INTEGER x(n1,n2)
        ! local
          INTEGER j

      ! here it goes
        TSUMI=0   

        IF (iin.GT.2) CALL REXIT("Index in TSUMI bigger than 2")
        IF (iin.EQ.1) THEN
          DO j=fr,tto
            TSUMI=TSUMI+x(j,f1)
          ENDDO
        ELSE IF (iin.EQ.2) THEN
          DO j=fr,tto
            TSUMI=TSUMI+x(f1,j)
          ENDDO
        ENDIF

      END

      ! *****************************************************************
      ! *****************************************************************

      ! name in slogic.f: clearly
      
      SUBROUTINE tclearly(iearly,ntr,nkn,n2)
      
      ! parameters
          INTEGER ntr,nkn,n2
          INTEGER iearly(0:6,ntr,0:nkn,n2,0:1,2)
          INTEGER i,j,k,l
          DO i=1,ntr
            DO j=0,nkn
              DO k=1,n2
                DO l=0,6
                  iearly(l,i,j,k,0,1)=0
                  iearly(l,i,j,k,1,1)=0
                  iearly(l,i,j,k,0,2)=0
                  iearly(l,i,j,k,1,2)=0
                END DO
              END DO
            END DO
          END DO
          END 
      ! *****************************************************************
      ! *****************************************************************
    
      ! name in slogic.f: makeistring
      
      SUBROUTINE maketstring(k1,k2,astring,i,j)
      INTEGER i,j,k,k1,k2
      CHARACTER *40 aa
      CHARACTER *80 astring
      CALL makettstring(aa,i,j,k,0)
      astring(k1:k2)=aa(1:(k2-k1+1))
      END
      
      ! name in slogic.f: makerstring
      
      SUBROUTINE maketrstring(k1,k2,astring,rr,i,j)
      CHARACTER *20 aa,bb
      CHARACTER *80 astring
      REAL r,rr
      INTEGER i,j,p,k,l,s2,k3,ww
      ww=1
      IF(rr.LT.0.AND.rr.GT.(-9))ww=0
      r=rr
      s2=1
      IF(r.LT.0)THEN
         s= -r
      ELSE
         s=r
      END IF
      k=s
      if(r.LT.0)k=-k
      k3=k
      IF(j.GT.0)THEN
        k=s
        s=s-k
        DO k=1,j
           s2=s2*10
           s=s*10
        END DO
        k=(s+0.5)
      END IF
      IF(k.eq.s2)THEN
         k=0
         IF(r.GE.0)THEN
            k3=k3+1
         ELSE
            k3=k3-1
         END IF
      END IF
      CALL makettstring(bb,k3,i,p,0)
      aa(1:i)=bb(1:i)
      aa((i+1):(i+1))="."
      IF(j.GT.0)THEN
        CALL makettstring(bb,k,j,l,1)
        aa((i+2):(i+1+j))=bb(1:j)
      END IF
      IF(r.lt.0.and.k2.eq.0.and.i.gt.1)aa((i-1):(i-1))="-"
      IF(p.eq.1)THEN
        DO k=1,(i+j+1)
          aa((i+j):(i+j))="*"
        END DO
      END IF
      IF(ww.EQ.0.and.i.gt.1)aa((i-1):(i-1))="-"
      astring(k1:k2)=aa(1:(k2-k1+1))
      END
      
      ! name in slogic.f: makeiistring
      
      SUBROUTINE makettstring(aa,i,j,p,f)
      CHARACTER *20 aa
      INTEGER i,j,p,f
      INTEGER i2,k,l,m,n
      i2=i
      p=0
      DO k=1,20
         aa(k:k)=' '
      END DO
      IF(i.EQ.0) THEN
        IF(f.EQ.0) THEN
          aa(j:j)='0'
        ELSE
          DO k=1,20
            aa(k:k)='0'
          END DO
        END If
      ELSE
        IF(i.GE.0) THEN
          l=0
        ELSE
          l=1
          i2=-i2
        END IF
        m=0
        DO k=1,j
          i3=i2
          m=i2/10
          n=i2-10*m
          i2=m
          IF(i3.GT.0)THEN
            aa((j+1-k):(j+1-k))=char(48+n)
            IF(i2.EQ.0.AND.l.eq.1)THEN
              IF(k.NE.J)THEN
                aa((j-k):(j-k))='-'
              ELSE
                DO i4=1,j
                  aa(i4:i4)='*'
                END DO
                p=1
              END IF
            END IF
          ELSE
            IF(f.EQ.1)THEN
              aa((j+1-k):(j+1-k))="0"
            END IF
          END IF
        END DO
        IF(i2.ne.0)then
          DO i4=1,j
            aa(i4:i4)='*'
          END DO
          p=1
        END IF
      END IF
      END
      
      ! name in slogic.f: stringprint
      
      SUBROUTINE tprintstring(aa,i)
      CHARACTER *80 aa
      INTEGER i
      REAL k
      CALL realpr(aa,i,k,0)
      END
      
      ! name in slogic.f: reorder
      
      SUBROUTINE teorder(iotree,conc,term,negs,pick,ltree,k,j,nkn,
     #                   ntrnew)
      INTEGER iotree(1),ltree,k,j,nkn,ntrnew
      INTEGER conc(nkn,ntrnew,3)
      INTEGER negs(nkn,ntrnew,3)
      INTEGER pick(nkn,ntrnew,3)
      INTEGER term(nkn,ntrnew,3)
                    iotree((ltree-1)*(4*nkn+3)+(k-1)*4+4)=conc(k,j,3)
                    iotree((ltree-1)*(4*nkn+3)+(k-1)*4+5)=term(k,j,3)
                    iotree((ltree-1)*(4*nkn+3)+(k-1)*4+6)=negs(k,j,3)
                    iotree((ltree-1)*(4*nkn+3)+(k-1)*4+7)=pick(k,j,3)
      END
      
      ! name in slogic.f: smackonprior
      
      SUBROUTINE poorprior(score,ssize,ntr,nkn,
     #           hyperpars,n2,mtp,slprbc,rrat,nopdiff)
      IMPLICIT none
      INTEGER ssize,ntr,nkn,n2,mtp,nopdiff
      REAL hyperpars(10),score(3),slprbc(6),rrat
      DOUBLE PRECISION ourlog,postrat,rr,zz
      CALL gett(rr,ssize,ntr,nkn,n2)
      ! a simple hypergeometric prior
      score(1)=0.5*score(1)*exp(hyperpars(2))+hyperpars(1)*ssize
      hyperpars(10)=score(1)
      score(1)=score(1)+rr
      hyperpars(9)=score(1)
      hyperpars(8)=0.
      zz=(slprbc(3)-slprbc(2))/(slprbc(4)-slprbc(2)+slprbc(1))
      IF(mtp.GE.0)THEN
         postrat=1.
         IF(mtp.EQ.3)postrat=rrat/(8*n2)
         IF(mtp.EQ.4)postrat=8*n2*rrat
         IF(mtp.EQ.5)postrat=8*n2*rrat
         IF(mtp.EQ.6)postrat=rrat/(8*n2)
         IF(mtp.EQ.3.AND.ssize.EQ.0)postrat=1./(zz*(2*n2))
         IF(mtp.EQ.3.AND.nopdiff.GT.0)postrat=1./(zz*(2*n2))
         IF(mtp.EQ.0)postrat=(2*n2)*zz
         hyperpars(8)=ourlog(postrat)
      END IF
      END
      
      ! name in slogic.f: getv2
      
      SUBROUTINE gett2(nn,ssize,nkn,n2)
      DOUBLE PRECISION nn
      INTEGER i,nkn,n2,ssize
      DOUBLE PRECISION r1,r2,ourexp,ourlog
      nn=0.
      DO i=0,ssize
         CALL gett1(r1,i,nkn,n2)
         CALL gett1(r2,ssize-i,nkn,n2)
         nn=nn+ourexp(r1+r2)
      END DO
      nn=ourlog(nn)
      END
      
      ! name in slogic.f: getv3
      
      SUBROUTINE gett3(nn,ssize,nkn,n2)
      DOUBLE PRECISION nn
      INTEGER i,nkn,n2,ssize
      DOUBLE PRECISION r1,r2,ourexp,ourlog
      nn=0.
      DO i=0,ssize
         CALL gett1(r2,i,nkn,n2)
         CALL gett2(r1,ssize-i,nkn,n2)
         nn=nn+ourexp(r1+r2)
      END DO
      nn=ourlog(nn)
      END
      
      ! name in slogic.f: getv4
      
      SUBROUTINE gett4(nn,ssize,nkn,n2)
      DOUBLE PRECISION nn
      INTEGER i,nkn,n2,ssize
      DOUBLE PRECISION r1,r2,ourexp,ourlog
      nn=0.
      DO i=0,ssize
         CALL gett1(r1,i,nkn,n2)
         CALL gett3(r2,ssize-i,nkn,n2)
         nn=nn+ourexp(r1+r2)
      END DO
      nn=ourlog(nn)
      END
      
      ! name in slogic.f: getv5
      
      SUBROUTINE gett5(nn,ssize,nkn,n2)
      DOUBLE PRECISION nn
      INTEGER i,nkn,n2,ssize
      DOUBLE PRECISION r1,r2,ourexp,ourlog
      DO i=0,ssize
         CALL gett1(r1,i,nkn,n2)
         CALL gett4(r2,ssize-i,nkn,n2)
         nn=nn+ourexp(r1+r2)
      END DO
      nn=ourlog(nn)
      END
      
      ! name in slogic.f: getv
      
      SUBROUTINE  gett(ll,ssize,ntr,nkn,n2) 
      INTEGER ssize,ntr,nkn,n2
      DOUBLE PRECISION ll
      IF(ntr.EQ.1)THEN
         CALL gett1(ll,ssize,nkn,n2)
         goto 567
      END IF
      IF(ntr.EQ.2)THEN
         CALL gett2(ll,ssize,nkn,n2)
         goto 567
      END IF
      IF(ntr.EQ.3)THEN
         CALL gett3(ll,ssize,nkn,n2)
         GOTO 567
      END IF
      IF(ntr.EQ.4)THEN
         CALL gett4(ll,ssize,nkn,n2)
         GOTO 567
      END IF
      IF(ntr.EQ.3)THEN
         CALL gett5(ll,ssize,nkn,n2)
         GOTO 567
      END IF
567   CONTINUE
      END 
      
      ! name in slogic.f: getv1
      
      SUBROUTINE gett1(l,ssize,nb,n2)
      INTEGER ll,ssize,nb,precomp(25),n2
      DOUBLE PRECISION l,m,ourlog,r
      IF(ssize.GT.20)THEN
        ll=0
        GOTO 568
      END IF
      IF(ssize.LE.2)THEN
        ll=1
        GOTO 568
      END IF
      IF((ssize*2-1).GT.nb)THEN
        ll=0
        GOTO 568
      END IF
      precomp(3)=2
      IF(nb.LT.8)THEN
        precomp(4)=1
        ll=precomp(ssize)
        GOTO 568
      END IF
      precomp(4)=5
      IF(nb.LT.16)THEN
        precomp(5)=6
        precomp(6)=6
        precomp(7)=4
        precomp(8)=1
        ll=precomp(ssize)
        GOTO 568
      END IF
      precomp(5)=14
      IF(nb.LT.32)THEN
        precomp(6)=26
        precomp(7)=44
        precomp(8)=69
        precomp(9)=94
        precomp(10)=114
        precomp(11)=116
        precomp(12)=94
        precomp(13)=60
        precomp(14)=28
        precomp(15)=8
        precomp(16)=1
        ll=precomp(ssize)
        GOTO 568
      END IF
      precomp(6)=42
      IF(nb.LT.64)THEN
        precomp(7)=100
        precomp(8)=221
        precomp(9)=470
        precomp(10)=958
        precomp(11)=1860
        precomp(12)=3434
        precomp(13)=6036
        precomp(14)=10068
        precomp(15)=15864
        precomp(16)=23461
        precomp(17)=32398
        precomp(18)=41658
        precomp(19)=49700
        precomp(20)=54746
        ll=precomp(ssize)
        goto 568
      END IF
      precomp(7)=132
      IF(nb.LT.128)THEN
        precomp(8)=365
        precomp(9)=950
        precomp(10)=2398
        precomp(11)=5916
        precomp(12)=14290
        precomp(13)=33708
        precomp(14)=77684
        precomp(15)=175048
        precomp(16)=385741
        precomp(17)=831014
        precomp(18)=1749654
        precomp(19)=3598964
        precomp(20)=7228014
        ll=precomp(ssize)
        goto 568
      END IF
      precomp(8)=429
      IF(nb.LT.256)THEN
        precomp(9)=1302
        precomp(10)=3774
        precomp(11)=10652
        precomp(12)=29538
        precomp(13)=80812
        precomp(14)=218324
        precomp(15)=582408
        precomp(16)=1534301
        precomp(17)=3993030
        precomp(18)=10269590
        precomp(19)=26108844
        precomp(20)=65626918
        ll=precomp(ssize)
        GOTO 568
      END IF
      precomp(9)=1430
      precomp(10)=4862
      precomp(11)=16796
      precomp(12)=58786
      precomp(13)=208012
      precomp(14)=742900
      precomp(15)=2674440
      precomp(16)=9694845
      precomp(17)=35357670
      precomp(18)=129644790
      precomp(19)=477638700
      precomp(20)=1767263190
      ll=precomp(ssize)
568   CONTINUE
      l=ll
      l=ourlog(l)
      m=2.
      m=ourlog(m)
      r=n2
      IF(ssize.GT.0)THEN
        l=l+m*(2*ssize-1)+ssize*ourlog(r)
      END IF
      END
      
      ! name in slogic.f: storeone
      
      SUBROUTINE tstore1(mcmc,new,hyperpars,lvisit,visit,
     #           ntr,nkn,conc,negs,term,nac,rd1,rd2,rd3,rd4,
     #           bout,n2)
      IMPLICIT NONE
      INTEGER LGCn2MAX,LGCntrMAX
      PARAMETER(LGCn2MAX=1000,LGCntrMAX=5)
      INTEGER mcmc,new,nkn,ntr,i,j,k,n2,used1(LGCn2MAX)
      INTEGER conc(nkn,ntr,3),negs(nkn,ntr,3)
      INTEGER visit(2+ntr*nkn),term(nkn,ntr,3),nac,rd1(1)
      REAL lvisit(2),rd2(1),rd3(1)
      REAL hyperpars(10)
      INTEGER iz2,iz,jz,i2,rd4(1),zused
      INTEGER iz3,bout,xused(LGCntrMAX,LGCn2MAX),yused
      INTEGER vused(LGCntrMAX)
      IF(new.eq.nac)THEN
         new=0
      ELSE
         new=1
      END IF
      IF(nac.LT.-10) new=2
      IF(new.GT.0)THEN
        IF(new.NE.2)THEN
          DO i=1,n2
            used1(i)=0
          END DO
          visit(2)=visit(2)+mcmc-2
          DO i2=1,n2
            used1(i2)=0
          END DO
          jz=0
          DO i=1,ntr
            DO j=1,nkn
              IF(conc(j,i,3).EQ.3)THEN
                jz=jz+1
              END IF
            END DO
            DO i2=1,n2
              xused(i,i2)=0
            END DO
            DO i2=1,nkn
              IF(conc(i2,i,3).EQ.3)THEN
                xused(i,term(i2,i,3))=1
                used1(term(i2,i,3))=1
              END IF
            END DO
          END DO
          DO iz=1,n2
            IF(used1(iz).EQ.1)THEN
              rd2(iz)=rd2(iz)+visit(2)
            END IF
          END DO
          IF(bout.GE.2.or.bout.LE.(-2))THEN
            DO iz=1,(n2-1)
              IF(used1(iz).EQ.1)THEN
                DO iz2=(iz+1),n2
                  IF(used1(iz2).EQ.1)THEN
                    yused=0
                    DO i=1,ntr
                      vused(i)=xused(i,iz)*xused(i,iz2)
                      yused=yused+vused(i)
                    END DO
                    IF(yused.GT.0)THEN
                      rd3(iz2+(iz-1)*n2)=rd3(iz2+(iz-1)*n2)+visit(2)
                    END IF
                    IF(bout.GE.3.or.bout.LE.(-3).and.yused.GT.0)THEN
                      DO iz3=(iz2+1),n2
                        IF(used1(iz3).EQ.1)THEN
                          zused=0
                          DO i=1,ntr
                            zused=zused+vused(i)*xused(i,iz3)
                          END DO
                          IF(zused.GT.0)THEN
                            i2=iz3+(iz2-1)*n2+(iz-1)*n2*n2
                            rd4(i2)=rd4(i2)+visit(2)
                          END IF
                        END IF
                      END DO
                    END IF
                  END IF
                END DO
              END IF
            END DO
          END IF
          rd1(jz+1)=rd1(jz+1)+visit(2)
        END IF
        IF(new.EQ.2)THEN
          DO i=1,128
            rd1(i)=0
          END DO
          DO i=1,n2
            rd2(i)=0.
            DO j=1,n2
              rd3(i+(j-1)*n2)=0.
            END DO
          END DO
          lvisit(1)=0
          lvisit(2)=0
        END IF
        IF(bout.GT.0)THEN
          DO i=1,ntr
            DO j=1,nkn
              IF(conc(j,i,3).LT.3)THEN
                visit(2+(i-1)*nkn+j)=1000*conc(j,i,3)
              ELSE
                IF(negs(j,i,3).EQ.0)THEN
                  visit(2+(i-1)*nkn+j)=term(j,i,3)
                ELSE
                  visit(2+(i-1)*nkn+j)= -term(j,i,3)
                END IF
              END IF
            END DO
          END DO
          k=2+ntr*nkn
          CALL ctwrite(lvisit,visit,k)
        END IF
        lvisit(1)=hyperpars(9)
        lvisit(2)=hyperpars(10)
        visit(1)=1
        visit(2)=1
      ELSE
        visit(2)=visit(2)+mcmc-2
        visit(1)=visit(1)+1
        visit(2)=visit(2)+1
      END IF
      END 
      
      ! name in slogic.f: copytree
      
      SUBROUTINE tcopyingtree(ntr,nkn,conc,negs,pick,term,one,iin,iout)
      IMPLICIT NONE 
      INTEGER ntr,nkn,one,i1,i2,i3,i4,iin,iout
      INTEGER conc(nkn,ntr,3)
      INTEGER negs(nkn,ntr,3)
      INTEGER pick(nkn,ntr,3)
      INTEGER term(nkn,ntr,3)
      i3=one
      i4=one
      IF(one.LT.0)THEN
         i3=1
         i4=ntr
      END IF
      DO i1=1,nkn
        DO i2=1,i4
          conc(i1,i2,iout)=conc(i1,i2,iin)
          negs(i1,i2,iout)=negs(i1,i2,iin)
          pick(i1,i2,iout)=pick(i1,i2,iin)
          term(i1,i2,iout)=term(i1,i2,iin)
        END DO
      END DO
      END

      ! name in slogic.f: greedyonestep

      SUBROUTINE tgreedy1step(nkn,ntr,conc,negs,pick,term,n1,n2,
     #           storage,prtr,datri,nsep,seps,cbetas,xtxsep,mdl,
     #           nop,orders,dcph,rsp,weight,bestscore,mtm,cnc,
     #           penalty)
      IMPLICIT NONE
      INTEGER nkn,ntr,n1,n2,nsep,mdl,nop,mtm,cnc(3)
      INTEGER conc(nkn,ntr,3)
      INTEGER negs(nkn,ntr,3)
      INTEGER pick(nkn,ntr,3)
      INTEGER term(nkn,ntr,3)
      INTEGER storage(2*ntr*nkn*n1),orders(n1),dcph(n1)
      INTEGER prtr(n1,ntr),datri(n2,n1)
      REAL seps(nsep,n1),cbetas(0:(nsep+ntr)),xtxsep(0:nsep,0:nsep)
      REAL rsp(n1),weight(n1),bestscore,penalty

      INTEGER mtp,wh,knt,letter,op,neg,sng,dbl,improve,bestmove(3)
      INTEGER yes,l2
      improve=-1
      CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,-1,1,2)
      CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,-1,1,3)
      
      DO wh=1,nop
        DO mtp=1,6
          DO knt=1,nkn
            CALL thisisallowed(wh,mtp,knt,conc,nkn,ntr,yes,pick)
            IF(yes.GE.1)THEN
              CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,-1,2,1)
              letter=1
              op=1
              neg=1
              IF(mtp.EQ.1)THEN
                DO letter=1,n2
                  DO neg=0,1
                    IF(letter.NE.term(knt,wh,1).OR.
     #                     neg.NE.negs(knt,wh,1))THEN
                      l2=letter
                      CALL taltleaf(knt,n2,nkn,ntr,wh,negs,term,l2,neg)
                      IF(l2.LT.0)GOTO 391
                    
                      CALL tevalgreedy(nkn,ntr,conc,pick,negs,term,
     #                     mtp,n1,n2,wh,knt,storage,datri,prtr,mdl,
     #                     nsep,dcph,orders,mtm,rsp,weight,seps,
     #                     cbetas,xtxsep,nop,bestscore,improve,
     #                     0,bestmove,penalty)
                    END IF
                    CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,-1,
     #                   2,1)
                  END DO
391               CONTINUE
                END DO
              END IF
              IF(mtp.EQ.4.OR.mtp.EQ.5)THEN
                DO letter=1,n2
                  DO neg=0,1
                    DO op=1,2
                      l2=letter
                      IF(mtp.EQ.4)CALL tsplitting(knt,n2,nkn,ntr,wh,cnc,
     #                            conc,negs,pick,term,l2,op,neg)
                      IF(mtp.EQ.5)CALL tbranching(knt,n2,nkn,ntr,wh,cnc,
     #                            conc,negs,pick,term,l2,op,neg)
                      IF(l2.LT.0)GOTO 394
                      CALL tevalgreedy(nkn,ntr,conc,pick,negs,term,
     #                     mtp,n1,n2,wh,knt,storage,datri,prtr,mdl,
     #                     nsep,dcph,orders,mtm,rsp,weight,seps,
     #                     cbetas,xtxsep,nop,bestscore,improve,
     #                     0,bestmove,penalty)
                      CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,
     #                     -1,2,1)
                    END DO
                  END DO
394               CONTINUE
                END DO
              END IF
              IF(mtp.EQ.2.OR.mtp.EQ.3.OR.mtp.EQ.6)THEN
                IF(mtp.EQ.2)conc(knt,wh,1)=3-conc(knt,wh,1)
                IF(mtp.EQ.3)
     #              CALL tdeleting(knt,nkn,ntr,wh,conc,negs,pick,term)
                IF(mtp.EQ.6)THEN
                  IF(yes.EQ.1)THEN
                    sng=2*knt
                    dbl=2*knt+1
                  ELSE
                    sng=2*knt+1
                    dbl=2*knt
                  END IF
                  CALL tpruning(knt,dbl,sng,nkn,ntr,wh,conc,negs,
     #                 pick,term)
                END IF
                CALL tevalgreedy(nkn,ntr,conc,pick,negs,term,mtp,n1,
     #                     n2,wh,knt,storage,datri,prtr,mdl,nsep,dcph,
     #                     orders,mtm,rsp,weight,seps,cbetas,xtxsep,nop,
     #                     bestscore,improve,0,bestmove,penalty)
                CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,-1,2,1)
              END IF
            END IF
          END DO
        END DO
      END DO
      IF(nop.LT.ntr)THEN
         wh=nop+1
         knt=1
         mtp=0
         neg=0
         DO letter=1,n2
            CALL tstartknot(n2,nkn,ntr,wh,conc,negs,pick,term,
     #           letter,neg)
            CALL tevalgreedy(nkn,ntr,conc,pick,negs,term,mtp,n1,
     #                     n2,wh,knt,storage,datri,prtr,mdl,nsep,dcph,
     #                     orders,mtm,rsp,weight,seps,cbetas,xtxsep,nop,
     #                     bestscore,improve,0,bestmove,penalty)
            CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,-1,2,1)
         END DO
      END IF
      IF(improve.GE.0)THEN
        CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,-1,3,1)
        mtp=bestmove(1)
        wh=bestmove(2)
        knt=bestmove(3)
        CALL tevalgreedy(nkn,ntr,conc,pick,negs,term,mtp,n1,
     #                     n2,wh,knt,storage,datri,prtr,mdl,nsep,dcph,
     #                     orders,mtm,rsp,weight,seps,cbetas,xtxsep,nop,
     #                     bestscore,improve,1,bestmove,penalty)
        CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,-1,1,2)
        CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,-1,1,3)
      ELSE
         ntr=-10
      END IF
      END
      
      ! name in slogic.R: isallowed
      
      SUBROUTINE thisisallowed(wh,mtp,knt,conc,nkn,ntr,yes,pick)
      IMPLICIT NONE
          INTEGER wh,mtp,knt,nkn,ntr,yes
          INTEGER pick(nkn,ntr,3)
          INTEGER conc(nkn,ntr,3)
          INTEGER sibling
          yes=0
          IF(pick(knt,wh,1).EQ.1)THEN
          IF(conc(knt,wh,1).EQ.3)THEN
            IF(mtp.EQ.1)yes=1
            IF(mtp.EQ.3)THEN
              IF(nkn.EQ.1)THEN
                yes=1
              ELSE
                IF (MOD(knt,2).EQ.0) THEN
                  sibling=knt+1
                ELSE
                  sibling=knt-1
                END IF
                IF (conc(sibling,wh,1).EQ.3) yes=1
              END IF
            END IF
            IF(mtp.EQ.4)THEN
              IF(2*knt.LE.nkn)yes=1
            END IF
          ELSE
            IF(mtp.EQ.2)yes=1
            IF(4*knt.LE.nkn)THEN
              IF(mtp.EQ.5)THEN
                IF((conc(2*knt,wh,1).EQ.3).AND.
     #             (conc(2*knt+1,wh,1).EQ.3))yes=1
              END IF
              IF(mtp.EQ.6)THEN
                IF(conc(2*knt,wh,1).EQ.3.AND.conc(4*knt+2,wh,1).EQ.3
     #               .AND.conc(4*knt+3,wh,1).EQ.3) yes=1
                IF (conc(2*knt+1,wh,1).EQ.3.AND.conc(4*knt,wh,1).EQ.3
     #               .AND.conc(4*knt+1,wh,1).EQ.3) yes=2
              END IF
            END IF
          END IF
          END IF
          END
 
        ! name in slogic.f: evalgreed
 
        SUBROUTINE tevalgreedy(nkn,ntr,conc,pick,negs,term,mtp,n1,n2,wh,
     #                      knt,storage,datri,prtr,mdl,nsep,dcph,ordrs,
     #                      mtm,rsp,weight,seps,cbetas,xtxsep,nop,
     #                      bestscore,improve,oncemore,bestmove,penalty)

      IMPLICIT NONE
        INTEGER LGCnknMAX
        PARAMETER (LGCnknMAX  =   128)
        INTEGER nkn,ntr,mtp,n1,n2,wh,knt,nop
        INTEGER conc(nkn,ntr,3)
        INTEGER negs(nkn,ntr,3)
        INTEGER pick(nkn,ntr,3)
        INTEGER term(nkn,ntr,3)
        INTEGER storage(2*ntr*nkn*n1)
        INTEGER prtr(n1,ntr),datri(n2,n1),bestmove(3)
        INTEGER mdl,nsep,dcph(n1),ordrs(n1),mtm,improve,oncemore
        REAL seps(nsep,n1),cbetas(0:(nsep+ntr)),xtxsep(0:nsep,0:nsep)
        REAL weight(n1),bestscore,rsp(n1),penalty
      ! local

        REAL score(3)
        INTEGER ssize,nopold,reject
        INTEGER nwkv,wkv(LGCnknMAX),l1,l2
        nopold=nop
        CALL tgstore(nkn,ntr,conc,pick,ssize,nop)
        CALL tevaluate(wh,knt,mtp,n1,n2,nkn,ntr,conc,term,negs,
     #                  datri,prtr,storage,nwkv,wkv)
        reject=0
        CALL tscore(prtr,rsp,dcph,ordrs,weight,n1,ntr,mdl,nop,wh,
     #             nsep,seps,score,cbetas,reject,xtxsep,mtm,nopold)

       !   take care that the there is real convergence
        l1=0 
        l2=0
        
        IF(cbetas(1).GT. -10000.)l1=1
        IF(cbetas(1).LT. 10000.)l2=1
        IF(l1+l2.EQ.0)reject=1
        IF (reject.NE.1) THEN
        IF(mdl.EQ.2)THEN
          score(1)=score(1)+penalty/(REAL(n1))*ssize
        ELSE 
          score(1)=score(1)+penalty*ssize
        END IF
        IF(oncemore.EQ.0)THEN
          IF(reject.NE.1.AND.score(1).LT.bestscore)THEN
            CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,-1,1,3)
            bestscore=score(1)
            bestmove(1)=mtp
            bestmove(2)=wh
            bestmove(3)=knt
            improve=1
          END IF
          CALL trestore(0,wh,n1,nkn,ntr,storage,nwkv,wkv)
          CALL tgstore(nkn,ntr,conc,pick,ssize,nop)
        ELSE
          CALL trestore(1,wh,n1,nkn,ntr,storage,nwkv,wkv)
          CALL tgstore(nkn,ntr,conc,pick,ssize,nop)
        END IF
        ELSE
          CALL tcopyingtree(ntr,nkn,conc,negs,pick,term,-1,3,1)
        END IF
        END
      ! *****************************************************************
      ! *****************************************************************

      ! name in slogic.f: gstoring

      SUBROUTINE tgstore(nkn,ntr,conc,pick,ssize,nop)
      IMPLICIT NONE

        ! parameters 
        ! arguments in
          INTEGER nkn,ntr
          INTEGER conc(nkn,ntr,3)
          INTEGER pick(nkn,ntr,3)
        ! local
          INTEGER i,j
        ! arguments out
          INTEGER nop,ssize

      ! determine which moves we can make
        ssize=0
        nop=0
        DO j=1,ntr
          DO i=1,nkn
            IF (pick(i,j,1).EQ.1) THEN
              nop=j
              IF (conc(i,j,1).EQ.3) THEN
                ssize=ssize+1
              END IF
            END IF
          END DO
        END DO
      END 

      ! *****************************************************************
      ! *****************************************************************

      ! This routine solves a system
      ! name in slogic.f: lusolveph

      SUBROUTINE tsolveasystem(a,b,n,k,lda)
      IMPLICIT none

          ! parameters
          INTEGER lda,LGCbetaMAX
          PARAMETER (LGCbetaMAX   = 55)
          INTEGER n,k
          DOUBLE PRECISION a(lda,n)
          DOUBLE PRECISION b(n)
          INTEGER job,info
          INTEGER ipvt(LGCbetaMAX)
          job=0
          k=0
          if(n.GT.0)THEN
             CALL tgefa(a,lda,n,ipvt,info)
             IF(info.NE.0)THEN
               k=1
             ELSE
               CALL tgesl(a,lda,n,ipvt,b,job)
             END IF
          END IF

      END 
