% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_functions.R
\name{get_results_for_object}
\alias{get_results_for_object}
\title{Compute Results From Function Call with Object as Argument}
\usage{
get_results_for_object(obj, obj_arg_name, fun, ...,
  tolerate_warnings = TRUE)
}
\arguments{
\item{obj}{\code{list} R object to be trimmed. _MUST_ inherit from the
'list' class.}

\item{obj_arg_name}{\code{character} what is the name of the parameter, that
'obj' must be set to, when invoking 'fun'. Defaults to NULL, in which case
the function assumes, that the 'obj' matches the first parameter of 'fun'.}

\item{fun}{\code{function} function that must return the same results, when
invoked with 'obj' both before and after trimming.}

\item{...}{other (named) arguments for 'fun'.}

\item{tolerate_warnings}{\code{logical} tolerate warnings (=TRUE) Or
not (=FALSE) from function call results?}
}
\value{
results from function call.
}
\description{
Compute Results From Function Call with Object as Argument
}
