% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conn_web.R
\name{webConn}
\alias{webConn}
\title{Initialize a Web Connection}
\usage{
webConn(user = NULL, ip = NULL, serverDir = "/srv/shiny-server",
  name = NULL)
}
\arguments{
\item{user}{the username to log on to the web server}

\item{ip}{the IP address of the web server - if \code{NULL}, it is assumed that your web server is on the same machine that you are working on}

\item{serverDir}{the directory where Shiny apps go on the web server - defaults to the default location of /srv/shiny-server}

\item{name}{the name of the directory in \code{serverDir} under which to store the application - if not supplied, it defaults to the name provided in the vdb connection}
}
\description{
Initialize a connection to a web server where Shiny apps are served.
}
\examples{
library(ggplot2)

vdbConn(tempfile(), autoYes = TRUE)

# make a simple display
d <- divide(iris, by = "Species")
makeDisplay(d, name = "sl_vs_sw",
  panelFn = function(x)
    qplot(Sepal.Width, Sepal.Length, data = x))

\dontrun{
# to sync to a server 'myshinyserver.org' with login 'user'
# need: passwordless ssh for user@myshinyserver.org)
# need: rsync installed on local machine
# (these should both be easy to do with local linux / OS X)

# set up a connection to a shiny server
webConn(user = "hafen", ip = "myshinyserver.org", name = "myapp")

# webSync() uses rsync to sync your local vdb
# to the one on your shiny server pointed to with webConn()
webSync()

# if shiny server is running on the remote on port 3838
# then the VDB will now be viewable at
browseURL("http://myshinyserver.org:3838/myapp")
}
}
\seealso{
\code{\link{webSync}}
}
