% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/treescape.R
\name{treescape}
\alias{treescape}
\title{Phylogenetic tree exploration}
\usage{
treescape(x, method = treeVec, nf = NULL, ...)
}
\arguments{
\item{x}{an object of the class multiPhylo}

\item{method}{a function outputting the summary of a tree (phylo object) in the form of a vector}

\item{nf}{the number of principal components to retain}

\item{...}{further arguments to be passed to \code{method}}
}
\description{
Compares phylogenetic trees and maps them into a small number of dimensions for easy visualisation and identification of clusters.
}
\examples{
## generate list of trees
x <- rmtree(10, 20)
names(x) <- paste("tree", 1:10, sep = "")

## use treescape
res <- treescape(x, nf=3)
table.paint(as.matrix(res$D))
scatter(res$pco)

data(woodmiceTrees)
woodmiceDists <- treescape(woodmiceTrees,nf=3)
plot(woodmiceDists$pco$li[,1],woodmiceDists$pco$li[,2])
woodmicedf <- woodmiceDists$pco$li
if(require(ggplot2)){
woodmiceplot <- ggplot(woodmicedf, aes(x=A1, y=A2)) # create plot
woodmiceplot + geom_density2d(colour="gray80") + # contour lines
geom_point(size=6, shape=1, colour="gray50") + # grey edges
geom_point(size=6, alpha=0.2, colour="navy") + # transparent blue points
xlab("") + ylab("") + theme_bw(base_family="") # remove axis labels and grey background
}
\dontrun{
if(require(rgl)){
plot3d(woodmicedf[,1], woodmicedf[,2], woodmicedf[,3], type="s", size=1.5,
col="navy", alpha=0.5, xlab="", ylab="", zlab="")
}
}
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}, Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}

