% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_friedman1.R
\name{gen_friedman1}
\alias{gen_friedman1}
\title{Friedman benchmark data}
\usage{
gen_friedman1(n = 100, nx = 10, sigma = 0.1)
}
\arguments{
\item{n}{Integer specifying the number of samples (i.e., rows) to
generate. Default is 100.}

\item{nx}{Integer specifying the number of predictor variables to generate.
Default is 10. Note that \code{nx >= 5}.}

\item{sigma}{Numeric specifying the standard deviation of the standard 
Gaussian noise.}
}
\value{
A data frame with \code{n} rows and \code{nx} + 1 columns (for
\code{nx} features and the response).
}
\description{
Simulate data from the Friedman 1 benchmark problem. See
\code{\link[mlbench]{mlbench.friedman1}} for details and references.
}
\examples{
set.seed(2319)  # for reproducibility
friedman1 <- gen_friedman1(nx = 5)
pairs(friedman1, col = "purple2")
}
