% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_multilocus.R
\name{get_tip_labels_tree_list}
\alias{get_tip_labels_tree_list}
\title{Get all the tip labels of a `multiPhylo` object}
\usage{
get_tip_labels_tree_list(multi_tree)
}
\arguments{
\item{multi_tree}{an object of class `multiPhylo`}
}
\value{
a list of the same length as `multi_tree` with only the tip labels
}
\description{
Get all the tip labels of a `multiPhylo` object
}
\details{
Retrieves the member "tip.label" from each tree in multi_tree
}
\examples{
mu <- 0.5
lambda <- 1.0
nt <- 6
tr <- sim_sptree_bdp(sbr = lambda, sdr = mu, numbsim = 5, n_tips = nt)
tips_of_tr <- get_tip_labels_tree_list(tr)
}
