% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seascorr.R
\name{seascorr}
\alias{seascorr}
\title{Seasonal (partial) correlation analysis}
\usage{
seascorr(
  chrono,
  climate,
  var_names = NULL,
  timespan = NULL,
  complete = 9,
  season_lengths = c(1, 3, 6),
  primary = 1,
  secondary = 2,
  ci = 0.05
)
}
\arguments{
\item{chrono}{\code{data.frame} containing a tree-ring
chronologies, e.g. as obtained by \code{chron} of package dplR.}

\item{climate}{either a \code{data.frame} or \code{matrix} with
climatic data in monthly resolution, with year, month and
climate parameters in columns (all columns except year and month
will be recognized as parameters for response or correlation
functions), or a single \code{data.frame} or \code{matrix} in
13-column format (see below), or a (potentially named) list of
one or several of the latter.}

\item{var_names}{\code{character} vector with variable
names. Defaults to corresponding column names of parameter \code{climate} if
given as \code{data.frame}, or its names if given as \code{list}.}

\item{timespan}{\code{integer} vector of length 2 specifying the
time interval (in years) to be considered for analysis. Defaults
to the maximum possible interval.}

\item{complete}{\code{integer} scalar, month when tree-ring growth
is expected to have finished.}

\item{season_lengths}{\code{numeric} vector giving the lengths of
the seasons for variable grouping}

\item{primary}{position \code{numeric} or name \code{character} of
primary climate variable}

\item{secondary}{position \code{numeric} or name \code{character}
of secondary climate variable}

\item{ci}{\code{numerical} value to set the test level for
significance test (values 0.01, 0.05 and 0.1 are allowed); the
confidence intervals are adapted accordingly.}
}
\value{
'seascorr' returns an 'object' of class '"tc_seascorr"'.

The 'plot' function is used to obtain a plot of the results.

An object of class '"tc_seascorr"' is a list containing at least
  the following components:

\item{call}{the call made to 'seascorr'}

\item{seasons}{a list of length n, where n is the number of season
  lengths provided; each list element consists of a data.frame
  with end month, correlation coefficient and significance flag}

\item{truncated}{the input data truncated to the common timespan
  or the specified timespan}

\item{original}{the original input data, with the climate data
  being recast into a single data.frame}
}
\description{
Calculate seasonal correlation with primary and secondary climate
variables and tree-ring data, similar to the seascorr function for
MATLAB.
}
\details{
This function mimicks the behaviour of the MATLAB function
seascorr (Meko et al. 2011), which calculates partial correlations
of tree-ring data with a primary and a secondary climatic variable
for seasons of different lengths.
  
Input chronology data can be a \code{data.frame} such as produced
by function \code{chron} of package dplR. It has to be a
\code{data.frame} with at least one column containing the
tree-ring indices, and the corresponding years as \code{rownames}.
  
For climatic input data, there are three possibilities: Firstly,
input climatic data can be a \code{data.frame} or \code{matrix}
consisting of at least 3 rows for years, months and at least one
climate parameter in the given order. Secondly, input climatic
data can be a single \code{data.frame} or \code{matrix} in the
style of the original DENDROCLIM2002 input data, i.e. one
parameter with 12 months in one row, where the first column
represents the year. Or thirdly, input climatic data can be a list
of several of the latter described \code{data.frame} or
\code{matrices}. As an internal format dispatcher checks the
format automatically, it is absolutely necessary that in all three
cases, only complete years (months 1-12) are provided. It is not
possible to mix different formats in one go.
  
The `complete` parameter specifies the months of the current year
in which tree-growth is assumed to finish. This month marks the
last month of the first season, and starting from here, 14
different seasons are computed for each specified season length in
one-month steps. E.g., for a starting value of 9 (current
September) and season length of 3 months, the first season
comprises current July to current September, the second season
comprises current June to current August, and the last season
comprises previous June to previous August. This results in 14
seasons for a given season length. An arbitrary number of season
lengths can be specified.
  
The choice for primary vs. secondary variable can be made either
via numeric selection (the integer value 1 stands for the first
variable in the supplied climate data set), or by name ("temp",
when one of the variables is named "temp"). The correlation of the
primary variable with tree-growth is computed as the simple
(Pearson) correlation coefficient, while the influence of the
secondary variable on tree-growth is computed with the influence
of the primary variable on tree-growth removed.
  
Like in the original seascorr program, the significance of each
(partial) correlation is evaluated using exact bootstrapping by
circulant embedding of the tree-ring data (Percival \&
Constantine, 2006).
}
\examples{
sc <- seascorr(muc_fake, muc_clim)
sc
plot(sc)
}
\references{
Meko DM, Touchan R, Anchukaitis KJ (2011) Seascorr: A MATLAB
  program for identifying the seasonal climate signal in an annual
  tree-ring time series. Computers & Geosciences, 37, 1234-1241.

Percival DB, Constantine WLB (2006) Exact simulation of Gaussian
  Time Series from Nonparametric Spectral Estimates with
  Application to Bootstrapping. Statistics and Computing 16:25-35
}
\author{
Christian Zang; the procedure incl. exact bootstrapping
was implemented first by Dave Meko in MATLAB
}
