% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.oth.R
\name{bin.oth}
\alias{bin.oth}
\title{Recategorization of Variables by Mapping Tables Within a List}
\usage{
bin.oth(list, data)
}
\arguments{
\item{list}{A list generated from the tree.bins() function or created by the user to the specifications laid out in the description.}

\item{data}{A data.frame.}
}
\description{
The functions purpose is to recategorize a data.frame's variables
by the elements identified in a list. Each element of the list must contain two columns.
The first column contains the original values, and the second column contains the new values.
The first column name of each element of the list must be a variable name in the data.frame.
Effectively, each element of the list is a mapping table. The list generated from the tree.bins()
function can be directly passed as an element to this function.
}
\examples{
#Allows the user to generate a list from the tree.bins() function
sample.df <- AmesImpFctrs[, c("Neighborhood", "MS.Zoning", "SalePrice")]
lookup.list <- tree.bins(data = sample.df, y = SalePrice, return = "lkup.list")

#Create a new data.frame and use the created list to map recategorize its values
new.df <- head(AmesImpFctrs[, c("Neighborhood", "MS.Zoning", "Lot.Shape", "SalePrice")], 100)
oth.binned.df <- bin.oth(list = lookup.list, data = new.df)
}
\seealso{
\code{\link[tree.bins]{tree.bins}}, \code{\link[forcats]{fct_relevel}}, \code{\link[base]{factor}}, \code{\link[dplyr]{left_join}}
}
\keyword{factor}
\keyword{relevel}
\keyword{rpart}
