% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitMarginalDistributions.R
\name{fit_marginalNB}
\alias{fit_marginalNB}
\title{Fist a negative binomial distribution as marginal law}
\usage{
fit_marginalNB(x, LM, plotdiag = FALSE)
}
\arguments{
\item{x}{vector of equidistant time series data}

\item{LM}{Lebesgue measure of the estimated trawl}

\item{plotdiag}{binary variable specifying whether or not diagnostic plots
should be provided}
}
\value{
m: parameter in the negative binomial marginal distribution

theta: parameter in the negative binomial marginal distribution

a: Here \eqn{a=\theta/(1-\theta)}. This is given for an alternative
 parametrisation of the  negative binomial marginal distribution
}
\description{
Fist a negative binomial distribution as marginal law
}
\details{
The moment estimator for the parameters of the negative binomial
 distribution are given by \deqn{\hat \theta = 1-\mbox{E}(X)/\mbox{Var}(X),}
 and \deqn{\hat m = \mbox{E}(X)(1-\hat \theta)/(\widehat{ \mbox{LM}} \hat
 \theta).}
}
\examples{
\donttest{
#Simulate a univariate trawl process and fit the exponential trawl function
#and the marginal negative binomial law
set.seed(1)
t <- 1000
Delta <- 1
m<-200
theta<-0.5
lambda <- 0.25
#Simulate a univariate trawl process with exponential trawl function and
#negative binomial marginal law
trawl <- sim_UnivariateTrawl(t,Delta,burnin=50,marginal =c("NegBin"),trawl
="Exp",m=m, theta=theta, lambda1=lambda)
#Fit the exponential trawl function to the simulated data
fittrawlfct <- fit_Exptrawl(trawl,Delta, plotacf=TRUE,lags=500)
#Fit the Poisson marginal law
fitmarginallaw <- fit_marginalNB(trawl, fittrawlfct$LM, plotdiag=TRUE)
#Print the results
print(paste("lambda: estimated:", fittrawlfct$lambda, ", theoretical:",
lambda))
print(paste("m: estimated:", fitmarginallaw$m, ", theoretical:", m))
print(paste("theta: estimated:", fitmarginallaw$theta, ", theoretical:",
theta))
}
}
