% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssList.R
\name{xpssList}
\alias{xpssList}
\title{Displays the content of variables.}
\usage{
xpssList(x, variables = colnames(x), cases = list(from = 1, to = nrow(x), by = 1))
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class \code{xpssFrame}.}

\item{variables}{atomic character or character vector with the names of the variables.}

\item{cases}{list containing the arguments from, to, by. All parameters are atomic numerics. See Details for more.}
}
\value{
A data.frame with case values for specified variables in the dataset. If cases and variables are not specified, List return the complete dataset. If cases are specified the output is a user-defined sequence.
}
\description{
R implementation of the SPSS \code{LIST} Function
}
\details{
LIST displays the content of selected variables. It is possible to display a sequence with the \code{cases} argument.\code{from} determine the begin of the sequence, \code{to} determine the end of the sequence. \code{by} determine the increment of the sequence.
}
\examples{
data(fromXPSS)

xpssList(x=fromXPSS)

xpssList(x=fromXPSS,
   variables = "V1")

xpssList(x=fromXPSS,
   variables = c("V1","V2"))


xpssList(x=fromXPSS,
   variables = span(fromXPSS,
                 from="V1",
                 to="V4"),
   cases =list(from=2,
               to=18,
               by=2))
}
\author{
Bastian Wiessner
}

