% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssComputeMissings.R
\name{computeSysmis}
\alias{computeSysmis}
\title{Displays if a variable contains system-missing values}
\usage{
computeSysmis (x, variable = NULL)
}
\arguments{
\item{x}{a (non-empty) data.frame, data.table object or input data of class "xpssFrame".}

\item{variable}{atomic character with the name of the variable.}
}
\value{
atomic numeric with the length of the data. Returns the amount of system missing values of the variable.
}
\description{
R implementation of the SPSS \code{Sysmis} Function
}
\details{
Performs a missing value operation. Displays only the amount of system missing values of the variable instead of looking after all missing values only system-missings get inspected.

\code{variable} is limited to one variable.
}
\examples{
data(fromXPSS)

xpssCompute(x=fromXPSS, variables="V7_2",fun="computeSysmis")
}
\author{
Bastian Wiessner
}
\seealso{
Related Functions \code{\link{computeMiss}} , \code{\link{computeNmiss}} , \code{\link{computeNvalid}} ,\code{\link{computeValue}}
}
\keyword{internal}

